/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;
import org.openapitools.codegen.languages.features.SwaggerUIFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.SplitStringLambda;
import org.openapitools.codegen.templating.mustache.SpringHttpStatusLambda;
import org.openapitools.codegen.templating.mustache.TrimWhitespaceLambda;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures,
OptionalFeatures,
SwaggerUIFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(SpringCodegen.class);
    public static final String TITLE = "title";
    public static final String SERVER_PORT = "serverPort";
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String INTERFACE_ONLY = "interfaceOnly";
    public static final String USE_FEIGN_CLIENT_URL = "useFeignClientUrl";
    public static final String USE_FEIGN_CLIENT = "useFeignClient";
    public static final String DELEGATE_PATTERN = "delegatePattern";
    public static final String SINGLE_CONTENT_TYPES = "singleContentTypes";
    public static final String VIRTUAL_SERVICE = "virtualService";
    public static final String SKIP_DEFAULT_INTERFACE = "skipDefaultInterface";
    public static final String GENERATE_CONSTRUCTOR_WITH_REQUIRED_ARGS = "generatedConstructorWithRequiredArgs";
    public static final String RESOURCE_FOLDER = "resourceFolder";
    public static final String RESOURCE_FOLDER_DESC = "resource folder for generated resources";
    public static final String ASYNC = "async";
    public static final String REACTIVE = "reactive";
    public static final String SSE = "serverSentEvents";
    public static final String RESPONSE_WRAPPER = "responseWrapper";
    public static final String USE_TAGS = "useTags";
    public static final String SPRING_BOOT = "spring-boot";
    public static final String SPRING_CLOUD_LIBRARY = "spring-cloud";
    public static final String SPRING_HTTP_INTERFACE = "spring-http-interface";
    public static final String API_FIRST = "apiFirst";
    public static final String SPRING_CONTROLLER = "useSpringController";
    public static final String HATEOAS = "hateoas";
    public static final String RETURN_SUCCESS_CODE = "returnSuccessCode";
    public static final String UNHANDLED_EXCEPTION_HANDLING = "unhandledException";
    public static final String USE_RESPONSE_ENTITY = "useResponseEntity";
    public static final String USE_ENUM_CASE_INSENSITIVE = "useEnumCaseInsensitive";
    public static final String USE_SPRING_BOOT3 = "useSpringBoot3";
    public static final String REQUEST_MAPPING_OPTION = "requestMappingMode";
    public static final String USE_REQUEST_MAPPING_ON_CONTROLLER = "useRequestMappingOnController";
    public static final String USE_REQUEST_MAPPING_ON_INTERFACE = "useRequestMappingOnInterface";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    protected String title = "OpenAPI Spring";
    protected String configPackage = "org.openapitools.configuration";
    protected String basePackage = "org.openapitools";
    protected String resourceFolder = this.projectFolder + "/resources";
    protected boolean interfaceOnly = false;
    protected boolean useFeignClientUrl = true;
    protected boolean delegatePattern = false;
    protected boolean delegateMethod = false;
    protected boolean singleContentTypes = false;
    protected boolean async = false;
    protected boolean reactive = false;
    protected boolean sse = false;
    protected String responseWrapper = "";
    protected boolean skipDefaultInterface = false;
    protected boolean useTags = false;
    protected boolean useBeanValidation = true;
    protected boolean performBeanValidation = false;
    protected boolean apiFirst = false;
    protected boolean useOptional = false;
    protected boolean virtualService = false;
    protected boolean hateoas = false;
    protected boolean returnSuccessCode = false;
    protected boolean unhandledException = false;
    protected boolean useSpringController = false;
    protected boolean useSwaggerUI = true;
    protected boolean useResponseEntity = true;
    protected boolean useEnumCaseInsensitive = false;
    protected boolean useSpringBoot3 = false;
    protected boolean generatedConstructorWithRequiredArgs = true;
    protected RequestMappingMode requestMappingMode = RequestMappingMode.controller;

    public SpringCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, new SecurityFeature[]{SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.ApiKey, SecurityFeature.BasicAuth})).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code/javaSpring";
        this.templateDir = "JavaSpring";
        this.embeddedTemplateDir = "JavaSpring";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-spring";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.apiTestTemplateFiles.clear();
        this.additionalProperties.put("jackson", "true");
        this.additionalProperties.put("openbrace", OPEN_BRACE);
        this.additionalProperties.put("closebrace", CLOSE_BRACE);
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(CONFIG_PACKAGE, "configuration package for generated code").defaultValue(this.getConfigPackage()));
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package (invokerPackage) for generated code").defaultValue(this.getBasePackage()));
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the server files.", this.interfaceOnly));
        this.cliOptions.add(CliOption.newBoolean(USE_FEIGN_CLIENT_URL, "Whether to generate Feign client with url parameter.", this.useFeignClientUrl));
        this.cliOptions.add(CliOption.newBoolean(DELEGATE_PATTERN, "Whether to generate the server files using the delegate pattern", this.delegatePattern));
        this.cliOptions.add(CliOption.newBoolean(SINGLE_CONTENT_TYPES, "Whether to select only one produces/consumes content-type by operation.", this.singleContentTypes));
        this.cliOptions.add(CliOption.newBoolean(SKIP_DEFAULT_INTERFACE, "Whether to skip generation of default implementations for java8 interfaces", this.skipDefaultInterface));
        this.cliOptions.add(CliOption.newBoolean(ASYNC, "use async Callable controllers", this.async));
        this.cliOptions.add(CliOption.newBoolean(REACTIVE, "wrap responses in Mono/Flux Reactor types (spring-boot only)", this.reactive));
        this.cliOptions.add(new CliOption(RESPONSE_WRAPPER, "wrap the responses in given type (Future, Callable, CompletableFuture,ListenableFuture, DeferredResult, RxObservable, RxSingle or fully qualified type)"));
        this.cliOptions.add(CliOption.newBoolean(VIRTUAL_SERVICE, "Generates the virtual service. For more details refer - https://github.com/virtualansoftware/virtualan/wiki"));
        this.cliOptions.add(CliOption.newBoolean(USE_TAGS, "use tags for creating interface and controller classnames", this.useTags));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean("performBeanValidation", "Use Bean Validation Impl. to perform BeanValidation", this.performBeanValidation));
        this.cliOptions.add(CliOption.newBoolean(API_FIRST, "Generate the API from the OAI spec at server compile time (API first approach)", this.apiFirst));
        this.cliOptions.add(CliOption.newBoolean("useOptional", "Use Optional container for optional parameters", this.useOptional));
        this.cliOptions.add(CliOption.newBoolean(HATEOAS, "Use Spring HATEOAS library to allow adding HATEOAS links", this.hateoas));
        this.cliOptions.add(CliOption.newBoolean(RETURN_SUCCESS_CODE, "Generated server returns 2xx code", this.returnSuccessCode));
        this.cliOptions.add(CliOption.newBoolean(SPRING_CONTROLLER, "Annotate the generated API as a Spring Controller", this.useSpringController));
        CliOption requestMappingOpt = new CliOption(REQUEST_MAPPING_OPTION, "Where to generate the class level @RequestMapping annotation.").defaultValue(this.requestMappingMode.name());
        for (RequestMappingMode mode : RequestMappingMode.values()) {
            requestMappingOpt.addEnum(mode.name(), mode.getDescription());
        }
        this.cliOptions.add(requestMappingOpt);
        this.cliOptions.add(CliOption.newBoolean(UNHANDLED_EXCEPTION_HANDLING, "Declare operation methods to throw a generic exception and allow unhandled exceptions (useful for Spring `@ControllerAdvice` directives).", this.unhandledException));
        this.cliOptions.add(CliOption.newBoolean("useSwaggerUI", "Open the OpenApi specification in swagger-ui. Will also import and configure needed dependencies", this.useSwaggerUI));
        this.cliOptions.add(CliOption.newBoolean(USE_RESPONSE_ENTITY, "Use the `ResponseEntity` type to wrap return values of generated API methods. If disabled, method are annotated using a `@ResponseStatus` annotation, which has the status of the first response declared in the Api definition", this.useResponseEntity));
        this.cliOptions.add(CliOption.newBoolean(USE_ENUM_CASE_INSENSITIVE, "Use `equalsIgnoreCase` when String for enum comparison", this.useEnumCaseInsensitive));
        this.cliOptions.add(CliOption.newBoolean(USE_SPRING_BOOT3, "Generate code and provide dependencies for use with Spring Boot 3.x. (Use jakarta instead of javax in imports). Enabling this option will also enable `useJakartaEe`.", this.useSpringBoot3));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_CONSTRUCTOR_WITH_REQUIRED_ARGS, "Whether to generate constructors with required args for models", this.generatedConstructorWithRequiredArgs));
        this.cliOptions.add(new CliOption(RESOURCE_FOLDER, RESOURCE_FOLDER_DESC).defaultValue(this.getResourceFolder()));
        this.supportedLibraries.put(SPRING_BOOT, "Spring-boot Server application.");
        this.supportedLibraries.put(SPRING_CLOUD_LIBRARY, "Spring-Cloud-Feign client with Spring-Boot auto-configured settings.");
        this.supportedLibraries.put(SPRING_HTTP_INTERFACE, "Spring 6 HTTP interfaces (testing)");
        this.setLibrary(SPRING_BOOT);
        CliOption library = new CliOption("library", "library template (sub-template)").defaultValue(SPRING_BOOT);
        library.setEnum(this.supportedLibraries);
        this.cliOptions.add(library);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "spring";
    }

    @Override
    public String getHelp() {
        return "Generates a Java SpringBoot Server application using the SpringDoc integration.";
    }

    @Override
    public DocumentationProviderFeatures.DocumentationProvider defaultDocumentationProvider() {
        return this.isLibrary(SPRING_HTTP_INTERFACE) ? null : DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC;
    }

    @Override
    public List<DocumentationProviderFeatures.DocumentationProvider> supportedDocumentationProvider() {
        ArrayList<DocumentationProviderFeatures.DocumentationProvider> supportedProviders = new ArrayList<DocumentationProviderFeatures.DocumentationProvider>();
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.NONE);
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.SOURCE);
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX);
        supportedProviders.add(DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC);
        return supportedProviders;
    }

    @Override
    public List<DocumentationProviderFeatures.AnnotationLibrary> supportedAnnotationLibraries() {
        ArrayList<DocumentationProviderFeatures.AnnotationLibrary> supportedLibraries = new ArrayList<DocumentationProviderFeatures.AnnotationLibrary>();
        supportedLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.NONE);
        supportedLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1);
        supportedLibraries.add(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER2);
        return supportedLibraries;
    }

    private boolean selectedDocumentationProviderRequiresSwaggerUiBootstrap() {
        return this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX) || this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.SOURCE);
    }

    @Override
    public void processOpts() {
        List configOptions = this.additionalProperties.entrySet().stream().filter(e -> !Arrays.asList(API_FIRST, "hideGenerationTimestamp").contains(e.getKey())).filter(e -> this.cliOptions.stream().map(CliOption::getOpt).anyMatch(opt -> opt.equals(e.getKey()))).map(e -> Pair.of((Object)((String)e.getKey()), (Object)e.getValue().toString())).collect(Collectors.toList());
        this.additionalProperties.put("configOptions", configOptions);
        this.reservedWords.remove("file");
        this.LOGGER.info("----------------------------------");
        if (!this.additionalProperties.containsKey("dateLibrary")) {
            this.setDateLibrary("java8");
        }
        if (!this.additionalProperties.containsKey(BASE_PACKAGE) && this.additionalProperties.containsKey("invokerPackage")) {
            this.setBasePackage((String)this.additionalProperties.get("invokerPackage"));
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            this.LOGGER.info("Set base package to invoker package ({})", (Object)this.basePackage);
        }
        if (this.additionalProperties.containsKey(REQUEST_MAPPING_OPTION)) {
            RequestMappingMode optValue = RequestMappingMode.valueOf(String.valueOf(this.additionalProperties.get(REQUEST_MAPPING_OPTION)));
            this.setRequestMappingMode(optValue);
            this.additionalProperties.remove(REQUEST_MAPPING_OPTION);
        }
        this.useOneOfInterfaces = true;
        this.legacyDiscriminatorBehavior = false;
        super.processOpts();
        if (SPRING_HTTP_INTERFACE.equals(this.library)) {
            this.documentationProvider = DocumentationProviderFeatures.DocumentationProvider.NONE;
            this.annotationLibrary = DocumentationProviderFeatures.AnnotationLibrary.NONE;
            this.useJakartaEe = true;
            this.useBeanValidation = false;
            this.performBeanValidation = false;
            this.additionalProperties.put("useJakartaEe", this.useJakartaEe);
            this.additionalProperties.put("useBeanValidation", this.useBeanValidation);
            this.additionalProperties.put("performBeanValidation", this.performBeanValidation);
            this.additionalProperties.put("documentationProvider", this.documentationProvider.toCliOptValue());
            this.additionalProperties.put(this.documentationProvider.getPropertyName(), true);
            this.additionalProperties.put("annotationLibrary", this.annotationLibrary.toCliOptValue());
            this.additionalProperties.put(this.annotationLibrary.getPropertyName(), true);
            this.applyJakartaPackage();
            this.LOGGER.warn("For Spring HTTP Interface following options are disabled: documentProvider, annotationLibrary, useBeanValidation, performBeanValidation. useJakartaEe defaulted to 'true'");
        }
        if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
            this.LOGGER.warn("The springfox documentation provider is deprecated for removal. Use the springdoc provider instead.");
        }
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        if (this.additionalProperties.containsKey(CONFIG_PACKAGE)) {
            this.setConfigPackage((String)this.additionalProperties.get(CONFIG_PACKAGE));
        } else {
            this.additionalProperties.put(CONFIG_PACKAGE, this.configPackage);
        }
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
        }
        if (this.additionalProperties.containsKey(VIRTUAL_SERVICE)) {
            this.setVirtualService(Boolean.parseBoolean(this.additionalProperties.get(VIRTUAL_SERVICE).toString()));
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.parseBoolean(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.additionalProperties.containsKey(USE_FEIGN_CLIENT_URL)) {
            this.setUseFeignClientUrl(Boolean.parseBoolean(this.additionalProperties.get(USE_FEIGN_CLIENT_URL).toString()));
        }
        this.writePropertyBack(USE_FEIGN_CLIENT_URL, this.useFeignClientUrl);
        if (this.additionalProperties.containsKey(DELEGATE_PATTERN)) {
            this.setDelegatePattern(Boolean.parseBoolean(this.additionalProperties.get(DELEGATE_PATTERN).toString()));
        }
        if (this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
            this.setSingleContentTypes(Boolean.parseBoolean(this.additionalProperties.get(SINGLE_CONTENT_TYPES).toString()));
        }
        if (this.additionalProperties.containsKey(SKIP_DEFAULT_INTERFACE)) {
            this.setSkipDefaultInterface(Boolean.parseBoolean(this.additionalProperties.get(SKIP_DEFAULT_INTERFACE).toString()));
        }
        if (this.additionalProperties.containsKey(ASYNC)) {
            this.setAsync(Boolean.parseBoolean(this.additionalProperties.get(ASYNC).toString()));
            this.convertPropertyToBooleanAndWriteBack(ASYNC);
        }
        if (this.additionalProperties.containsKey(REACTIVE)) {
            if (SPRING_CLOUD_LIBRARY.equals(this.library)) {
                throw new IllegalArgumentException("Currently, reactive option doesn't supported by Spring Cloud");
            }
            this.setReactive(Boolean.parseBoolean(this.additionalProperties.get(REACTIVE).toString()));
            if (this.additionalProperties.containsKey(SSE)) {
                this.setSse(Boolean.parseBoolean(this.additionalProperties.get(SSE).toString()));
            }
        }
        if (this.additionalProperties.containsKey(RESPONSE_WRAPPER)) {
            this.setResponseWrapper((String)this.additionalProperties.get(RESPONSE_WRAPPER));
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.parseBoolean(this.additionalProperties.get(USE_TAGS).toString()));
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey("performBeanValidation")) {
            this.setPerformBeanValidation(this.convertPropertyToBoolean("performBeanValidation"));
        }
        this.writePropertyBack("performBeanValidation", this.performBeanValidation);
        if (this.additionalProperties.containsKey("useOptional")) {
            this.setUseOptional(this.convertPropertyToBoolean("useOptional"));
        }
        if (this.additionalProperties.containsKey(API_FIRST)) {
            this.setApiFirst(Boolean.parseBoolean(this.additionalProperties.get(API_FIRST).toString()));
        }
        if (this.additionalProperties.containsKey(HATEOAS)) {
            this.setHateoas(Boolean.parseBoolean(this.additionalProperties.get(HATEOAS).toString()));
        }
        if (this.additionalProperties.containsKey(SPRING_CONTROLLER)) {
            this.setUseSpringController(this.convertPropertyToBoolean(SPRING_CONTROLLER));
        }
        this.writePropertyBack(SPRING_CONTROLLER, this.useSpringController);
        if (this.additionalProperties.containsKey(GENERATE_CONSTRUCTOR_WITH_REQUIRED_ARGS)) {
            this.generatedConstructorWithRequiredArgs = this.convertPropertyToBoolean(GENERATE_CONSTRUCTOR_WITH_REQUIRED_ARGS);
        }
        this.writePropertyBack(GENERATE_CONSTRUCTOR_WITH_REQUIRED_ARGS, this.generatedConstructorWithRequiredArgs);
        if (this.additionalProperties.containsKey(RETURN_SUCCESS_CODE)) {
            this.setReturnSuccessCode(Boolean.parseBoolean(this.additionalProperties.get(RETURN_SUCCESS_CODE).toString()));
        }
        if (this.additionalProperties.containsKey("useSwaggerUI")) {
            this.setUseSwaggerUI(this.convertPropertyToBoolean("useSwaggerUI"));
        }
        if (this.getDocumentationProvider().equals((Object)DocumentationProviderFeatures.DocumentationProvider.NONE)) {
            this.setUseSwaggerUI(false);
        }
        this.writePropertyBack("useSwaggerUI", this.useSwaggerUI);
        if (this.additionalProperties.containsKey(UNHANDLED_EXCEPTION_HANDLING)) {
            this.setUnhandledException(Boolean.parseBoolean(this.additionalProperties.get(UNHANDLED_EXCEPTION_HANDLING).toString()));
        }
        this.additionalProperties.put(UNHANDLED_EXCEPTION_HANDLING, this.isUnhandledException());
        if (this.additionalProperties.containsKey(USE_RESPONSE_ENTITY)) {
            this.setUseResponseEntity(Boolean.parseBoolean(this.additionalProperties.get(USE_RESPONSE_ENTITY).toString()));
        }
        this.writePropertyBack(USE_RESPONSE_ENTITY, this.useResponseEntity);
        this.additionalProperties.put("springHttpStatus", new SpringHttpStatusLambda());
        if (this.additionalProperties.containsKey(USE_ENUM_CASE_INSENSITIVE)) {
            this.setUseEnumCaseInsensitive(Boolean.parseBoolean(this.additionalProperties.get(USE_ENUM_CASE_INSENSITIVE).toString()));
        }
        this.writePropertyBack(USE_ENUM_CASE_INSENSITIVE, this.useEnumCaseInsensitive);
        if (this.additionalProperties.containsKey(USE_SPRING_BOOT3)) {
            this.setUseSpringBoot3(this.convertPropertyToBoolean(USE_SPRING_BOOT3));
        }
        if (this.isUseSpringBoot3()) {
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                throw new IllegalArgumentException(DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.getPropertyName() + " is not supported with Spring Boot > 3.x");
            }
            if (DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1.equals((Object)this.getAnnotationLibrary())) {
                throw new IllegalArgumentException(DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1.getPropertyName() + " is not supported with Spring Boot > 3.x");
            }
            this.useJakartaEe = true;
            this.additionalProperties.put("useJakartaEe", this.useJakartaEe);
            this.applyJakartaPackage();
        }
        this.writePropertyBack(USE_SPRING_BOOT3, this.isUseSpringBoot3());
        if (this.additionalProperties.containsKey(RESOURCE_FOLDER)) {
            this.setResourceFolder((String)this.additionalProperties.get(RESOURCE_FOLDER));
        }
        this.additionalProperties.put(RESOURCE_FOLDER, this.resourceFolder);
        this.typeMapping.put("file", "org.springframework.core.io.Resource");
        this.importMapping.put("org.springframework.core.io.Resource", "org.springframework.core.io.Resource");
        this.importMapping.put("DateTimeFormat", "org.springframework.format.annotation.DateTimeFormat");
        this.importMapping.put("ApiIgnore", "springfox.documentation.annotations.ApiIgnore");
        this.importMapping.put("ParameterObject", "org.springdoc.api.annotations.ParameterObject");
        if (this.isUseSpringBoot3()) {
            this.importMapping.put("ParameterObject", "org.springdoc.core.annotations.ParameterObject");
        }
        if (this.useOptional) {
            this.writePropertyBack("useOptional", this.useOptional);
        }
        if (this.interfaceOnly && this.delegatePattern) {
            this.delegateMethod = true;
            this.additionalProperties.put("delegate-method", true);
        }
        if (this.isUseSpringBoot3()) {
            this.supportingFiles.add(new SupportingFile("pom-sb3.mustache", "", "pom.xml"));
        } else {
            this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        if (!this.interfaceOnly) {
            if (SPRING_BOOT.equals(this.library)) {
                if (this.useSwaggerUI && this.selectedDocumentationProviderRequiresSwaggerUiBootstrap()) {
                    this.supportingFiles.add(new SupportingFile("swagger-ui.mustache", "src/main/resources/static", "swagger-ui.html"));
                }
                this.supportingFiles.add(new SupportingFile("openapi2SpringBoot.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "OpenApiGeneratorApplication.java"));
                this.supportingFiles.add(new SupportingFile("SpringBootTest.mustache", (this.testFolder + File.separator + this.basePackage).replace(".", File.separator), "OpenApiGeneratorApplicationTests.java"));
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator), "RFC3339DateFormat.java"));
            }
            if (SPRING_CLOUD_LIBRARY.equals(this.library)) {
                this.supportingFiles.add(new SupportingFile("apiKeyRequestInterceptor.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ApiKeyRequestInterceptor.java"));
                this.supportingFiles.add(new SupportingFile("oauth2ClientProperties.mustache", this.resourceFolder, "oauth2-client.properties"));
                this.supportingFiles.add(new SupportingFile("clientPropertiesConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ClientPropertiesConfiguration.java"));
                this.supportingFiles.add(new SupportingFile("clientConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "ClientConfiguration.java"));
                this.apiTemplateFiles.put("apiClient.mustache", "Client.java");
                if (!this.additionalProperties.containsKey(SINGLE_CONTENT_TYPES)) {
                    this.additionalProperties.put(SINGLE_CONTENT_TYPES, "true");
                    this.setSingleContentTypes(true);
                }
                this.setRequestMappingMode(RequestMappingMode.none);
                this.additionalProperties.put(USE_FEIGN_CLIENT, "true");
            } else if (SPRING_BOOT.equals(this.library)) {
                this.apiTemplateFiles.put("apiController.mustache", "Controller.java");
                if (this.containsEnums()) {
                    this.supportingFiles.add(new SupportingFile("converter.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "EnumConverterConfiguration.java"));
                }
                this.supportingFiles.add(new SupportingFile("application.mustache", "src.main.resources".replace(".", File.separator), "application.properties"));
                this.supportingFiles.add(new SupportingFile("homeController.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "HomeController.java"));
                this.supportingFiles.add(new SupportingFile("openapi.mustache", "src/main/resources".replace("/", File.separator), "openapi.yaml"));
                if (!this.reactive && !this.apiFirst) {
                    if (DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC.equals((Object)this.getDocumentationProvider())) {
                        this.supportingFiles.add(new SupportingFile("springdocDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SpringDocConfiguration.java"));
                    } else if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                        this.supportingFiles.add(new SupportingFile("openapiDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "SpringFoxConfiguration.java"));
                    }
                }
            } else if (SPRING_HTTP_INTERFACE.equals(this.library)) {
                this.supportingFiles.add(new SupportingFile("httpInterfacesConfiguration.mustache", (this.sourceFolder + File.separator + this.configPackage).replace(".", File.separator), "HttpInterfacesAbstractConfigurator.java"));
                this.writePropertyBack("useBeanValidation", false);
            }
        }
        if (SPRING_BOOT.equals(this.library)) {
            this.supportingFiles.add(new SupportingFile("apiUtil.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ApiUtil.java"));
        }
        if (!this.delegatePattern || this.delegateMethod) {
            this.additionalProperties.put("jdk8-no-delegate", true);
        }
        if (this.delegatePattern && !this.delegateMethod) {
            this.additionalProperties.put("isDelegate", "true");
            this.apiTemplateFiles.put("apiDelegate.mustache", "Delegate.java");
        }
        this.additionalProperties.put("javaVersion", "1.8");
        if (SPRING_CLOUD_LIBRARY.equals(this.library)) {
            this.additionalProperties.put("jdk8-default-interface", false);
        } else {
            this.additionalProperties.put("jdk8-default-interface", !this.skipDefaultInterface);
        }
        if (this.async) {
            this.additionalProperties.put(RESPONSE_WRAPPER, "CompletableFuture");
        }
        if (this.reactive) {
            this.additionalProperties.put(RESPONSE_WRAPPER, "Mono");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.responseWrapper)) {
            this.additionalProperties.put("jdk8-default-interface", false);
            switch (this.responseWrapper) {
                case "Future": 
                case "Callable": 
                case "CompletableFuture": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "java.util.concurrent." + this.responseWrapper);
                    break;
                }
                case "ListenableFuture": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "org.springframework.util.concurrent.ListenableFuture");
                    break;
                }
                case "DeferredResult": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "org.springframework.web.context.request.async.DeferredResult");
                    break;
                }
                case "RxObservable": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "rx.Observable");
                    break;
                }
                case "RxSingle": {
                    this.additionalProperties.put(RESPONSE_WRAPPER, "rx.Single");
                    break;
                }
            }
        }
        switch (this.getRequestMappingMode()) {
            case api_interface: {
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_INTERFACE, true);
                break;
            }
            case controller: {
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_CONTROLLER, true);
                break;
            }
            case none: {
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_INTERFACE, false);
                this.additionalProperties.put(USE_REQUEST_MAPPING_ON_CONTROLLER, false);
            }
        }
        this.additionalProperties.put("lambdaRemoveDoubleQuote", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\"", Matcher.quoteReplacement(""))));
        this.additionalProperties.put("lambdaEscapeDoubleQuote", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\"", Matcher.quoteReplacement("\\\""))));
        this.additionalProperties.put("lambdaRemoveLineBreak", (fragment, writer) -> writer.write(fragment.execute().replaceAll("\\r|\\n", "")));
        this.additionalProperties.put("lambdaTrimWhitespace", new TrimWhitespaceLambda());
        this.additionalProperties.put("lambdaSplitString", new SplitStringLambda());
        this.additionalProperties.put("_api_controller_impl_", false);
        if (this.apiFirst) {
            this.apiTemplateFiles.clear();
            this.modelTemplateFiles.clear();
        }
        this.supportsAdditionalPropertiesWithComposedSchema = true;
    }

    private boolean containsEnums() {
        if (this.openAPI == null) {
            return false;
        }
        Components components = this.openAPI.getComponents();
        if (components == null || components.getSchemas() == null) {
            return false;
        }
        return components.getSchemas().values().stream().anyMatch(it -> it.getEnum() != null && !it.getEnum().isEmpty());
    }

    private boolean supportLibraryUseTags() {
        return SPRING_BOOT.equals(this.library) || SPRING_CLOUD_LIBRARY.equals(this.library);
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.supportLibraryUseTags() && !this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.isEmpty()) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
            return;
        }
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase(Locale.ROOT).endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = StringUtils.camelize(this.sanitizeName(title), CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, 8080));
        }
        if (openAPI.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
                String pathname = (String)openAPIGetPathsEntry.getKey();
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        tags.add(value);
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (final CodegenOperation operation : ops) {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (final CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner(){

                            @Override
                            public void setReturnType(String returnType) {
                                resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                resp.containerType = returnContainer;
                            }

                            @Override
                            public void setIsVoid(boolean isVoid) {
                                resp.isVoid = isVoid;
                            }
                        });
                    }
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner(){

                    @Override
                    public void setReturnType(String returnType) {
                        operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        operation.returnContainer = returnContainer;
                    }

                    @Override
                    public void setIsVoid(boolean isVoid) {
                        operation.isVoid = isVoid;
                    }
                });
                this.prepareVersioningParameters(ops);
                this.handleImplicitHeaders(operation);
            }
            CodegenOperation firstOperation = ops.get(0);
            Tag firstTag = firstOperation.tags.get(0);
            String firstTagName = firstTag.getName();
            objs.put("tagName", "default".equals(firstTagName) ? firstOperation.baseName : firstTagName);
            objs.put("tagDescription", this.escapeText(firstTag.getDescription()));
        }
        this.removeImport(objs, "java.util.List");
        return objs;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        String rt = returnType;
        if (rt == null) {
            dataTypeAssigner.setReturnType("Void");
            dataTypeAssigner.setIsVoid(true);
        } else if (rt.startsWith("List") || rt.startsWith("java.util.List")) {
            int start = rt.indexOf("<");
            int end = rt.lastIndexOf(">");
            if (start > 0 && end > 0) {
                dataTypeAssigner.setReturnType(rt.substring(start + 1, end).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (rt.startsWith("Map") || rt.startsWith("java.util.Map")) {
            int start = rt.indexOf("<");
            int end = rt.lastIndexOf(">");
            if (start > 0 && end > 0) {
                dataTypeAssigner.setReturnType(rt.substring(start + 1, end).split(",", 2)[1].trim());
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (rt.startsWith("Set") || rt.startsWith("java.util.Set")) {
            int start = rt.indexOf("<");
            int end = rt.lastIndexOf(">");
            if (start > 0 && end > 0) {
                dataTypeAssigner.setReturnType(rt.substring(start + 1, end).trim());
                dataTypeAssigner.setReturnContainer("Set");
            }
        }
    }

    private void prepareVersioningParameters(List<CodegenOperation> operations) {
        for (CodegenOperation operation : operations) {
            List versionParams;
            if (operation.getHasHeaderParams()) {
                versionParams = operation.headerParams.stream().filter(param -> {
                    String xVersionParam = Objects.toString(param.vendorExtensions.get(VendorExtension.X_VERSION_PARAM.getName()), "false");
                    return Boolean.parseBoolean(xVersionParam);
                }).collect(Collectors.toList());
                operation.hasVersionHeaders = !versionParams.isEmpty();
                operation.vendorExtensions.put("versionHeaderParamsList", versionParams);
            }
            if (!operation.getHasQueryParams()) continue;
            versionParams = operation.queryParams.stream().filter(param -> {
                String xVersionParam = Objects.toString(param.vendorExtensions.get(VendorExtension.X_VERSION_PARAM.getName()), "false");
                return Boolean.parseBoolean(xVersionParam);
            }).collect(Collectors.toList());
            operation.hasVersionQueryParams = !versionParams.isEmpty();
            operation.vendorExtensions.put("versionQueryParamsList", versionParams);
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List authMethods;
        this.generateYAMLSpecFile(objs);
        if (SPRING_CLOUD_LIBRARY.equals(this.library) && (authMethods = (List)objs.get("authMethods")) != null) {
            for (CodegenSecurity authMethod : authMethods) {
                authMethod.name = StringUtils.camelize(this.sanitizeName(authMethod.name), CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize(name) + this.apiNameSuffix;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("File".equals(type)) {
            Object example = p.defaultValue == null ? p.example : p.defaultValue;
            if (example == null) {
                example = "/path/to/file";
            }
            p.example = example = "new org.springframework.core.io.FileSystemResource(new java.io.File(\"" + this.escapeText((String)example) + "\"))";
        } else {
            super.setParameterExampleValue(p);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public boolean isUnhandledException() {
        return this.unhandledException;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }

    public void setUseFeignClientUrl(boolean useFeignClientUrl) {
        this.useFeignClientUrl = useFeignClientUrl;
    }

    public void setDelegatePattern(boolean delegatePattern) {
        this.delegatePattern = delegatePattern;
    }

    public void setSingleContentTypes(boolean singleContentTypes) {
        this.singleContentTypes = singleContentTypes;
    }

    public void setSkipDefaultInterface(boolean skipDefaultInterface) {
        this.skipDefaultInterface = skipDefaultInterface;
    }

    public void setVirtualService(boolean virtualService) {
        this.virtualService = virtualService;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setSse(boolean sse) {
        this.sse = sse;
    }

    public void setResponseWrapper(String responseWrapper) {
        this.responseWrapper = responseWrapper;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setApiFirst(boolean apiFirst) {
        this.apiFirst = apiFirst;
    }

    public void setHateoas(boolean hateoas) {
        this.hateoas = hateoas;
    }

    public void setUseSpringController(boolean useSpringController) {
        this.useSpringController = useSpringController;
    }

    public void setReturnSuccessCode(boolean returnSuccessCode) {
        this.returnSuccessCode = returnSuccessCode;
    }

    public void setUnhandledException(boolean unhandledException) {
        this.unhandledException = unhandledException;
    }

    public void setUseResponseEntity(boolean useResponseEntity) {
        this.useResponseEntity = useResponseEntity;
    }

    public void setUseEnumCaseInsensitive(boolean useEnumCaseInsensitive) {
        this.useEnumCaseInsensitive = useEnumCaseInsensitive;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (property.isDate || property.isDateTime) {
            model.imports.add("DateTimeFormat");
        }
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
        if (property.isByteArray) {
            model.imports.add("Arrays");
        }
        if (model.getVendorExtensions().containsKey("x-jackson-optional-nullable-helpers")) {
            model.imports.add("Arrays");
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        if (this.getAnnotationLibrary() != DocumentationProviderFeatures.AnnotationLibrary.SWAGGER1) {
            codegenModel.imports.remove("ApiModelProperty");
            codegenModel.imports.remove("ApiModel");
        }
        return codegenModel;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        objs = super.updateAllModels(objs);
        for (ModelsMap modelsAttrs : objs.values()) {
            for (ModelMap mo : modelsAttrs.getModels()) {
                CodegenModel codegenModel = mo.getModel();
                HashSet<String> inheritedImports = new HashSet<String>();
                HashMap<String, CodegenProperty> propertyHash = new HashMap<String, CodegenProperty>(codegenModel.vars.size());
                for (CodegenProperty property : codegenModel.vars) {
                    propertyHash.put(property.name, property);
                }
                for (CodegenModel parentCodegenModel = codegenModel.parentModel; parentCodegenModel != null; parentCodegenModel = parentCodegenModel.getParentModel()) {
                    for (CodegenProperty property : parentCodegenModel.vars) {
                        if (propertyHash.containsKey(property.name)) continue;
                        propertyHash.put(property.name, property);
                        CodegenProperty parentVar = property.clone();
                        parentVar.isInherited = true;
                        this.LOGGER.info("adding parent variable {}", (Object)property.name);
                        codegenModel.parentVars.add(parentVar);
                        Set imports = parentVar.getImports(true, this.importBaseType, this.generatorMetadata.getFeatureSet()).stream().filter(Objects::nonNull).collect(Collectors.toSet());
                        for (String imp : imports) {
                            if (codegenModel.getImports().contains(imp)) continue;
                            inheritedImports.add(imp);
                            codegenModel.getImports().add(imp);
                        }
                    }
                }
                if (codegenModel.getParentModel() != null) {
                    codegenModel.parentRequiredVars = new ArrayList<CodegenProperty>(codegenModel.getParentModel().requiredVars);
                }
                for (String imp : inheritedImports) {
                    String qimp = this.importMapping().get(imp);
                    if (qimp == null) continue;
                    HashMap<String, String> toAdd = new HashMap<String, String>();
                    toAdd.put("import", qimp);
                    modelsAttrs.getImports().add(toAdd);
                }
            }
        }
        return objs;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        if (Boolean.TRUE.equals(operation.getExtensions().get("x-spring-paginated"))) {
            this.importMapping.put("Pageable", "org.springframework.data.domain.Pageable");
        }
        Set<String> provideArgsClassSet = this.reformatProvideArgsParams(operation);
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        codegenOperation.allParams.stream().filter(p -> p.isDate || p.isDateTime).findFirst().ifPresent(p -> codegenOperation.imports.add("DateTimeFormat"));
        if (codegenOperation.vendorExtensions.containsKey("x-spring-paginated")) {
            codegenOperation.imports.add("Pageable");
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                codegenOperation.imports.add("ApiIgnore");
            }
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGDOC.equals((Object)this.getDocumentationProvider())) {
                codegenOperation.imports.add("ParameterObject");
            }
        }
        if (codegenOperation.vendorExtensions.containsKey("x-spring-provide-args") && !provideArgsClassSet.isEmpty()) {
            codegenOperation.imports.addAll(provideArgsClassSet);
        }
        if (this.reactive) {
            if (DocumentationProviderFeatures.DocumentationProvider.SPRINGFOX.equals((Object)this.getDocumentationProvider())) {
                codegenOperation.imports.add("ApiIgnore");
            }
            if (this.sse) {
                String MEDIA_EVENT_STREAM = "text/event-stream";
                Map<String, List<Schema>> schemaTypes = operation.getResponses().entrySet().stream().map(e -> Pair.of((Object)((ApiResponse)e.getValue()), (Object)this.fromResponse((String)e.getKey(), (ApiResponse)e.getValue()))).filter(p -> ((CodegenResponse)p.getRight()).is2xx).map(p -> (MediaType)((ApiResponse)p.getLeft()).getContent().get((Object)MEDIA_EVENT_STREAM)).map(MediaType::getSchema).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(Schema::getType));
                if (schemaTypes.containsKey("array")) {
                    if (schemaTypes.keySet().size() > 1) {
                        throw new RuntimeException("only 1 response media type supported, when SSE is detected");
                    }
                    List<Schema> eventTypes = schemaTypes.get("array");
                    if (eventTypes.stream().anyMatch(schema -> !"event-stream".equalsIgnoreCase(schema.getFormat()))) {
                        throw new RuntimeException("schema format 'event-stream' is required, when SSE is detected");
                    }
                    Set itemTypes = eventTypes.stream().map(schema -> schema.getItems().getType() != null ? schema.getItems().getType() : schema.getItems().get$ref()).collect(Collectors.toSet());
                    if (itemTypes.size() > 1) {
                        throw new RuntimeException("only single item type is supported, when SSE is detected");
                    }
                    codegenOperation.vendorExtensions.put("x-sse", true);
                }
            }
        }
        return codegenOperation;
    }

    private Set<String> reformatProvideArgsParams(Operation operation) {
        List provideArgs;
        HashSet<String> provideArgsClassSet = new HashSet<String>();
        Object argObj = operation.getExtensions().get("x-spring-provide-args");
        if (argObj instanceof List && !(provideArgs = (List)argObj).isEmpty()) {
            ArrayList<String> formatedArgs = new ArrayList<String>();
            for (String oneArg : provideArgs) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)oneArg)) continue;
                String regexp = "(?<AnnotationTag>@)?(?<ClassPath>(?<PackageName>(\\w+\\.)*)(?<ClassName>\\w+))(?<Params>\\(.*?\\))?\\s?";
                Matcher matcher = Pattern.compile(regexp).matcher(oneArg);
                ArrayList<String> newArgs = new ArrayList<String>();
                while (matcher.find()) {
                    String className = matcher.group("ClassName");
                    String classPath = matcher.group("ClassPath");
                    String packageName = matcher.group("PackageName");
                    String params = matcher.group("Params");
                    String annoTag = matcher.group("AnnotationTag");
                    String shortPhrase = org.apache.commons.lang3.StringUtils.join((Object[])new String[]{annoTag, className, params});
                    newArgs.add(shortPhrase);
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)packageName)) continue;
                    this.importMapping.put(className, classPath);
                    provideArgsClassSet.add(className);
                    this.LOGGER.trace("put import mapping {} {}", (Object)className, (Object)classPath);
                }
                String newArg = String.join((CharSequence)" ", newArgs);
                this.LOGGER.trace("new arg {} {}", (Object)newArg);
                formatedArgs.add(newArg);
            }
            operation.getExtensions().put("x-spring-provide-args", formatedArgs);
        }
        return provideArgsClassSet;
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            boolean addNullableImports = false;
            for (CodegenProperty var : cm.vars) {
                addNullableImports = this.isAddNullableImports(cm, addNullableImports, var);
            }
            if (Boolean.TRUE.equals(cm.isEnum) && cm.allowableValues != null) {
                cm.imports.add((String)this.importMapping.get("JsonValue"));
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("import", (String)this.importMapping.get("JsonValue"));
                imports.add(item);
            }
            if (!addNullableImports) continue;
            HashMap<String, String> imports2Classnames = new HashMap<String, String>();
            imports2Classnames.put("NoSuchElementException", "java.util.NoSuchElementException");
            SpringCodegen.addImports(imports, cm, imports2Classnames);
        }
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        this.performBeanValidation = performBeanValidation;
    }

    @Override
    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    @Override
    public void setUseSwaggerUI(boolean useSwaggerUI) {
        this.useSwaggerUI = useSwaggerUI;
    }

    @Override
    public List<VendorExtension> getSupportedVendorExtensions() {
        List<VendorExtension> extensions = super.getSupportedVendorExtensions();
        extensions.add(VendorExtension.X_OPERATION_EXTRA_ANNOTATION);
        extensions.add(VendorExtension.X_SPRING_PAGINATED);
        extensions.add(VendorExtension.X_VERSION_PARAM);
        extensions.add(VendorExtension.X_PATTERN_MESSAGE);
        return extensions;
    }

    public boolean isUseSpringBoot3() {
        return this.useSpringBoot3;
    }

    public void setUseSpringBoot3(boolean useSpringBoot3) {
        this.useSpringBoot3 = useSpringBoot3;
    }

    public RequestMappingMode getRequestMappingMode() {
        return this.requestMappingMode;
    }

    public void setRequestMappingMode(RequestMappingMode requestMappingMode) {
        this.requestMappingMode = requestMappingMode;
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);

        public void setIsVoid(boolean var1);
    }

    public static enum RequestMappingMode {
        api_interface("Generate the @RequestMapping annotation on the generated Api Interface."),
        controller("Generate the @RequestMapping annotation on the generated Api Controller Implementation."),
        none("Do not add a class level @RequestMapping annotation.");

        private String description;

        public String getDescription() {
            return this.description;
        }

        private RequestMappingMode(String description) {
            this.description = description;
        }
    }
}

