/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.site.wagon.repository.Repository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.nuiton.wikitty.plugin.AbstractWPLoadDependencyMojo;
import org.nuiton.wikitty.plugin.WPJarMojo;

public class WPDeployJarMojo
extends AbstractWPLoadDependencyMojo
implements Contextualizable {
    protected String serverId;
    protected String serverUrl;
    protected boolean chmod;
    protected String chmodMode;
    protected String chmodOptions;
    protected WagonManager wagonManager;
    protected Settings settings;
    protected MavenSession mavenSession;
    protected PlexusContainer container;
    protected Repository repository;
    protected Map<String, Wagon> wagons;
    protected SettingsDecrypter settingsDecrypter;
    protected ProxyInfo proxyInfo;
    protected Wagon wagon;
    protected File fileToDeploy;

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.fileToDeploy == null || !this.fileToDeploy.exists()) {
            String file = this.getProject().getBuild().getDirectory();
            file = file + File.separator + WPJarMojo.EXTERNALIZE_PREFIX + this.applicationName + ".jar";
            this.fileToDeploy = new File(file);
        }
        this.repository = new Repository(this.serverId, this.serverUrl);
        if (!this.fileToDeploy.exists()) {
            throw new MojoExecutionException("The file to deploy " + this.fileToDeploy + " does not exist");
        }
        this.proxyInfo = !this.isMaven3OrMore() ? this.getProxyInfo() : this.getProxy();
        this.wagon = this.getWagon((org.apache.maven.wagon.repository.Repository)this.repository, this.wagonManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        block21: {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Deploying to '" + this.repository.getUrl() + "',\n    Using credentials from server id '" + this.repository.getId() + "'"));
            }
            try {
                WPDeployJarMojo.configureWagon(this.wagon, this.repository.getId(), this.settings, this.container, this.getLog());
                AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.repository.getId());
                this.getLog().debug((CharSequence)("authenticationInfo with id '" + this.repository.getId() + "': " + (authenticationInfo == null ? "-" : authenticationInfo.getUserName())));
                try {
                    Debug debug = new Debug();
                    this.wagon.addSessionListener((SessionListener)debug);
                    this.wagon.addTransferListener((TransferListener)debug);
                    if (this.proxyInfo != null) {
                        this.getLog().debug((CharSequence)"connect with proxyInfo");
                        this.wagon.connect((org.apache.maven.wagon.repository.Repository)this.repository, authenticationInfo, this.proxyInfo);
                    } else if (authenticationInfo != null) {
                        this.getLog().debug((CharSequence)"connect with authenticationInfo and without proxyInfo");
                        this.wagon.connect((org.apache.maven.wagon.repository.Repository)this.repository, authenticationInfo);
                    } else {
                        this.getLog().debug((CharSequence)"connect without authenticationInfo and without proxyInfo");
                        this.wagon.connect((org.apache.maven.wagon.repository.Repository)this.repository);
                    }
                    this.getLog().info((CharSequence)("Pushing " + this.fileToDeploy));
                    this.wagon.put(this.fileToDeploy, this.fileToDeploy.getName());
                }
                catch (ResourceDoesNotExistException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (TransferFailedException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (AuthorizationException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (ConnectionException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                catch (AuthenticationException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
                if (!this.chmod) break block21;
                try {
                    if (this.wagon instanceof CommandExecutor) {
                        CommandExecutor exec = (CommandExecutor)this.wagon;
                        exec.executeCommand("chmod " + this.chmodOptions + " " + this.chmodMode + " " + this.repository.getBasedir());
                    }
                }
                catch (CommandExecutionException e) {
                    throw new MojoExecutionException("Error uploading site", (Exception)((Object)e));
                }
            }
            finally {
                try {
                    this.wagon.disconnect();
                }
                catch (ConnectionException e) {
                    this.getLog().error((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
                }
            }
        }
    }

    protected boolean isMaven3OrMore() {
        return new ComparableVersion(this.getMavenVersion()).compareTo(new ComparableVersion("3.0")) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMavenVersion() {
        Properties properties = new Properties();
        InputStream in = MavenProject.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
        try {
            properties.load(in);
        }
        catch (IOException ioe) {
            String string = "";
            return string;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
        return properties.getProperty("version").trim();
    }

    private String getSupportedProtocols() {
        Set<String> protocols = this.wagons.keySet();
        return StringUtils.join(protocols.iterator(), (String)", ");
    }

    public ProxyInfo getProxyInfo() {
        ProxyInfo proxyInfo = this.wagonManager.getProxy(this.repository.getProtocol());
        if (proxyInfo == null) {
            return null;
        }
        String host = this.repository.getHost();
        String nonProxyHostsAsString = proxyInfo.getNonProxyHosts();
        String[] nonProxyHosts = StringUtils.split((String)nonProxyHostsAsString, (String)",;|");
        for (int i = 0; i < nonProxyHosts.length; ++i) {
            String nonProxyHost = nonProxyHosts[i];
            if (StringUtils.contains((String)nonProxyHost, (String)"*")) {
                int pos = nonProxyHost.indexOf(42);
                String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                if (StringUtils.isNotEmpty((String)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isEmpty((String)nonProxyHostSuffix)) {
                    return null;
                }
                if (StringUtils.isEmpty((String)nonProxyHostPrefix) && StringUtils.isNotEmpty((String)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                    return null;
                }
                if (!StringUtils.isNotEmpty((String)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || !StringUtils.isNotEmpty((String)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                return null;
            }
            if (!host.equals(nonProxyHost)) continue;
            return null;
        }
        return proxyInfo;
    }

    private ProxyInfo getProxy() {
        List proxies;
        MavenExecutionRequest request;
        String protocol = this.repository.getProtocol();
        String url = this.repository.getUrl();
        this.getLog().debug((CharSequence)("repository protocol " + protocol));
        String originalProtocol = protocol;
        if (StringUtils.equalsIgnoreCase((String)"dav", (String)protocol) && url.startsWith("dav:")) {
            if ((url = url.substring(4)).startsWith("http")) {
                try {
                    URL urlSite = new URL(url);
                    protocol = urlSite.getProtocol();
                    this.getLog().debug((CharSequence)("found dav protocol so transform to real transport protocol " + protocol));
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("fail to build URL with " + url));
                }
            }
        } else {
            this.getLog().debug((CharSequence)("getProxy 'protocol': " + protocol));
        }
        if (this.mavenSession != null && protocol != null && (request = this.mavenSession.getRequest()) != null && (proxies = request.getProxies()) != null) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive() || !protocol.equalsIgnoreCase(proxy.getProtocol()) && !originalProtocol.equalsIgnoreCase(proxy.getProtocol())) continue;
                SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(proxy));
                proxy = result.getProxy();
                ProxyInfo proxyInfo = new ProxyInfo();
                proxyInfo.setHost(proxy.getHost());
                proxyInfo.setType(protocol);
                proxyInfo.setPort(proxy.getPort());
                proxyInfo.setNonProxyHosts(proxy.getNonProxyHosts());
                proxyInfo.setUserName(proxy.getUsername());
                proxyInfo.setPassword(proxy.getPassword());
                this.getLog().debug((CharSequence)("found proxyInfo host:port " + proxyInfo.getHost() + ":" + proxyInfo.getPort() + ", " + proxyInfo.getUserName()));
                return proxyInfo;
            }
        }
        this.getLog().debug((CharSequence)("getProxy 'protocol': " + protocol + " no ProxyInfo found"));
        return null;
    }

    private Wagon getWagon(org.apache.maven.wagon.repository.Repository repository, WagonManager manager) throws MojoExecutionException {
        Wagon wagon;
        try {
            wagon = manager.getWagon(repository);
        }
        catch (UnsupportedProtocolException e) {
            String shortMessage = "Unsupported protocol: '" + repository.getProtocol() + "' for site deployment to " + "distributionManagement.site.url=" + repository.getUrl() + ".";
            String longMessage = "\n" + shortMessage + "\n" + "Currently supported protocols are: " + this.getSupportedProtocols() + ".\n" + "    Protocols may be added through wagon providers.\n" + "    For more information, see " + "http://maven.apache.org/plugins/maven-site-plugin/examples/adding-deploy-protocol.html";
            this.getLog().error((CharSequence)longMessage);
            throw new MojoExecutionException(shortMessage);
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        return wagon;
    }

    private static void configureWagon(Wagon wagon, String repositoryId, Settings settings, PlexusContainer container, Log log) throws TransferFailedException {
        log.debug((CharSequence)" configureWagon ");
        for (int i = 0; i < settings.getServers().size(); ++i) {
            Server server = (Server)settings.getServers().get(i);
            String id = server.getId();
            log.debug((CharSequence)("configureWagon server " + id));
            if (id == null || !id.equals(repositoryId) || server.getConfiguration() == null) continue;
            XmlPlexusConfiguration plexusConf = new XmlPlexusConfiguration((Xpp3Dom)server.getConfiguration());
            ComponentConfigurator componentConfigurator = null;
            try {
                componentConfigurator = (ComponentConfigurator)container.lookup(ComponentConfigurator.ROLE, "basic");
                componentConfigurator.configureComponent((Object)wagon, (PlexusConfiguration)plexusConf, container.getContainerRealm());
                continue;
            }
            catch (ComponentLookupException e) {
                throw new TransferFailedException("While configuring wagon for '" + repositoryId + "': Unable to lookup wagon configurator." + " Wagon configuration cannot be applied.", (Throwable)e);
            }
            catch (ComponentConfigurationException e) {
                throw new TransferFailedException("While configuring wagon for '" + repositoryId + "': Unable to apply wagon configuration.", (Throwable)e);
            }
            finally {
                if (componentConfigurator != null) {
                    try {
                        container.release((Object)componentConfigurator);
                    }
                    catch (ComponentLifecycleException e) {
                        log.error((CharSequence)("Problem releasing configurator - ignoring: " + e.getMessage()));
                    }
                }
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

