/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.solr;

import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.LastResourceRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FacetTopic;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.solr.Restriction2Solr;

public class WikittySearchEnginSolr
implements WikittySearchEngin {
    private static Log log = LogFactory.getLog(WikittySearchEnginSolr.class);
    protected static final String SOLR_ID = "id";
    public static final String SOLR_EXTENSIONS = "extensions";
    public static final String SOLR_ALL_EXTENSIONS = "all";
    public static final String SOLR_QUERY_PARSER = "{!wikitty}";
    public static final String TREENODE_PREFIX = "TreeNode.";
    public static final String TREENODE_EMPTY = "TreeNode.empty";
    public static final String TREENODE_ROOT = "TreeNode.root";
    public static final String TREENODE_PATH = "TreeNode.path";
    protected SolrServer solrServer;
    protected TypeFieldModifer fieldModifier;
    protected SolrResource solrResource;

    public WikittySearchEnginSolr(WikittyExtensionStorage extensionStorage) {
        this(extensionStorage, null);
    }

    public WikittySearchEnginSolr(WikittyExtensionStorage extensionStorage, Properties properties) {
        try {
            CoreContainer.Initializer initializer = new CoreContainer.Initializer();
            CoreContainer coreContainer = initializer.initialize();
            this.solrServer = new EmbeddedSolrServer(coreContainer, "");
            this.fieldModifier = new TypeFieldModifer(extensionStorage);
            this.solrResource = new SolrResource();
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public void clear(WikittyTransaction transaction) {
        try {
            this.solrResource.init();
            this.solrServer.deleteByQuery("*:*");
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties) {
        try {
            this.solrResource.init();
            ReindexChildTreeNode reindexChildTreeNode = new ReindexChildTreeNode();
            for (Wikitty w : wikitties) {
                String id = w.getId();
                if (w.hasExtension("TreeNode")) {
                    Collection oldChildren;
                    Set children = w.getFieldAsSet("TreeNode", "children", String.class);
                    reindexChildTreeNode.putIncludedChildren(id, children);
                    SolrDocument treeNodeDoc = this.findById(id);
                    if (treeNodeDoc != null && (oldChildren = treeNodeDoc.getFieldValues("TreeNode.children_s")) != null) {
                        if (children == null) {
                            reindexChildTreeNode.putExcludedChildren(id, oldChildren);
                        } else {
                            for (Object oldChild : oldChildren) {
                                if (children.contains(oldChild)) continue;
                                reindexChildTreeNode.putExcludedChild(id, (String)oldChild);
                            }
                        }
                    }
                    String parentId = w.getFieldAsString("TreeNode", "parent");
                    reindexChildTreeNode.putParent(id, parentId);
                }
                SolrInputDocument doc = this.createIndexDocument(w);
                this.solrResource.addDoc(id, doc);
            }
            reindexChildTreeNode.reindex();
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        try {
            this.solrResource.init();
            ReindexChildTreeNode reindexChildTreeNode = new ReindexChildTreeNode();
            for (String id : ids) {
                SolrQuery query = new SolrQuery("{!wikitty}TreeNode." + id + ":*");
                QueryResponse response = this.solrServer.query((SolrParams)query);
                SolrDocumentList updateDocs = response.getResults();
                for (SolrDocument solrDocument : updateDocs) {
                    String childId = (String)solrDocument.getFieldValue(SOLR_ID);
                    reindexChildTreeNode.putExcludedChild(id, childId);
                }
                this.solrResource.deleteDoc(id);
            }
            reindexChildTreeNode.reindex();
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    public void delete(Collection<String> idList) throws WikittyException {
        try {
            for (String id : idList) {
                this.solrServer.deleteById(id);
            }
            this.solrServer.commit();
        }
        catch (Exception e) {
            throw new WikittyException(e);
        }
    }

    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        try {
            String facetName;
            List sortDescending;
            Restriction2Solr restriction2Solr = new Restriction2Solr(transaction, this.fieldModifier);
            String queryString = restriction2Solr.toSolr(criteria.getRestriction(), this.solrServer);
            SolrQuery query = new SolrQuery(SOLR_QUERY_PARSER + queryString);
            int firstIndex = criteria.getFirstIndex();
            int endIndex = criteria.getEndIndex();
            query.setStart(Integer.valueOf(firstIndex));
            int nbRows = endIndex == -1 ? Integer.MAX_VALUE - firstIndex : endIndex - firstIndex + 1;
            query.setRows(Integer.valueOf(nbRows));
            List sortAscending = criteria.getSortAscending();
            if (sortAscending != null) {
                for (String sort : sortAscending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    query.setSortField(tranform, SolrQuery.ORDER.asc);
                }
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                for (String sort : sortDescending) {
                    String tranform = this.fieldModifier.convertToSolr(transaction, sort);
                    query.setSortField(tranform, SolrQuery.ORDER.desc);
                }
            }
            List facetField = criteria.getFacetField();
            log.debug((Object)("facetField : " + facetField));
            List facetCriteria = criteria.getFacetCriteria();
            HashMap<String, String> facetQueryToName = new HashMap<String, String>();
            if (facetField != null && !facetField.isEmpty() || facetCriteria != null && !facetCriteria.isEmpty()) {
                query.setFacet(true);
                query.setFacetMinCount(1);
                if (facetField != null) {
                    for (String fqfieldName : facetField) {
                        String tranform = this.fieldModifier.convertToSolr(transaction, fqfieldName);
                        query.addFacetField(new String[]{tranform});
                    }
                }
                if (facetCriteria != null) {
                    for (Criteria facet : facetCriteria) {
                        String queryFacet = restriction2Solr.toSolr(facet.getRestriction());
                        facetQueryToName.put(queryFacet, facet.getName());
                        query.addFacetQuery(queryFacet);
                    }
                }
            }
            QueryResponse resp = this.solrServer.query((SolrParams)query);
            SolrDocumentList solrResults = resp.getResults();
            HashMap facets = new HashMap();
            if (facetField != null && !facetField.isEmpty()) {
                for (FacetField facetField2 : resp.getFacetFields()) {
                    facetName = this.fieldModifier.convertToField(transaction, facetField2.getName());
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    if (facetField2.getValues() != null) {
                        for (FacetField.Count value : facetField2.getValues()) {
                            String topicName = value.getName();
                            if (topicName.endsWith(TREENODE_EMPTY)) continue;
                            int topicCount = (int)value.getCount();
                            FacetTopic topic = new FacetTopic(facetName, topicName, topicCount);
                            topics.add(topic);
                        }
                    }
                    facets.put(facetName, topics);
                }
            }
            if (facetCriteria != null && !facetCriteria.isEmpty()) {
                for (Map.Entry entry : resp.getFacetQuery().entrySet()) {
                    facetName = (String)entry.getKey();
                    if (null != facetQueryToName.get(facetName)) {
                        facetName = (String)facetQueryToName.get(facetName);
                    }
                    Integer count = (Integer)entry.getValue();
                    ArrayList<FacetTopic> topics = new ArrayList<FacetTopic>();
                    FacetTopic topic = new FacetTopic(facetName, facetName, count.intValue());
                    topics.add(topic);
                    facets.put(facetName, topics);
                }
            }
            ArrayList<String> ids = new ArrayList<String>(solrResults.size());
            for (SolrDocument doc : solrResults) {
                String id = (String)doc.getFieldValue(SOLR_ID);
                ids.add(id);
            }
            int n = (int)resp.getResults().getNumFound();
            PagedResult result = new PagedResult(firstIndex, n, queryString, facets, ids);
            return result;
        }
        catch (SolrServerException e) {
            throw new WikittyException((Exception)((Object)e));
        }
    }

    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        String wikittyId = w.getId();
        String parent = w.getFieldAsWikitty("TreeNode", "parent");
        parent = parent == null ? TREENODE_ROOT : TREENODE_PREFIX + parent;
        Criteria criteria = Search.query((Criteria)filter).eq(parent, wikittyId).criteria().setFirstIndex(0).setEndIndex(0);
        PagedResult<String> search = this.findAllByCriteria(transaction, criteria);
        int numFound = search.getNumFound();
        return numFound;
    }

    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        String wikittyId = w.getId();
        String parent = w.getFieldAsWikitty("TreeNode", "parent");
        parent = parent == null ? TREENODE_ROOT : TREENODE_PREFIX + parent;
        Criteria criteria = Search.query((Criteria)filter).eq(parent, wikittyId).criteria().setFirstIndex(0).setEndIndex(0).addFacetField(TREENODE_PREFIX + wikittyId);
        PagedResult<String> search = this.findAllByCriteria(transaction, criteria);
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        List topics = search.getTopic(TREENODE_PREFIX + wikittyId);
        if (topics != null) {
            for (FacetTopic topic : topics) {
                String topicName = topic.getTopicName();
                int topicCount = topic.getCount();
                counts.put(topicName, topicCount);
            }
        }
        log.debug((Object)("Facet result " + counts));
        criteria = Search.query().eq("TreeNode.parent", wikittyId).criteria().setFirstIndex(0).setEndIndex(-1);
        search = this.findAllByCriteria(transaction, criteria);
        List children = search.getAll();
        for (String child : children) {
            if (counts.containsKey(child)) continue;
            counts.put(child, 0);
        }
        return counts;
    }

    protected SolrInputDocument createIndexDocument(Wikitty w) {
        log.debug((Object)("index wikitty " + w.getId()));
        SolrInputDocument doc = new SolrInputDocument();
        String id = w.getId();
        doc.addField(SOLR_ID, (Object)id);
        for (String name : w.getExtensionNames()) {
            doc.addField(SOLR_EXTENSIONS, (Object)name);
        }
        for (String fqfieldName : w.fieldNames()) {
            FieldType fieldType = w.getFieldType(fqfieldName);
            FieldType.TYPE type = fieldType.getType();
            String solrFqFieldName = WikittySearchEnginSolr.getSolrFieldName(fqfieldName, type);
            String[] solrFieldName = solrFqFieldName.split("\\.");
            String solrAllFieldName = "all." + solrFieldName[1];
            Object objectValue = w.getFqField(fqfieldName);
            if (objectValue == null) continue;
            if (fieldType.isCollection()) {
                Collection collectionValue = (Collection)objectValue;
                for (Object itemValue : collectionValue) {
                    if (itemValue == null) continue;
                    doc.addField(solrFqFieldName, itemValue);
                    doc.addField(solrAllFieldName, itemValue);
                    if (type == FieldType.TYPE.STRING) {
                        doc.addField(solrFqFieldName + "_t", itemValue);
                        doc.addField(solrAllFieldName + "_t", itemValue);
                        String itemValueLowerCase = itemValue.toString().toLowerCase();
                        doc.addField(solrFqFieldName + "_c", (Object)itemValueLowerCase);
                        doc.addField(solrAllFieldName + "_c", (Object)itemValueLowerCase);
                    }
                    log.debug((Object)("index field " + solrFqFieldName + " with value '" + itemValue + "'"));
                }
                continue;
            }
            doc.addField(solrFqFieldName, objectValue);
            doc.addField(solrAllFieldName, objectValue);
            if (type == FieldType.TYPE.STRING) {
                doc.addField(solrFqFieldName + "_t", objectValue);
                doc.addField(solrAllFieldName + "_t", objectValue);
                String objectValueLowerCase = objectValue.toString().toLowerCase();
                doc.addField(solrFqFieldName + "_c", (Object)objectValueLowerCase);
                doc.addField(solrAllFieldName + "_c", (Object)objectValueLowerCase);
            }
            log.debug((Object)("index field " + solrFqFieldName + " with value '" + objectValue + "'"));
        }
        return doc;
    }

    protected SolrDocument findById(String id) {
        QueryResponse response;
        SolrQuery query = new SolrQuery("id:" + id);
        try {
            response = this.solrServer.query((SolrParams)query);
        }
        catch (SolrServerException eee) {
            throw new WikittyException((Exception)((Object)eee));
        }
        SolrDocumentList results = response.getResults();
        long numFound = results.getNumFound();
        if (numFound == 1L) {
            return (SolrDocument)results.get(0);
        }
        return null;
    }

    public static String getSolrFieldName(String fqfieldName, FieldType.TYPE type) {
        switch (type) {
            case BOOLEAN: {
                return fqfieldName + "_b";
            }
            case DATE: {
                return fqfieldName + "_dt";
            }
            case STRING: {
                return fqfieldName + "_s";
            }
            case NUMERIC: {
                return fqfieldName + "_d";
            }
        }
        return fqfieldName;
    }

    protected class SolrResource
    implements OnePhaseResource {
        protected ThreadLocal<Map<String, SolrInputDocument>> addedDocs = new ThreadLocal();
        protected ThreadLocal<List<String>> deletedDocs = new ThreadLocal();

        public SolrResource() {
            this.clear();
        }

        protected void init() {
            LastResourceRecord lastResourceRecord = new LastResourceRecord((OnePhaseResource)this);
            BasicAction.Current().add((AbstractRecord)lastResourceRecord);
        }

        public Map<String, SolrInputDocument> getAddedDocs() {
            Map<String, SolrInputDocument> result = this.addedDocs.get();
            if (result == null) {
                result = new HashMap<String, SolrInputDocument>();
                this.addedDocs.set(result);
            }
            return result;
        }

        public List<String> getDeletedDocs() {
            List<String> result = this.deletedDocs.get();
            if (result == null) {
                result = new ArrayList<String>();
                this.deletedDocs.set(result);
            }
            return result;
        }

        public void clear() {
            this.addedDocs.set(new HashMap());
            this.deletedDocs.set(new ArrayList());
        }

        public void addDoc(String id, SolrInputDocument doc) {
            this.getAddedDocs().put(id, doc);
        }

        public SolrInputDocument getAddedDoc(String id) {
            SolrInputDocument result = this.getAddedDocs().get(id);
            return result;
        }

        public Collection<String> getAddedDocIds() {
            Set<String> result = this.getAddedDocs().keySet();
            return result;
        }

        public void deleteDoc(String docId) {
            this.getDeletedDocs().add(docId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int commit() {
            try {
                SolrResource solrResource = this;
                synchronized (solrResource) {
                    List<String> ids;
                    Collection<SolrInputDocument> docs = this.getAddedDocs().values();
                    if (!docs.isEmpty()) {
                        WikittySearchEnginSolr.this.solrServer.add(docs);
                    }
                    if (!(ids = this.getDeletedDocs()).isEmpty()) {
                        WikittySearchEnginSolr.this.solrServer.deleteById(ids);
                    }
                    WikittySearchEnginSolr.this.solrServer.commit();
                }
                this.clear();
                return 7;
            }
            catch (Exception eee) {
                log.error((Object)"Error commit solr", (Throwable)eee);
                return 8;
            }
        }

        public int rollback() {
            this.clear();
            return 7;
        }

        public void pack(OutputObjectState arg0) throws IOException {
        }

        public void unpack(InputObjectState arg0) throws IOException {
        }
    }

    protected class ReindexChildTreeNode {
        protected Map<String, Collection<String>> includedNodeIds = new HashMap<String, Collection<String>>();
        protected Map<String, Collection<String>> excludedNodeIds = new HashMap<String, Collection<String>>();
        protected Map<String, String> parents = new HashMap<String, String>();

        public void putIncludedChildren(String nodeId, Collection<String> childIds) {
            this.putChildren(this.includedNodeIds, nodeId, childIds);
        }

        public void putExcludedChildren(String nodeId, Collection<String> childIds) {
            this.putChildren(this.excludedNodeIds, nodeId, childIds);
        }

        public void putIncludedChild(String nodeId, String childId) {
            this.putChild(this.includedNodeIds, nodeId, childId);
        }

        public void putExcludedChild(String nodeId, String childId) {
            this.putChild(this.excludedNodeIds, nodeId, childId);
        }

        public Collection<String> getExcludedNodeIds(String childId) {
            Collection<String> result = this.excludedNodeIds.get(childId);
            if (result == null) {
                result = new HashSet<String>();
            }
            return result;
        }

        public Collection<String> getIncludedNodeIds(String childId) {
            Collection<String> result = this.includedNodeIds.get(childId);
            if (result == null) {
                result = new HashSet<String>();
            }
            return result;
        }

        protected void putChildren(Map<String, Collection<String>> map, String nodeId, Collection<String> childIds) {
            if (childIds != null) {
                for (String childId : childIds) {
                    this.putChild(map, nodeId, childId);
                }
            }
        }

        protected void putChild(Map<String, Collection<String>> map, String nodeId, String childId) {
            Collection<String> values = map.get(childId);
            if (values == null) {
                values = new HashSet<String>();
                map.put(childId, values);
            }
            values.add(nodeId);
        }

        public void putParent(String nodeId, String parentId) {
            this.parents.put(nodeId, parentId);
        }

        public String getParent(String nodeId) {
            List<String> deletedDocIds;
            String parentId = this.parents.get(nodeId);
            if (parentId == null) {
                SolrDocument doc = WikittySearchEnginSolr.this.findById(nodeId);
                if (doc == null) {
                    return null;
                }
                parentId = (String)doc.getFieldValue("TreeNode.parent");
                this.parents.put(nodeId, parentId);
            }
            if ((deletedDocIds = WikittySearchEnginSolr.this.solrResource.getDeletedDocs()).contains(parentId)) {
                return null;
            }
            return parentId;
        }

        public Collection<String> getReindexIds() {
            HashSet<String> result = new HashSet<String>();
            result.addAll(this.includedNodeIds.keySet());
            result.addAll(this.excludedNodeIds.keySet());
            result.addAll(WikittySearchEnginSolr.this.solrResource.getAddedDocIds());
            return result;
        }

        public void reindex() throws SolrServerException {
            for (String id : this.getReindexIds()) {
                SolrInputDocument doc = WikittySearchEnginSolr.this.solrResource.getAddedDoc(id);
                if (doc == null) {
                    doc = new SolrInputDocument();
                    SolrDocument found = WikittySearchEnginSolr.this.findById(id);
                    Collection fieldNames = found.getFieldNames();
                    for (String fieldName : fieldNames) {
                        Collection fieldValues = found.getFieldValues(fieldName);
                        if (fieldName.startsWith(WikittySearchEnginSolr.TREENODE_PREFIX)) continue;
                        for (Object fieldValue : fieldValues) {
                            doc.addField(fieldName, fieldValue);
                        }
                    }
                    WikittySearchEnginSolr.this.solrResource.addDoc(id, doc);
                }
                Collection<String> includedChildNodeIds = this.getIncludedNodeIds(id);
                Collection<String> excludedChildNodeIds = this.getExcludedNodeIds(id);
                SolrQuery query = new SolrQuery("{!wikitty}TreeNode.children_s:" + id);
                QueryResponse response = WikittySearchEnginSolr.this.solrServer.query((SolrParams)query);
                SolrDocumentList updateDocs = response.getResults();
                for (SolrDocument solrDocument : updateDocs) {
                    String nodeId = (String)solrDocument.getFieldValue(WikittySearchEnginSolr.SOLR_ID);
                    includedChildNodeIds.add(nodeId);
                }
                includedChildNodeIds.removeAll(excludedChildNodeIds);
                includedChildNodeIds.removeAll(WikittySearchEnginSolr.this.solrResource.getDeletedDocs());
                HashMap<String, String> paths = new HashMap<String, String>();
                for (String nodeId : includedChildNodeIds) {
                    String parentPath;
                    doc.addField(WikittySearchEnginSolr.TREENODE_PREFIX + nodeId, (Object)WikittySearchEnginSolr.TREENODE_EMPTY);
                    String childParent = nodeId;
                    String parent = this.getParent(childParent);
                    while (parent != null) {
                        parentPath = (String)paths.get(childParent);
                        if (parentPath == null) {
                            doc.addField(WikittySearchEnginSolr.TREENODE_PREFIX + parent, (Object)childParent);
                            paths.put(childParent, parent);
                        }
                        childParent = parent;
                        parent = this.getParent(childParent);
                    }
                    parentPath = (String)paths.get(childParent);
                    if (parentPath != null) continue;
                    doc.addField(WikittySearchEnginSolr.TREENODE_ROOT, (Object)childParent);
                    paths.put(childParent, WikittySearchEnginSolr.TREENODE_ROOT);
                }
            }
        }
    }

    protected static class TypeFieldModifer
    implements FieldModifier {
        protected WikittyExtensionStorage extensionStorage;

        public TypeFieldModifer(WikittyExtensionStorage extensionStorage) {
            this.extensionStorage = extensionStorage;
        }

        @Override
        public String convertToSolr(WikittyTransaction transaction, String fqfieldname) {
            String result = fqfieldname;
            String[] searchField = fqfieldname.split("\\.");
            if (Element.ELT_EXTENSION.equals(fqfieldname)) {
                result = WikittySearchEnginSolr.SOLR_EXTENSIONS;
            } else if (Element.ELT_ID.equals(fqfieldname)) {
                result = WikittySearchEnginSolr.SOLR_ID;
            } else if (searchField.length >= 2) {
                String extName = searchField[0];
                String fieldName = searchField[1];
                if ("*".equals(extName)) {
                    fqfieldname = "all." + fieldName;
                }
                if (searchField.length >= 3) {
                    String fieldNameType = searchField[2];
                    FieldType.TYPE type = FieldType.TYPE.valueOf((String)fieldNameType);
                    result = WikittySearchEnginSolr.getSolrFieldName(fqfieldname, type);
                    return result;
                }
                String version = this.extensionStorage.getLastVersion(transaction, extName);
                if (version != null) {
                    WikittyExtension ext = this.extensionStorage.restore(transaction, extName, version);
                    FieldType fieldType = ext.getFieldType(fieldName);
                    log.debug((Object)(ext.toDefinition() + " for " + fieldName));
                    if (fieldType != null) {
                        FieldType.TYPE type = fieldType.getType();
                        result = WikittySearchEnginSolr.getSolrFieldName(fqfieldname, type);
                        return result;
                    }
                }
            }
            return result;
        }

        @Override
        public String convertToField(WikittyTransaction transaction, String solrName) {
            String fieldName = solrName.replaceAll("(_b$)|(_dt$)|(_s$)|(_d$)", "");
            if (WikittySearchEnginSolr.SOLR_EXTENSIONS.equals(fieldName)) {
                fieldName = Element.ELT_EXTENSION;
            }
            return fieldName;
        }
    }

    public static interface FieldModifier {
        public String convertToSolr(WikittyTransaction var1, String var2);

        public String convertToField(WikittyTransaction var1, String var2);
    }
}

