/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.filter;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaTransaction;

public abstract class TypedTopiaTransactionFilter<PersistenceContext extends TopiaPersistenceContext>
implements Filter {
    public static final String TOPIA_TRANSACTION_REQUEST_ATTRIBUTE = "topiaTransaction";
    public static final String[] DEFAULT_EXCLUDE_METHODS = new String[]{"beginTransaction", "close", "clear"};
    public static final String[] DEFAULT_UNUSED_METHODS = new String[]{"toString", "isClosed", "close", "clear", "equals", "hashCode", "finalize", "getClass"};
    private static final Log log = LogFactory.getLog(TypedTopiaTransactionFilter.class);
    protected Set<String> excludeMethods;
    protected Set<String> unusedMethods;
    protected final Class<PersistenceContext> persistenceContextType;
    protected String requestAttributeName = "topiaTransaction";

    public static <PersistenceContext extends TopiaPersistenceContext> PersistenceContext getPersistenceContext(ServletRequest request) {
        TopiaPersistenceContext topiaContext = (TopiaPersistenceContext)request.getAttribute(TOPIA_TRANSACTION_REQUEST_ATTRIBUTE);
        return (PersistenceContext)topiaContext;
    }

    @Deprecated
    public static <PersistenceContext extends TopiaPersistenceContext> PersistenceContext getTransaction(ServletRequest request) {
        PersistenceContext topiaContext = TypedTopiaTransactionFilter.getPersistenceContext(request);
        return topiaContext;
    }

    protected TypedTopiaTransactionFilter(Class<PersistenceContext> persistenceContextType) {
        if (persistenceContextType == null) {
            throw new NullPointerException("persistenceContextType can't be null");
        }
        if (!persistenceContextType.isInterface()) {
            throw new IllegalArgumentException("persistenceContextType must be an interface");
        }
        this.persistenceContextType = persistenceContextType;
    }

    public Set<String> getExcludeMethods() {
        return this.excludeMethods;
    }

    public Set<String> getUnusedMethods() {
        return this.unusedMethods;
    }

    public void setRequestAttributeName(String requestAttributeName) {
        this.requestAttributeName = requestAttributeName;
    }

    protected abstract PersistenceContext beginTransaction(ServletRequest var1) throws TopiaException;

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String methodsFromConfig = filterConfig.getInitParameter("excludeMethods");
        String[] methods = StringUtils.isNotEmpty((CharSequence)methodsFromConfig) ? methodsFromConfig.split(",") : DEFAULT_EXCLUDE_METHODS;
        this.excludeMethods = new HashSet<String>(Arrays.asList(methods));
        methodsFromConfig = filterConfig.getInitParameter("unusedMethods");
        methods = StringUtils.isNotEmpty((CharSequence)methodsFromConfig) ? methodsFromConfig.split(",") : DEFAULT_UNUSED_METHODS;
        this.unusedMethods = new HashSet<String>(Arrays.asList(methods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TopiaTransactionProxyInvocationHandler proxyInvocationHandler = new TopiaTransactionProxyInvocationHandler(request);
        TopiaPersistenceContext proxy = (TopiaPersistenceContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.persistenceContextType, TopiaTransaction.class}, (InvocationHandler)proxyInvocationHandler);
        request.setAttribute(this.requestAttributeName, (Object)proxy);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.onCloseTransaction(proxyInvocationHandler.transaction);
        }
    }

    protected Object onExcludeMethod(Object proxy, Method method, Object[] args) throws Throwable {
        throw new IllegalAccessException("Not allowed to access method " + method.getName() + " on " + proxy);
    }

    protected void onCloseTransaction(PersistenceContext transaction) {
        if (transaction == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"no transaction to close");
            }
        } else if (transaction.isClosed()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("transaction " + transaction + " is already closed"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("closing transaction " + transaction));
            }
            transaction.close();
        }
    }

    protected Object onUnusedMethod(Object proxy, Method method, Object[] args) throws Throwable {
        Set<String> methods;
        String methodName = method.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skip execution of method " + methodName + " since no transaction is instanciated."));
        }
        if ((methods = this.getUnusedMethods()).contains("toString")) {
            return "No transaction opened yet for this proxy";
        }
        if (methods.contains("isClosed")) {
            return false;
        }
        if (methods.contains("equals")) {
            return false;
        }
        if (methods.contains("hashCode")) {
            return 0;
        }
        if (methods.contains("getClass")) {
            return this.persistenceContextType;
        }
        return null;
    }

    public class TopiaTransactionProxyInvocationHandler
    implements InvocationHandler {
        protected final ServletRequest request;
        protected PersistenceContext transaction;

        protected TopiaTransactionProxyInvocationHandler(ServletRequest request) {
            this.request = request;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (TypedTopiaTransactionFilter.this.getExcludeMethods().contains(methodName)) {
                Object result = TypedTopiaTransactionFilter.this.onExcludeMethod(proxy, method, args);
                return result;
            }
            if (this.transaction == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("transaction started due to a call to " + methodName));
                }
                if (TypedTopiaTransactionFilter.this.getUnusedMethods().contains(methodName)) {
                    Object result = TypedTopiaTransactionFilter.this.onUnusedMethod(proxy, method, args);
                    return result;
                }
                this.transaction = TypedTopiaTransactionFilter.this.beginTransaction(this.request);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Open transaction " + this.transaction));
                }
            }
            try {
                Object result = method.invoke(this.transaction, args);
                return result;
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not execute method " + method.getName()), (Throwable)eee);
                }
                throw eee;
            }
        }
    }
}

