/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.rss.FeedRendererConfig;
import org.nuiton.rss.RSSConfig;
import org.nuiton.rss.RSSIOUtil;

public class FeedData {
    private static final Log log = LogFactory.getLog(FeedData.class);
    protected URL url;
    protected FeedRendererConfig rendererConfig;
    protected int nbItem = -1;
    protected SyndFeed feed;
    protected long lastRetrived;

    public FeedData(URL url, int nbItem, String representation) {
        this(url);
        this.nbItem = nbItem;
        this.rendererConfig = new FeedRendererConfig(representation);
    }

    public FeedData(URL url) {
        this.url = url;
    }

    public long getLastRetrived() {
        return this.lastRetrived;
    }

    public URL getUrl() {
        return this.url;
    }

    public FeedRendererConfig getRendererConfig() {
        return this.rendererConfig;
    }

    public void setRendererConfig(FeedRendererConfig rendererConfig) {
        this.rendererConfig = rendererConfig;
    }

    public int getNbItem() {
        return this.nbItem;
    }

    public void setNbItem(int nbItem) {
        this.nbItem = nbItem;
    }

    public SyndFeed getFeed() {
        if (this.feed == null || this.lastRetrived + RSSConfig.TIME_FORCE_RETRIEVED < System.currentTimeMillis()) {
            this.forceRetrived();
        }
        return this.feed;
    }

    protected synchronized void forceRetrived() {
        if (this.lastRetrived + RSSConfig.TIME_FORCE_RETRIEVED < System.currentTimeMillis()) {
            try {
                this.feed = RSSIOUtil.readFeed((URL)this.url);
                this.lastRetrived = System.currentTimeMillis();
            }
            catch (Exception eee) {
                log.warn((Object)("Can't get feed: " + this.url), (Throwable)eee);
            }
        }
    }
}

