/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.MonitorWriter;
import org.nuiton.eugene.StateModelGenerator;
import org.nuiton.eugene.models.state.StateModel;
import org.nuiton.eugene.models.state.StateModelComplexState;
import org.nuiton.eugene.models.state.StateModelSimpleState;
import org.nuiton.eugene.models.state.StateModelState;
import org.nuiton.eugene.models.state.StateModelStateChart;
import org.nuiton.eugene.models.state.StateModelTransition;

public class TapestryWebGenerator
extends StateModelGenerator {
    private static final Log log = LogFactory.getLog(TapestryWebGenerator.class);
    protected List<String> assignedUseCaseStateNames = new ArrayList<String>();
    protected StateModel model;

    public void generate(StateModel stateModel, File destDir) throws IOException {
        this.model = stateModel;
        for (StateModelStateChart chart : stateModel.getStateCharts()) {
            this.generate(chart, chart.getStates(), destDir);
            this.generateUseCaseEngineFromModel(stateModel, chart, destDir);
        }
    }

    protected String getFilenameFromState(StateModelStateChart chart, StateModelState state) {
        return (this.getPackageFromState(chart) + '.' + this.getNameFromState(state)).replace('.', File.separatorChar) + ".java";
    }

    protected String getNameFromState(StateModelState state) {
        return "Abstract" + GeneratorUtil.toUpperCaseFirstLetter((String)state.getName());
    }

    protected String getPackageFromState(StateModelStateChart chart) {
        return chart.getPackageName().replaceFirst("web", "web.pages");
    }

    protected String getPackageFromComponents(StateModelStateChart chart) {
        return chart.getPackageName().replaceFirst("web.*", "web.base");
    }

    protected void generate(StateModelStateChart chart, Collection<StateModelState> states, File destDir) throws IOException {
        for (Object oState : states.toArray()) {
            this.generateFromState(chart, (StateModelState)oState, destDir);
        }
    }

    protected void generateFromState(StateModelStateChart chart, StateModelState state, File destDir) throws IOException {
        if (state.isComplex()) {
            StateModelComplexState complexeState = (StateModelComplexState)state;
            this.generate(chart, complexeState.getStates(), destDir);
        } else {
            StateModelSimpleState simpleState = (StateModelSimpleState)state;
            if (!simpleState.isFinal() && !simpleState.isInitial()) {
                String filename = this.getFilenameFromState(chart, (StateModelState)simpleState);
                File outputFile = this.getDestinationFile(destDir, filename);
                if (this.getOverwrite() || !this.isNewerThanSource(outputFile)) {
                    try {
                        StringWriter out = new StringWriter();
                        MonitorWriter monitorOut = new MonitorWriter(out);
                        this.generateFromSimpleState((Writer)monitorOut, chart, (StateModelState)simpleState);
                        this.write(outputFile, monitorOut);
                    }
                    catch (Exception eee) {
                        log.warn((Object)("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFile));
                        throw new RuntimeException("Erreur lors de la g\u00e9n\u00e9ration du fichier " + outputFile, eee);
                    }
                }
            }
        }
    }

    protected void generateFromSimpleState(Writer output, StateModelStateChart chart, StateModelState state) throws IOException {
        String copyright = this.model.getTagValue("copyright");
        if (copyright != null && !copyright.isEmpty()) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("// Automatically generated by LutinGenerator\n");
        output.write("package " + this.getPackageFromState(chart) + ";\n");
        output.write("\n");
        output.write("import org.apache.tapestry5.annotations.InjectPage;\n");
        output.write("import " + this.getPackageFromComponents(chart) + ".UseCasePage;\n");
        output.write("\n");
        output.write("/*\n");
        output.write(" * State " + this.getNameFromState(state) + "\n");
        output.write(" */\n");
        output.write("public abstract class " + this.getNameFromState(state) + " extends UseCasePage {\n");
        output.write("");
        this.generateInjectionAndEventsFromState(output, chart, state);
        this.generateUseCaseNameFromState(output, chart, state);
        output.write("}");
    }

    protected void generateInjectionAndEventsFromState(Writer output, StateModelStateChart chart, StateModelState state) throws IOException {
        ArrayList<StateModelState> destStates = new ArrayList<StateModelState>();
        for (StateModelTransition transition : state.getTransitions()) {
            StateModelState toState = transition.getDestinationState();
            if (toState.isComplex()) {
                StateModelState toInitState = ((StateModelComplexState)toState).getInitialState();
                if (!destStates.contains(toState)) {
                    destStates.add(toState);
                    output.write("\n");
                    output.write("    /* linked state \"" + toState.getName() + "\" */\n");
                    output.write("    @InjectPage\n");
                    output.write("    private " + GeneratorUtil.toUpperCaseFirstLetter((String)toInitState.getName()) + " " + GeneratorUtil.toLowerCaseFirstLetter((String)toInitState.getName()) + ";\n");
                    output.write("");
                    output.write("\n");
                    output.write("    /* getter for state \"" + toState.getName() + "\" */\n");
                    output.write("    protected " + GeneratorUtil.toUpperCaseFirstLetter((String)toInitState.getName()) + " get" + GeneratorUtil.toUpperCaseFirstLetter((String)toInitState.getName()) + "() {\n");
                    output.write("        return " + GeneratorUtil.toLowerCaseFirstLetter((String)toInitState.getName()) + ";\n");
                    output.write("    }\n");
                    output.write("");
                }
                output.write("\n");
                output.write("    /* transition on " + transition.getEvent() + " event */\n");
                output.write("    public Object onActionFrom" + GeneratorUtil.toUpperCaseFirstLetter((String)transition.getEvent()) + "() {\n");
                output.write("        enterUseCase();\n");
                output.write("        return " + GeneratorUtil.toLowerCaseFirstLetter((String)toInitState.getName()) + ";\n");
                output.write("    }\n");
                output.write("");
                continue;
            }
            StateModelSimpleState simpleToState = (StateModelSimpleState)toState;
            if (!simpleToState.isFinal() && !destStates.contains(toState)) {
                destStates.add(toState);
                output.write("\n");
                output.write("    /* linked state \"" + simpleToState.getName() + "\" */\n");
                output.write("    @InjectPage\n");
                output.write("    private " + GeneratorUtil.toUpperCaseFirstLetter((String)simpleToState.getName()) + " " + GeneratorUtil.toLowerCaseFirstLetter((String)simpleToState.getName()) + ";\n");
                output.write("");
                output.write("\n");
                output.write("    /* getter for state \"" + simpleToState.getName() + "\" */\n");
                output.write("    protected " + GeneratorUtil.toUpperCaseFirstLetter((String)simpleToState.getName()) + " get" + GeneratorUtil.toUpperCaseFirstLetter((String)simpleToState.getName()) + "() {\n");
                output.write("        return " + GeneratorUtil.toLowerCaseFirstLetter((String)simpleToState.getName()) + ";\n");
                output.write("    }\n");
                output.write("");
            }
            output.write("\n");
            output.write("    /* transition on \"" + transition.getEvent() + "\" event */\n");
            output.write("    public Object onActionFrom" + GeneratorUtil.toUpperCaseFirstLetter((String)transition.getEvent()) + "() {\n");
            output.write("");
            if (simpleToState.isFinal()) {
                output.write("        return leaveUseCase();\n");
                output.write("");
            } else {
                output.write("        return " + GeneratorUtil.toLowerCaseFirstLetter((String)simpleToState.getName()) + ";\n");
                output.write("");
            }
            output.write("    }\n");
            output.write("");
        }
    }

    protected void generateUseCaseNameFromState(Writer output, StateModelStateChart chart, StateModelState state) throws IOException {
        String stateId = this.generateStateUseCaseName(state.getName());
        output.write("\n");
        output.write("    /* return a unique state id for model */\n");
        output.write("    protected final String getUseCaseName() {\n");
        output.write("        return \"" + stateId + "\";\n");
        output.write("    }\n");
        output.write("");
    }

    protected String generateStateUseCaseName(String name) {
        String ucsn;
        String uniqueucsn = ucsn = this.getHashStateName(name);
        int num = 2;
        while (this.assignedUseCaseStateNames.contains(uniqueucsn)) {
            uniqueucsn = new StringBuffer(ucsn).append(num++).toString();
        }
        this.assignedUseCaseStateNames.add(uniqueucsn);
        return uniqueucsn;
    }

    protected String getHashStateName(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        return sb.toString();
    }

    protected void generateUseCaseEngineFromModel(StateModel model, StateModelStateChart chart, File destDir) throws IOException {
        MonitorWriter monitorOut;
        StringWriter out;
        String componentPackageName = this.getPackageFromComponents(chart);
        String filename = (componentPackageName + ".UseCasePage").replace('.', File.separatorChar) + ".java";
        File outputFile = this.getDestinationFile(destDir, filename);
        if (this.getOverwrite() || !this.isNewerThanSource(outputFile)) {
            try {
                out = new StringWriter();
                monitorOut = new MonitorWriter(out);
                this.generateUseCasePageClass(monitorOut, model, componentPackageName);
                this.write(outputFile, monitorOut);
            }
            catch (Exception e) {
                log.warn((Object)"Erreur lors de la g\u00e9n\u00e9ration du fichier UseCasePage", (Throwable)e);
                throw new RuntimeException("Erreur lors de la g\u00e9n\u00e9ration du fichier UseCasePage", e);
            }
        }
        filename = (componentPackageName + ".UseCaseMap").replace('.', File.separatorChar) + ".java";
        outputFile = this.getDestinationFile(destDir, filename);
        if (this.getOverwrite() || !this.isNewerThanSource(outputFile)) {
            try {
                out = new StringWriter();
                monitorOut = new MonitorWriter(out);
                this.generateUseCaseMapClass(monitorOut, componentPackageName);
                this.write(outputFile, monitorOut);
            }
            catch (Exception e) {
                log.warn((Object)"Erreur lors de la g\u00e9n\u00e9ration du fichier UseCaseMap", (Throwable)e);
                throw new RuntimeException("Erreur lors de la g\u00e9n\u00e9ration du fichier UseCaseMap", e);
            }
        }
    }

    private void generateUseCasePageClass(MonitorWriter output, StateModel model, String componentPackageName) throws IOException {
        String tagUseCaseEngineExtendedClass;
        output.write("package " + componentPackageName + ";\n");
        output.write("\n");
        output.write("import org.apache.tapestry5.Link;\n");
        output.write("import org.apache.tapestry5.annotations.SessionState;\n");
        output.write("import org.apache.tapestry5.ioc.annotations.Inject;\n");
        output.write("import org.apache.tapestry5.annotations.Service;\n");
        output.write("import org.apache.tapestry5.services.LinkCreationHub;\n");
        output.write("import org.apache.tapestry5.services.LinkCreationListener;\n");
        output.write("import org.apache.tapestry5.services.Request;\n");
        output.write("\n");
        output.write("public abstract class UseCasePage");
        Map tagValues = model.getTagValues();
        if (tagValues != null && (tagUseCaseEngineExtendedClass = (String)tagValues.get("usecaseengineextendedclass")) != null) {
            output.write(" extends " + tagUseCaseEngineExtendedClass + "");
        }
        output.write(" implements LinkCreationListener {\n");
        output.write("\n");
        output.write("    private static final String UC_PARAMETER_NAME = \"UC\";\n");
        output.write("    private static final String UC_PARAMETER_SEPARATOR = \":\";\n");
        output.write("    \n");
        output.write("    @SessionState\n");
        output.write("    private UseCaseMap useCaseManager;\n");
        output.write("    private boolean useCaseManagerExists;\n");
        output.write("    \n");
        output.write("    @Inject\n");
        output.write("    @Service(\"LinkCreationHub\")\n");
        output.write("    private LinkCreationHub linkFactory;\n");
        output.write("    \n");
        output.write("    @Inject\n");
        output.write("    @Service(\"Request\")\n");
        output.write("    private Request request;\n");
        output.write("\n");
        output.write("    private String UCName;\n");
        output.write("    \n");
        output.write("    public void onActivate() {\n");
        output.write("        linkFactory.addListener(this);\n");
        output.write("        \n");
        output.write("        UCName = request.getParameter(UC_PARAMETER_NAME);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    protected abstract String getUseCaseName();\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Create stack if not exists\n");
        output.write("     */\n");
        output.write("    protected void init() {\n");
        output.write("        if (!useCaseManagerExists) {\n");
        output.write("            useCaseManager = new UseCaseMap();\n");
        output.write("        }\n");
        output.write("    }\n");
        output.write("    /**\n");
        output.write("     * Enter in a new sub use case\n");
        output.write("     */\n");
        output.write("    protected void enterUseCase() {\n");
        output.write("        init();\n");
        output.write("        // current\n");
        output.write("        String currentUCN = UCName;\n");
        output.write("        // new\n");
        output.write("        UCName = (currentUCN == null) ? getUseCaseName() : currentUCN + UC_PARAMETER_SEPARATOR + getUseCaseName();\n");
        output.write("        useCaseManager.enterSubUseCase(UCName, currentUCN, this);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Leave a sub use case\n");
        output.write("     */\n");
        output.write("    protected UseCasePage leaveUseCase() {\n");
        output.write("        init();\n");
        output.write("        \n");
        output.write("        UseCasePage nextPage = null;\n");
        output.write("        \n");
        output.write("        // current UCN\n");
        output.write("        String UC = UCName;\n");
        output.write("\n");
        output.write("        // get state\n");
        output.write("        Object[] response = useCaseManager.leaveUseCase(UC);\n");
        output.write("        \n");
        output.write("        // if null, return null, don't change page\n");
        output.write("        if(response != null) {\n");
        output.write("            // get UCN before enter this one\n");
        output.write("            UCName = (String) response[0];\n");
        output.write("        \n");
        output.write("            nextPage = (UseCasePage) response[1];\n");
        output.write("        }\n");
        output.write("\n");
        output.write("        return nextPage;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /*\n");
        output.write("     * @see org.apache.tapestry5.services.LinkCreationListener#createdComponentEventLink(org.apache.tapestry5.Link)\n");
        output.write("     */\n");
        output.write("    @Override\n");
        output.write("    public void createdComponentEventLink(Link link) {\n");
        output.write("        addUCParameter(link);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    /*\n");
        output.write("     * @see org.apache.tapestry5.services.LinkCreationListener#createdPageRenderLink(org.apache.tapestry5.Link)\n");
        output.write("     */\n");
        output.write("    @Override\n");
        output.write("    public void createdPageRenderLink(Link link) {\n");
        output.write("        // PageLink englobe ausssi les redirects envoy\u00e9s au client apres une\n");
        output.write("        // action\n");
        output.write("        addUCParameter(link);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    protected void addUCParameter(Link link) {\n");
        output.write("        if(link.getParameterValue(UC_PARAMETER_NAME) == null) {\n");
        output.write("\n");
        output.write("            if(UCName != null) {\n");
        output.write("                link.addParameter(UC_PARAMETER_NAME, UCName);\n");
        output.write("            }\n");
        output.write("        }\n");
        output.write("    }\n");
        output.write("}\n");
        output.write("");
    }

    private void generateUseCaseMapClass(MonitorWriter output, String componentPackageName) throws IOException {
        output.write("package " + componentPackageName + ";\n");
        output.write("\n");
        output.write("import java.util.HashMap;\n");
        output.write("import java.util.Map;\n");
        output.write("\n");
        output.write("public class UseCaseMap {\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Map (state name -> state instance)\n");
        output.write("     */\n");
        output.write("    private Map<String,Object[]> mapUseCase;\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Constructor\n");
        output.write("     */\n");
        output.write("    public UseCaseMap () {\n");
        output.write("        mapUseCase = new HashMap<String,Object[]>();\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * New sub use case\n");
        output.write("     */\n");
        output.write("    public void enterSubUseCase(String newUseCaseName, String previousUseCaseName, Object state) {\n");
        output.write("        mapUseCase.put(newUseCaseName,new Object[]{previousUseCaseName,state});\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    /**\n");
        output.write("     * Finish a subusecase\n");
        output.write("     * \n");
        output.write("     * Return the state that init the subuse case\n");
        output.write("     * @return a state\n");
        output.write("     */\n");
        output.write("    public Object[] leaveUseCase(String useCaseName) {\n");
        output.write("        return mapUseCase.get(useCaseName);\n");
        output.write("    }\n");
        output.write("}\n");
        output.write("");
    }
}

