/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.service.sql.batch.SqlRequests;
import org.nuiton.topia.service.sql.batch.TopiaSqlBatchService;
import org.nuiton.topia.service.sql.batch.TopiaSqlBatchServiceConfiguration;
import org.nuiton.topia.service.sql.batch.actions.AbstractSqlAction;
import org.nuiton.topia.service.sql.batch.actions.AbstractSqlRequest;
import org.nuiton.topia.service.sql.batch.actions.CreateSchemaAction;
import org.nuiton.topia.service.sql.batch.actions.CreateSchemaRequest;
import org.nuiton.topia.service.sql.batch.actions.DeleteTablesAction;
import org.nuiton.topia.service.sql.batch.actions.DeleteTablesRequest;
import org.nuiton.topia.service.sql.batch.actions.DropSchemaAction;
import org.nuiton.topia.service.sql.batch.actions.DropSchemaRequest;
import org.nuiton.topia.service.sql.batch.actions.ReplicateTablesAction;
import org.nuiton.topia.service.sql.batch.actions.ReplicateTablesRequest;
import org.nuiton.topia.service.sql.batch.actions.UpdateTablesAction;
import org.nuiton.topia.service.sql.batch.actions.UpdateTablesRequest;

public class TopiaSqlBatchServiceImpl
implements TopiaSqlBatchService {
    private static final ImmutableMap<Class, Class> ACTION_MAPPING = ImmutableMap.builder().put(CreateSchemaRequest.class, CreateSchemaAction.class).put(DropSchemaRequest.class, DropSchemaAction.class).put(ReplicateTablesRequest.class, ReplicateTablesAction.class).put(UpdateTablesRequest.class, UpdateTablesAction.class).put(DeleteTablesRequest.class, DeleteTablesAction.class).build();
    protected TopiaApplicationContext topiaApplicationContext;
    protected TopiaSqlBatchServiceConfiguration configuration;

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        this.topiaApplicationContext = topiaApplicationContext;
        this.configuration = new TopiaSqlBatchServiceConfiguration();
        String readFetchSizeStr = serviceConfiguration.get("readFetchSize");
        int readFetchSize = readFetchSizeStr != null ? Integer.valueOf(readFetchSizeStr) : 1000;
        this.configuration.setReadFetchSize(readFetchSize);
        String writeBatchSizeStr = serviceConfiguration.get("writeBatchSize");
        int writeBatchSize = writeBatchSizeStr == null ? 1000 : Integer.valueOf(writeBatchSizeStr);
        this.configuration.setWriteBatchSize(writeBatchSize);
    }

    public void close() {
    }

    @Override
    public TopiaSqlBatchServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public SqlRequests.Builder requestBuilder() {
        return SqlRequests.builder().from(this.topiaApplicationContext);
    }

    @Override
    public CreateSchemaRequest.Builder createSchemaRequestBuilder() {
        return (CreateSchemaRequest.Builder)CreateSchemaRequest.builder().from(this.topiaApplicationContext);
    }

    @Override
    public DropSchemaRequest.Builder dropSchemaRequestBuilder() {
        return (DropSchemaRequest.Builder)DropSchemaRequest.builder().from(this.topiaApplicationContext);
    }

    @Override
    public ReplicateTablesRequest.Builder replicateTablesRequestBuilder() {
        return (ReplicateTablesRequest.Builder)((ReplicateTablesRequest.Builder)((ReplicateTablesRequest.Builder)ReplicateTablesRequest.builder().from(this.topiaApplicationContext)).setReadFetchSize(this.configuration.getReadFetchSize())).setWriteBatchSize(this.configuration.getWriteBatchSize());
    }

    @Override
    public UpdateTablesRequest.Builder updateTablesRequestBuilder() {
        return (UpdateTablesRequest.Builder)((UpdateTablesRequest.Builder)((UpdateTablesRequest.Builder)UpdateTablesRequest.builder().from(this.topiaApplicationContext)).setReadFetchSize(this.configuration.getReadFetchSize())).setWriteBatchSize(this.configuration.getWriteBatchSize());
    }

    @Override
    public DeleteTablesRequest.Builder deleteTablesRequestBuilder() {
        return (DeleteTablesRequest.Builder)((DeleteTablesRequest.Builder)((DeleteTablesRequest.Builder)DeleteTablesRequest.builder().from(this.topiaApplicationContext)).setReadFetchSize(this.configuration.getReadFetchSize())).setWriteBatchSize(this.configuration.getWriteBatchSize());
    }

    @Override
    public void execute(SqlRequests requests) {
        Iterator<AbstractSqlRequest> sqlRequestIterator = requests.iterator();
        while (sqlRequestIterator.hasNext()) {
            AbstractSqlRequest sqlRequest = sqlRequestIterator.next();
            Object action = this.createAction(sqlRequest);
            ((AbstractSqlAction)action).run();
            boolean needCommit = !sqlRequestIterator.hasNext();
            if (!needCommit) continue;
            ((AbstractSqlAction)action).commit();
        }
    }

    protected <R extends AbstractSqlRequest, A extends AbstractSqlAction<R>> A createAction(R request) {
        Constructor constructor;
        Preconditions.checkNotNull(request, (Object)"Request can't be null");
        Class actionType = (Class)ACTION_MAPPING.get(request.getClass());
        Preconditions.checkNotNull((Object)actionType, (Object)("Could not find action for request type: " + request.getClass().getName()));
        try {
            constructor = actionType.getConstructor(request.getClass());
        }
        catch (NoSuchMethodException e) {
            throw new TopiaException((Throwable)e);
        }
        try {
            return (A)((AbstractSqlAction)constructor.newInstance(request));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new TopiaException((Throwable)e);
        }
    }

    @Override
    public void execute(CreateSchemaRequest request) {
        this.executeOneRequest(request);
    }

    @Override
    public void execute(DropSchemaRequest request) {
        this.executeOneRequest(request);
    }

    @Override
    public void execute(ReplicateTablesRequest request) {
        this.executeOneRequest(request);
    }

    @Override
    public void execute(UpdateTablesRequest request) {
        this.executeOneRequest(request);
    }

    @Override
    public void execute(DeleteTablesRequest request) {
        this.executeOneRequest(request);
    }

    protected void executeOneRequest(AbstractSqlRequest request) {
        SqlRequests sqlRequests = SqlRequests.of(request);
        this.execute(sqlRequests);
    }
}

