/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Encoder;

public class TaasUtil {
    private static Log log = LogFactory.getLog(TaasUtil.class);
    public static final int LOAD = 1;
    public static final String LOAD_TEXT = "LOAD";
    public static final int CREATE = 2;
    public static final String CREATE_TEXT = "CREATE";
    public static final int UPDATE = 4;
    public static final String UPDATE_TEXT = "UPDATE";
    public static final int DELETE = 8;
    public static final String DELETE_TEXT = "DELETE";

    public static String hash(String msg) {
        return TaasUtil.digestSHAHex(msg);
    }

    public static String digestSHABase64(String msg) {
        if (msg == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            byte[] bytes = msg.getBytes();
            bytes = digest.digest(bytes);
            BASE64Encoder encoder = new BASE64Encoder();
            String msgHashed = encoder.encode(bytes);
            return msgHashed;
        }
        catch (NoSuchAlgorithmException nsee) {
            return msg;
        }
    }

    public static String digestSHAHex(String ch) {
        if (ch == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(ch.getBytes());
            byte[] digest = md.digest();
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                String hex = Integer.toHexString(0xFF & digest[i]);
                if (hex.length() == 1) {
                    result.append("0" + hex);
                    continue;
                }
                result.append(hex);
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException eee) {
            log.warn((Object)"Impossible de trouve l'algo SHA", (Throwable)eee);
            return ch;
        }
    }

    public static int actionsString2Int(String actions) {
        int result = 0;
        StringTokenizer tokens = new StringTokenizer(actions, ",");
        while (tokens.hasMoreTokens()) {
            String action = tokens.nextToken().trim();
            if (LOAD_TEXT.equalsIgnoreCase(action)) {
                result |= 1;
                continue;
            }
            if (CREATE_TEXT.equalsIgnoreCase(action)) {
                result |= 2;
                continue;
            }
            if (UPDATE_TEXT.equalsIgnoreCase(action)) {
                result |= 4;
                continue;
            }
            if (DELETE_TEXT.equalsIgnoreCase(action)) {
                result |= 8;
                continue;
            }
            throw new IllegalArgumentException("action not supported: " + action);
        }
        return result;
    }

    public static String actionsInt2String(int actions) {
        StringBuffer result = new StringBuffer();
        if ((actions & 1) == 1) {
            result.append(LOAD_TEXT);
            result.append(",");
        }
        if ((actions & 2) == 2) {
            result.append(CREATE_TEXT);
            result.append(",");
        }
        if ((actions & 4) == 4) {
            result.append(UPDATE_TEXT);
            result.append(",");
        }
        if ((actions & 8) == 8) {
            result.append(DELETE_TEXT);
            result.append(",");
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    public static boolean isImplement(Class<?> klass, Class<?> iface) {
        boolean result = false;
        Object[] interfaces = klass.getInterfaces();
        Class<?> superclass = klass.getSuperclass();
        if (!(result |= ArrayUtils.contains((Object[])interfaces, iface)) && superclass != null) {
            result |= TaasUtil.isImplement(superclass, iface);
        }
        return result;
    }

    public static Set<String> getPrincipalNames(Subject subj) {
        HashSet<String> result = new HashSet<String>();
        if (subj != null && subj.getPrincipals() != null) {
            for (Principal p : subj.getPrincipals()) {
                result.add(p.getName());
            }
        }
        return result;
    }
}

