package org.nuiton.topia.taas.entities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link TaasAuthorization}.
 */
public abstract class TaasAuthorizationAbstract extends TopiaEntityAbstract implements TaasAuthorization {

    protected String expression;

    protected int actions;

    /**
     * Constructeur de TaasAuthorizationAbstract par défaut.
     */
    public TaasAuthorizationAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasAuthorization.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasAuthorization.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "expression", String.class, expression);
        visitor.visit(this, "actions", int.class, actions);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see TaasAuthorization#setExpression(String)
     */
    @Override
    public void setExpression(String value) {
        String _oldValue = this.expression;
        fireOnPreWrite("expression", _oldValue, value);
        this.expression = value;
        fireOnPostWrite("expression", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasAuthorization#getExpression()
     */
    @Override
    public String getExpression() {
        fireOnPreRead("expression", expression);
        String result = this.expression;
        fireOnPostRead("expression", expression);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasAuthorization#setActions(int)
     */
    @Override
    public void setActions(int value) {
        int _oldValue = this.actions;
        fireOnPreWrite("actions", _oldValue, value);
        this.actions = value;
        fireOnPostWrite("actions", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasAuthorization#getActions()
     */
    @Override
    public int getActions() {
        fireOnPreRead("actions", actions);
        int result = this.actions;
        fireOnPostRead("actions", actions);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("expression", this.expression).
            append("actions", this.actions).
         toString();
        return result;
    }
        
} //TaasAuthorizationAbstract
