package org.nuiton.topia.security.entities.authorization;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.security.listener.NoSecurityLoad;

/**
 * Implantation POJO pour l'entité {@link TopiaAssociationAuthorization}.
 */
public abstract class TopiaAssociationAuthorizationAbstract extends org.nuiton.topia.security.entities.authorization.TopiaAuthorizationImpl implements TopiaAssociationAuthorization {

    public String idBeginAssociation;

    public String nameAssociation;

    public int actions;

    public Set principals;

    /**
     * Constructeur de TopiaAssociationAuthorizationAbstract par défaut.
     */
    public TopiaAssociationAuthorizationAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaAssociationAuthorization.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaAssociationAuthorization.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "idBeginAssociation", String.class, idBeginAssociation);
        visitor.visit(this, "nameAssociation", String.class, nameAssociation);
        visitor.visit(this, "actions", int.class, actions);
        visitor.visit(this, "principals", Set.class, principals);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#setIdBeginAssociation(String)
     */
    @Override
    public void setIdBeginAssociation(String value) {
        String _oldValue = this.idBeginAssociation;
        fireOnPreWrite("idBeginAssociation", _oldValue, value);
        this.idBeginAssociation = value;
        fireOnPostWrite("idBeginAssociation", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#getIdBeginAssociation()
     */
    @Override
    public String getIdBeginAssociation() {
        fireOnPreRead("idBeginAssociation", idBeginAssociation);
        String result = this.idBeginAssociation;
        fireOnPostRead("idBeginAssociation", idBeginAssociation);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#setNameAssociation(String)
     */
    @Override
    public void setNameAssociation(String value) {
        String _oldValue = this.nameAssociation;
        fireOnPreWrite("nameAssociation", _oldValue, value);
        this.nameAssociation = value;
        fireOnPostWrite("nameAssociation", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#getNameAssociation()
     */
    @Override
    public String getNameAssociation() {
        fireOnPreRead("nameAssociation", nameAssociation);
        String result = this.nameAssociation;
        fireOnPostRead("nameAssociation", nameAssociation);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#setActions(int)
     */
    @Override
    public void setActions(int value) {
        int _oldValue = this.actions;
        fireOnPreWrite("actions", _oldValue, value);
        this.actions = value;
        fireOnPostWrite("actions", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#getActions()
     */
    @Override
    public int getActions() {
        fireOnPreRead("actions", actions);
        int result = this.actions;
        fireOnPostRead("actions", actions);
        return result;
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#setPrincipals(Set)
     */
    @Override
    public void setPrincipals(Set value) {
        Set _oldValue = this.principals;
        fireOnPreWrite("principals", _oldValue, value);
        this.principals = value;
        fireOnPostWrite("principals", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TopiaAssociationAuthorization#getPrincipals()
     */
    @Override
    public Set getPrincipals() {
        fireOnPreRead("principals", principals);
        Set result = this.principals;
        fireOnPostRead("principals", principals);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("idBeginAssociation", this.idBeginAssociation).
            append("nameAssociation", this.nameAssociation).
            append("actions", this.actions).
            append("principals", this.principals).
         toString();
        return result;
    }
        
} //TopiaAssociationAuthorizationAbstract
