/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.TopiaReplicationOperationProvider;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class TopiaReplicationModelBuilder {
    private static final Log log = LogFactory.getLog(TopiaReplicationModelBuilder.class);
    protected TopiaReplicationOperationProvider operationProvider;

    public TopiaReplicationOperationProvider getOperationProvider() {
        if (this.operationProvider == null) {
            this.operationProvider = new TopiaReplicationOperationProvider();
        }
        return this.operationProvider;
    }

    public ReplicationModel prepare(TopiaApplicationContext context, TopiaEntityEnum[] contracts, boolean computeOrder, String ... topiaIds) throws TopiaException {
        ReplicationModel model = this.createModel(context, contracts, computeOrder, topiaIds);
        this.initModel(model, computeOrder);
        return model;
    }

    public ReplicationModel prepareForAll(TopiaEntityEnum[] contracts) throws TopiaException {
        ReplicationModel model = this.createModelForAll(contracts);
        this.initModel(model, true);
        return model;
    }

    public void createOperation(ReplicationModel model, TopiaEntityEnum type, ReplicationOperationPhase phase, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) {
        TopiaEntityHelper.checkNotNull((String)"createOperation", (String)"model", (Object)model);
        TopiaEntityHelper.checkNotNull((String)"createOperation", (String)"type", (Object)type);
        TopiaEntityHelper.checkNotNull((String)"createOperation", (String)"phase", (Object)((Object)phase));
        TopiaEntityHelper.checkNotNull((String)"createOperation", (String)"operationClass", operationClass);
        TopiaReplicationOperation operation = this.getOperationProvider().getOperation(operationClass);
        if (operation == null) {
            throw new IllegalArgumentException(String.format("The operation %1$s is unknown, known operations are: %2$s", operationClass.getSimpleName(), Arrays.toString(this.getOperationProvider().getOperations())));
        }
        ReplicationNode node = model.getNode(type);
        if (node == null) {
            throw new IllegalArgumentException(String.format("The target node (of type %1$s) for operation %2$s is unknown, known nodes are: %3$s", type, operationClass.getSimpleName(), model.getNodes()));
        }
        operation.register(model, node, phase, parameters);
    }

    public void addBeforeOperation(ReplicationModel model, TopiaEntityEnum type, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) {
        this.createOperation(model, type, ReplicationOperationPhase.before, operationClass, parameters);
    }

    public void addAfterOperation(ReplicationModel model, TopiaEntityEnum type, Class<? extends TopiaReplicationOperation> operationClass, Object ... parameters) {
        this.createOperation(model, type, ReplicationOperationPhase.after, operationClass, parameters);
    }

    public ReplicationModel createModel(TopiaApplicationContext context, TopiaEntityEnum[] contracts, boolean computeOrder, String ... topiaIds) throws TopiaException {
        ReplicationModel model;
        if (computeOrder) {
            Set<Class<? extends TopiaEntity>> detectTypes = this.detectTypes(context, contracts, topiaIds);
            model = new ReplicationModel(contracts, detectTypes, topiaIds);
        } else {
            model = new ReplicationModel(contracts, false, topiaIds);
        }
        return model;
    }

    public ReplicationModel createModelForAll(TopiaEntityEnum[] contracts) throws TopiaException {
        ReplicationModel model = new ReplicationModel(contracts, true, new String[0]);
        return model;
    }

    public ReplicationModel initModel(ReplicationModel model, boolean computeOrder) throws TopiaException {
        TopiaEntityHelper.checkNotNull((String)"initModel", (String)"model", (Object)model);
        model.detectAssociations(new TopiaEntityEnum[0]);
        model.detectDirectDependencies();
        if (computeOrder) {
            model.detectShell();
            model.detectDependencies();
        }
        model.detectObjectsToDettach();
        model.detectOperations();
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Class<? extends TopiaEntity>> detectTypes(TopiaApplicationContext context, TopiaEntityEnum[] contracts, String ... ids) throws TopiaException {
        TopiaPersistenceContext ctxt = context.newPersistenceContext();
        try {
            TopiaEntity[] entities = TopiaEntityHelper.getEntities((TopiaPersistenceContext)ctxt, (String[])ids);
            Set types = TopiaEntityHelper.detectTypes((TopiaEntityEnum[])contracts, (TopiaEntity[])entities);
            if (log.isDebugEnabled()) {
                log.debug((Object)("for type : " + entities.getClass()));
                for (Class k : types) {
                    log.debug((Object)k);
                }
            }
            Set set = types;
            return set;
        }
        finally {
            ctxt.closeContext();
        }
    }
}

