/* *##% ToPIA - Migration service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/
package org.nuiton.topia.migration.transformation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.util.Version;

/**
 * FinderMigration.java
 * 
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1459 $
 * 
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 */
public class FinderMigration {

    /**
     * Nom du package de migration
     */
    private static String PACKAGE = "migration";
    /**
     * Logger (common-logging)
     */
    private static Log logger = LogFactory.getLog(FinderMigration.class);

    /**
     * Constructeur vide.
     */
    public FinderMigration() {
    }

    /**
     * Constructeur
     * 
     * @param packag
     *            nouveau package
     */
    public FinderMigration(String packag) {
        this();
        FinderMigration.PACKAGE = packag;
    }

    /**
     * Use to get migration class for one version to next version
     * 
     * @param klass
     *            class
     * @param base
     *            base version
     * @param next
     *            destination version
     * @return the migration implementation class
     */
    public MigrationClass getMigrationClass(ProxyClass klass, Version base,
            Version next) {

        MigrationClass mcResult = null;

        String baseFullName = klass.getCanonicalName();
        String baseLittleName = baseFullName.substring(baseFullName.lastIndexOf('.') + 1);
        String basePackage = baseFullName.substring(0, baseFullName.lastIndexOf('.'));

        // Convention :
        // - meme package
        // - Migration<Class>V<n>V<m>
        String newClassName = basePackage + "." + PACKAGE + "." + "V" + base.getVersion() + "V" + next.getVersion() + "." + baseLittleName;

        try {
            Class.forName(newClassName);

            logger.debug("Using '" + newClassName + "' migration class");

            // pas d'exception, la classe existe
            mcResult = new MigrationClass(newClassName, baseFullName, base,
                    next);
        } catch (ClassNotFoundException e) {
            // no migration class
            // but this is not an error
            logger.debug("No '" + newClassName + "' migration class");
        }

        return mcResult;
    }
}
