/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.history;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.history.TopiaHistoryListener;
import org.nuiton.topia.history.TopiaHistoryService;
import org.nuiton.topia.history.entities.HistoryImpl;
import org.nuiton.topia.security.util.TopiaSecurityUtil;

public class TopiaHistoryServiceImpl
implements TopiaHistoryService,
Runnable,
TopiaTransactionVetoable {
    private static Log log = LogFactory.getLog(TopiaHistoryServiceImpl.class);
    private static final int FIELD_DATE = 0;
    private static final int FIELD_USER = 1;
    private static final int FIELD_ACTION = 2;
    private static final int FIELD_TYPE = 3;
    private static final int FIELD_TARGET = 4;
    private static final String HISTORY_CREATE_KEY = "topia.service.history.create";
    private static final String HISTORY_DELETE_KEY = "topia.service.history.delete";
    private static final String HISTORY_UPDATE_KEY = "topia.service.history.update";
    private static final String HISTORY_LOAD_KEY = "topia.service.history.load";
    private static final String HISTORY_CLEAN_FREQUENCY_KEY = "topia.service.history.clean.frequency";
    private static final String HISTORY_CLEAN_DATE_KEY = "topia.service.history.clean.date";
    private static final String HISTORY_CLEAN_NUMBER_KEY = "topia.service.history.clean.number";
    private static final String HISTORY_STORE_FILE_KEY = "topia.service.history.store.file";
    protected TopiaHistoryListener historyListener = null;
    protected TopiaContextImplementor context = null;
    protected float cleanFrequency = -1.0f;
    protected int cleanDate = -1;
    protected int cleanNumber = -1;
    protected File storeFile = null;
    protected ScheduledThreadPoolExecutor task = null;

    public String getServiceName() {
        return "history";
    }

    public Class<?>[] getPersistenceClasses() {
        return new Class[]{HistoryImpl.class};
    }

    public boolean preInit(TopiaContextImplementor context) {
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        this.context = context;
        Properties config = context.getConfig();
        boolean historyCreate = "true".equalsIgnoreCase(config.getProperty(HISTORY_CREATE_KEY, "true"));
        boolean historyDelete = "true".equalsIgnoreCase(config.getProperty(HISTORY_DELETE_KEY, "true"));
        boolean historyUpdate = "true".equalsIgnoreCase(config.getProperty(HISTORY_UPDATE_KEY, "true"));
        boolean historyLoad = "true".equalsIgnoreCase(config.getProperty(HISTORY_LOAD_KEY, "true"));
        this.historyListener = new TopiaHistoryListener((TopiaContext)context, historyCreate, historyDelete, historyUpdate, historyLoad);
        context.addTopiaEntityListener((TopiaEntityListener)this.historyListener);
        context.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
        this.cleanFrequency = Float.parseFloat(config.getProperty(HISTORY_CLEAN_FREQUENCY_KEY, "" + this.cleanFrequency));
        this.cleanDate = Integer.parseInt(config.getProperty(HISTORY_CLEAN_DATE_KEY, "" + this.cleanDate));
        this.cleanNumber = Integer.parseInt(config.getProperty(HISTORY_CLEAN_NUMBER_KEY, "" + this.cleanNumber));
        String storeFilename = config.getProperty(HISTORY_STORE_FILE_KEY);
        if (storeFilename != null) {
            this.storeFile = new File(storeFilename);
        }
        if (this.cleanFrequency > 0.0f) {
            this.task = new ScheduledThreadPoolExecutor(1);
            Calendar cal = Calendar.getInstance();
            cal.setLenient(true);
            cal.set(11, 0);
            cal.set(6, cal.get(6) + 1);
            long initialDelay = cal.getTimeInMillis() - System.currentTimeMillis();
            long period = (long)this.cleanFrequency * 24L * 3600L * 1000L;
            this.task.scheduleAtFixedRate(this, initialDelay, period, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    public void beginTransaction(TopiaTransactionEvent event) {
        TopiaContext tx = event.getTopiaContext();
        tx.addTopiaEntityListener((TopiaEntityListener)this.historyListener);
        tx.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
    }

    @Override
    public void clear(Date toDate) throws Exception {
        TopiaContext tx = this.context.beginTransaction();
        tx.find("delete from " + HistoryImpl.class.getName() + " where actionDate <= :date", new Object[]{"date", toDate});
        tx.commitTransaction();
        tx.closeContext();
    }

    @Override
    public void keep(int number) throws Exception {
    }

    @Override
    public void store(Date toDate, Writer out) throws Exception {
        if (out != null) {
            out = new BufferedWriter(out);
            TopiaContextImplementor tx = (TopiaContextImplementor)this.context.beginTransaction();
            ScrollableResults histories = tx.getHibernate().createCriteria(HistoryImpl.class).add((Criterion)Restrictions.ge((String)"actionDate", (Object)toDate)).addOrder(Order.asc((String)"actionDate")).setFlushMode(FlushMode.AUTO).scroll();
            while (histories.next()) {
                Date date = histories.getDate(0);
                String user = histories.getString(1);
                String action = TopiaSecurityUtil.actionsInt2String((int)histories.getInteger(2));
                String type = histories.getString(3);
                String target = histories.getString(4);
                String text = date + "," + user + "," + action + "," + type + "," + target + "\n";
                out.write(text);
            }
            out.flush();
            tx.closeContext();
        }
    }

    @Override
    public List<String> findLastAction(int limit, String user, String type, Integer ... actions) throws Exception {
        TopiaContextImplementor tx = (TopiaContextImplementor)this.context.beginTransaction();
        Criteria criteria = tx.getHibernate().createCriteria(HistoryImpl.class).setFlushMode(FlushMode.AUTO).addOrder(Order.desc((String)"actionDate"));
        criteria.add(Restrictions.in((String)"action", Arrays.asList(actions)));
        if (user != null) {
            criteria.add((Criterion)Restrictions.eq((String)"userId", (Object)user));
        }
        if (type != null) {
            criteria.add(Restrictions.in((String)"type", (Object[])new String[]{type, type + "Impl"}));
        }
        ArrayList<String> result = new ArrayList<String>();
        ScrollableResults histories = criteria.scroll();
        for (int i = limit; i == 0 && histories.next(); --i) {
            result.add(histories.getString(4));
        }
        tx.closeContext();
        return result;
    }

    @Override
    public void run() {
        block6: {
            log.info((Object)"Start history schuduling");
            try {
                FileWriter out = null;
                if (this.storeFile != null) {
                    this.storeFile.getParentFile().mkdirs();
                    out = new FileWriter(this.storeFile, true);
                }
                Date date = null;
                if (this.cleanNumber >= 0) {
                    TopiaContextImplementor tx = (TopiaContextImplementor)this.context.beginTransaction();
                    ScrollableResults histories = tx.getHibernate().createCriteria(HistoryImpl.class).setProjection((Projection)Property.forName((String)"actionDate")).addOrder(Order.desc((String)"actionDate")).setMaxResults(this.cleanNumber + 1).setFlushMode(FlushMode.AUTO).scroll();
                    histories.last();
                    date = histories.getDate(0);
                    tx.closeContext();
                } else {
                    if (this.cleanDate < 0) {
                        this.cleanDate = (int)this.cleanFrequency;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setLenient(true);
                    int day = cal.get(6);
                    cal.set(6, day - this.cleanDate);
                    date = cal.getTime();
                }
                this.store(date, out);
                this.clear(date);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Can't clean history", (Throwable)eee);
            }
        }
        log.info((Object)"End history schuduling");
    }
}

