/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaEntity;

public class HqlAndParametersBuilder<E extends TopiaEntity> {
    protected Class<E> entityClass;
    protected Set<String> whereClauses = Sets.newLinkedHashSet();
    protected Map<String, Object> parameters = Maps.newLinkedHashMap();
    protected Set<String> orderByArguments;
    protected String alias = "topiaEntity_";

    public void setAlias(String alias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)alias));
        this.alias = alias;
    }

    public HqlAndParametersBuilder(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public Set<String> getWhereClauses() {
        return this.whereClauses;
    }

    public void setWhereClauses(Set<String> whereClauses) {
        this.whereClauses = whereClauses;
    }

    public void addNull(String property) {
        this.whereClauses.add(this.alias + "." + property + " is null");
    }

    public void addNotNull(String property) {
        this.whereClauses.add(this.alias + "." + property + " is not null");
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setOrderByArguments(Set<String> orderByArguments) {
        this.orderByArguments = orderByArguments;
    }

    public void setOrderByArguments(String ... orderByArguments) {
        LinkedHashSet orderByArgumentsAsSet = Sets.newLinkedHashSet();
        orderByArgumentsAsSet.addAll(Arrays.asList(orderByArguments));
        this.orderByArguments = orderByArgumentsAsSet;
    }

    public void addEquals(String property, Object value) {
        Preconditions.checkNotNull((Object)property);
        if (value == null) {
            this.addNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " = :" + hqlParameterName);
        }
    }

    public void addIn(String property, Iterable<Object> values) {
        Preconditions.checkNotNull((Object)property);
        Preconditions.checkNotNull(values);
        Preconditions.checkArgument((!Iterables.isEmpty(values) ? 1 : 0) != 0);
        if (Iterables.size(values) == 1) {
            this.addEquals(property, Iterables.getOnlyElement(values));
        } else {
            String inClause;
            boolean propertyMayBeNull = false;
            LinkedHashSet hqlParameterNames = Sets.newLinkedHashSet();
            for (Object value : values) {
                if (value == null) {
                    propertyMayBeNull = true;
                    continue;
                }
                String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
                hqlParameterNames.add(hqlParameterName);
            }
            String whereClause = inClause = this.alias + "." + property + " in (:" + StringUtils.join((Iterable)hqlParameterNames, (String)", :") + ")";
            if (propertyMayBeNull) {
                whereClause = this.alias + "." + property + " is null or " + inClause;
            }
            this.whereClauses.add(whereClause);
        }
    }

    public void addTopiaIdEquals(String property, String topiaId) {
        this.addEquals(this.alias + "." + property + "." + "topiaId", topiaId);
    }

    public void addTopiaIdIn(String property, Iterable<String> topiaIds) {
        this.addIn(this.alias + "." + property + "." + "topiaId", topiaIds);
    }

    public void addContains(String property, Object value) {
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(":" + hqlParameterName + " in elements(" + this.alias + "." + property + ")");
    }

    public void addWhereClause(String whereClause) {
        this.whereClauses.add(whereClause);
    }

    public void addWhereClause(String whereClause, Map<String, Object> hqlParameters) {
        this.whereClauses.add(whereClause);
        this.parameters.putAll(hqlParameters);
    }

    public String getHql() {
        StringBuilder hqlStringBuilder = new StringBuilder();
        hqlStringBuilder.append("from ").append(this.entityClass.getCanonicalName()).append(" ").append(this.alias);
        if (!this.whereClauses.isEmpty()) {
            hqlStringBuilder.append(" where ").append(StringUtils.join(this.whereClauses, (String)" and "));
        }
        if (CollectionUtils.isNotEmpty(this.orderByArguments)) {
            hqlStringBuilder.append(" order by ").append(this.alias).append(".").append(StringUtils.join(this.orderByArguments, (String)(", " + this.alias + ".")));
        }
        String hql = hqlStringBuilder.toString();
        return hql;
    }

    protected String putHqlParameterWithAvailableName(String propertyName, Object value) {
        String parameterNamePrefix = propertyName.replaceAll("\\.", "");
        int suffix = 0;
        String parameterName = parameterNamePrefix;
        while (this.parameters.containsKey(parameterName)) {
            parameterName = parameterNamePrefix + ++suffix;
        }
        this.parameters.put(parameterName, value);
        return parameterName;
    }

    public Map<String, Object> getHqlParameters() {
        return this.parameters;
    }

    public boolean isOrderByClausePresent() {
        return CollectionUtils.isNotEmpty(this.orderByArguments);
    }
}

