package org.nuiton.topiatest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class CompanyDAOAbstract<E extends Company> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Company.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<org.nuiton.topiatest.Department> list = getContext()
                            .getDAO(org.nuiton.topiatest.Department.class)
                            .findAllByProperties("company", entity);
                    for (org.nuiton.topiatest.Department item : list) {
                        item.setCompany(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findContainsEmploye :
     * Retourne le premier élément trouvé dont l'attribut employe contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsEmploye(Employe... v) throws TopiaException {
        E result = findContainsProperties("employe", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsEmploye :
     * Retourne les éléments trouvé dont l'attribut employe contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsEmploye(Employe... v) throws TopiaException {
        List<E> results = findAllContainsProperties("employe", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsStore :
     * Retourne le premier élément trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsStore(Store... v) throws TopiaException {
        E result = findContainsProperties("store", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsStore :
     * Retourne les éléments trouvé dont l'attribut store contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsStore(Store... v) throws TopiaException {
        List<E> results = findAllContainsProperties("store", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsDepartment :
     * Retourne le premier élément trouvé dont l'attribut department contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsDepartment(Department... v) throws TopiaException {
        E result = findContainsProperties("department", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsDepartment :
     * Retourne les éléments trouvé dont l'attribut department contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsDepartment(Department... v) throws TopiaException {
        List<E> results = findAllContainsProperties("department", Arrays.asList(v));
        return results;
    }


} //CompanyDAOAbstract<E extends Company>
