/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class EntityDTOGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(EntityDTOGenerator.class);

    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DTO.java";
    }

    public boolean isEntity(String type) {
        ObjectModelClassifier clazz = ((ObjectModel)this.model).getClassifier(type);
        return clazz != null && clazz.hasStereotype("entity");
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        String assocClassFQN;
        String assocAttrName;
        String attrName;
        String attrType;
        String attrVisibility;
        ObjectModelAttribute reverse;
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(this.model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        String clazzName = clazz.getName();
        output.write("package " + clazz.getPackageName() + ";\n");
        output.write("\n");
        output.write("import org.apache.commons.lang.builder.ToStringBuilder;\n");
        output.write("import java.beans.PropertyChangeListener;\n");
        output.write("\n");
        output.write("/**\n");
        output.write(" * Implantation DTO pour l'entit\u00e9 " + GeneratorUtil.capitalize((String)clazzName) + ".\n");
        output.write(" */\n");
        output.write("");
        String extendClass = "";
        Iterator i = clazz.getSuperclasses().iterator();
        while (i.hasNext()) {
            ObjectModelClass parent = (ObjectModelClass)i.next();
            extendClass = extendClass + parent.getQualifiedName() + "DTO";
            if (!i.hasNext()) continue;
            extendClass = extendClass + ", ";
        }
        if (extendClass.length() > 0) {
            extendClass = "extends " + extendClass + " ";
        }
        output.write("public class " + clazzName + "DTO " + extendClass + "implements java.io.Serializable {\n");
        output.write("\n");
        output.write("");
        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", (ObjectModelElement)clazz, this.model);
        if (svUID != null) {
            output.write("    public static final long serialVersionUID = " + svUID + ";\n");
            output.write("\n");
            output.write("");
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                output.write("    /**\n");
                output.write("     * " + attr.getDocumentation() + "\n");
                output.write("     */\n");
                output.write("");
            }
            if (attr.hasTagValue("annotation")) {
                String annotation = attr.getTagValue("annotation");
                output.write("    " + annotation + "\n");
                output.write("");
            }
            attrVisibility = attr.getVisibility();
            if (!attr.hasAssociationClass()) {
                attrType = attr.getType();
                attrName = attr.getName();
                if (this.isEntity(attrType)) {
                    attrType = attrType + "DTO";
                }
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    output.write("    " + attrVisibility + " " + attrType + " " + attrName + ";\n");
                    output.write("\n");
                    output.write("");
                    continue;
                }
                output.write("    " + attrVisibility + " " + attrType + "[] " + attrName + ";\n");
                output.write("\n");
                output.write("");
                continue;
            }
            assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            assocClassFQN = attr.getAssociationClass().getQualifiedName();
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                output.write("    " + attrVisibility + " " + assocClassFQN + "DTO " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n");
                output.write("\n");
                output.write("");
                continue;
            }
            output.write("    " + attrVisibility + " " + assocClassFQN + "DTO[] " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n");
            output.write("\n");
            output.write("");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                attrVisibility = attr.getVisibility();
                attrType = attr.getType();
                attrName = attr.getName();
                if (this.isEntity(attrType)) {
                    attrType = attrType + "DTO";
                }
                output.write("    " + attrVisibility + " " + attrType + " " + GeneratorUtil.toLowerCaseFirstLetter((String)attrName) + ";\n");
                output.write("\n");
                output.write("");
            }
        }
        output.write("\n");
        output.write("     protected java.beans.PropertyChangeSupport p;\n");
        output.write("\n");
        output.write("");
        output.write("    /**\n");
        output.write("     * Constructeur de " + clazzName + "DTO par d\u00e9faut.\n");
        output.write("     */\n");
        output.write("    public " + clazzName + "DTO() { p = new java.beans.PropertyChangeSupport(this); }\n");
        output.write("\n");
        output.write("    public void addPropertyChangeListener(PropertyChangeListener listener) {\n");
        output.write("        p.addPropertyChangeListener(listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
        output.write("        p.addPropertyChangeListener(propertyName, listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void removePropertyChangeListener(PropertyChangeListener listener) {\n");
        output.write("        p.removePropertyChangeListener(listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
        output.write("        p.removePropertyChangeListener(propertyName, listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            String attrName2 = attr.getName();
            if (!attr.hasAssociationClass()) {
                attrType = attr.getType();
                if (this.isEntity(attrType)) {
                    attrType = attrType + "DTO";
                }
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    output.write("    public void set" + GeneratorUtil.capitalize((String)attrName2) + "(" + attrType + " value) {\n");
                    output.write("        " + attrType + " oldValue = this." + attrName2 + ";\n");
                    output.write("        this." + attrName2 + " = value;\n");
                    output.write("        p.firePropertyChange(\"" + attrName2 + "\", oldValue, value);\n");
                    output.write("    }\n");
                    output.write("\n");
                    output.write("    public " + attrType + " get" + GeneratorUtil.capitalize((String)attrName2) + "() {\n");
                    output.write("        return " + attrName2 + ";\n");
                    output.write("    }\n");
                    output.write("\n");
                    output.write("");
                    continue;
                }
                output.write("    public void set" + GeneratorUtil.capitalize((String)attrName2) + "(" + attrType + "[] values) {\n");
                output.write("       " + attrType + "[] oldValues = this." + attrName2 + ";\n");
                output.write("        this." + attrName2 + " = values;\n");
                output.write("        p.firePropertyChange(\"" + attrName2 + "\", oldValues, values);\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    public " + attrType + "[] get" + GeneratorUtil.capitalize((String)attrName2) + "() {\n");
                output.write("        return this." + attrName2 + ";\n");
                output.write("    }\n");
                output.write("\n");
                output.write("");
                continue;
            }
            assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            assocClassFQN = attr.getAssociationClass().getQualifiedName();
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                output.write("    public void set" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + assocClassFQN + "DTO association) {\n");
                output.write("        " + assocClassFQN + "DTO oldAssocation= this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n");
                output.write("        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = association;\n");
                output.write("        p.firePropertyChange(\"" + attrName2 + "\", oldAssocation, assocation);\n");
                output.write("    }\n");
                output.write("\n");
                output.write("    public " + assocClassFQN + "DTO get" + GeneratorUtil.capitalize((String)assocAttrName) + "() {\n");
                output.write("        return " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n");
                output.write("    }\n");
                output.write("\n");
                output.write("");
                continue;
            }
            output.write("    public void set" + GeneratorUtil.capitalize((String)assocAttrName) + "(" + assocClassFQN + "DTO[] values) {\n");
            output.write("        " + assocClassFQN + "DTO[] oldValues = this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n");
            output.write("        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = values;\n");
            output.write("        p.firePropertyChange(\"" + attrName2 + "\", oldValues, values);\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    public " + assocClassFQN + "DTO[] get" + GeneratorUtil.capitalize((String)assocAttrName) + "() {\n");
            output.write("        return this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
        output.write("    \n");
        output.write("    @Override\n");
        output.write("    public String toString() {\n");
        output.write("        String result = new ToStringBuilder(this).\n");
        output.write("");
        Iterator i$ = clazz.getAttributes().iterator();
        while (i$.hasNext()) {
            ObjectModelAttribute o;
            ObjectModelAttribute attr;
            attr = o = (ObjectModelAttribute)i$.next();
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
            ObjectModelAttribute reverse2 = attr.getReverseAttribute();
            if ((!isEntity || reverse2 != null && reverse2.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName3 = attr.getName();
            output.write("            append(\"" + attrName3 + "\", this." + attrName3 + ").\n");
            output.write("");
        }
        output.write("         toString();   \n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("} //" + clazzName + "DTO\n");
        output.write("");
    }

    protected void generateNormalGetterAndSetterWithPropertyChangeSupport(Writer output, String attrType, String attrName) throws IOException {
        output.write("    public void set" + GeneratorUtil.capitalize((String)attrName) + "(" + attrType + " value) {\n");
        output.write("        " + attrType + " _oldValue = this." + attrName + ";\n");
        output.write("        this." + attrName + " = value;\n");
        output.write("        p.firePropertyChange(\"" + attrName + "\", _oldValue, value);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public " + attrType + " get" + GeneratorUtil.capitalize((String)attrName) + "() {\n");
        output.write("        return this." + attrName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }
}

