/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class DAOGenerator
extends ObjectModelGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DAO.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype("entity")) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(this.model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        output.write("package " + clazz.getPackageName() + ";\n");
        output.write(" \n");
        output.write("/**\n");
        output.write(" * Cette classe etend le DAOImpl pour parametrer la classe avec le bon type\n");
        output.write(" * Cette classe est marque finale car l'heritage entre les DAO se fait\n");
        output.write(" * sur les DOAImpl, c-a-d que DAOAbstract peut etendre le DAOImpl\n");
        output.write(" */\n");
        output.write("public final class " + clazzName + "DAO extends " + clazzFQN + "DAOImpl<" + clazzName + ">  {\n");
        output.write("\n");
        output.write("");
        output.write("} //" + clazzName + "DAO\n");
        output.write("");
    }
}

