/*
 * #%L
 * Graphical Widget
 * 
 * $Id: StatusBar.java 305 2010-11-18 08:34:19Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-widgets/tags/nuiton-widgets-1.1.1/src/main/java/org/nuiton/widget/StatusBar.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/* *
 * StatusBar.java
 *
 * Created: Jul 29, 2004
 *
 * @author Cédric Pineau <pineau@codelutin.com>
 * @version $Revision: 305 $
 *
 * Last update : $Date: 2010-11-18 09:34:19 +0100 (jeu., 18 nov. 2010) $
 * by : $Author: echatellier $
 */
package org.nuiton.widget;

import static org.nuiton.i18n.I18n._;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

/**
 * TODO: renomer cette statusBar en autre chose, car son role est d'afficher des
 * messages par exemple StatusMessageBar ou StatusMessagePanel, ...
 * 
 * @deprecated since 1.0.0-rc-3-SNAPSHOT, will be remove in 1.1 prefer use the jaxx version in jaxx-runtime-swing-widget module
 * 
 * The new classe is renamed jaxx.runtime.swing.StatusMessagePanel
 */
@Deprecated
public class StatusBar extends JPanel implements ActionListener {

    /** serialVersionUID */
    private static final long serialVersionUID = 5726270382079837021L;

    // To ensure status bar constant height, no matter what font are in use...
    /** DOCUMENTME Description of the Field */
    protected final static String EMPTY_STATUS = " ";

    /** element contenant tous les petits status (clock, mem, ...) */
    protected Box box = null;

    /** DOCUMENTME Description of the Field */
    protected Color statusForeground = null;

    /** DOCUMENTME Description of the Field */
    protected JLabel statusLabel = null;

    /** DOCUMENTME Description of the Field */
    protected String statusReferenceContent = null;

    /** DOCUMENTME Description of the Field */
    protected Timer timer = null;

    /**
     * the lock :)
     */
    protected final Object john= new Object();

    /** This is the default constructor */
    public StatusBar() {
        super();
        initialize();
    }
   
    @Override
    public void actionPerformed(ActionEvent evt) {
        fadeStatus();
    }

    /** DOCUMENTME Method */
    public void clearStatus() {
        stopStatusFader();
        getStatusLabel().setText(EMPTY_STATUS);
    }

    /** DOCUMENTME Method */
    protected void fadeStatus() {
        for (int i = 0; i < 8; i++) {
            // synchronized (this) {
            if (!statusReferenceContent.equals(getStatusLabel().getText())) {
                return;
            }
            Color currentForeground = getStatusLabel().getForeground();
            Color newColor = new Color(currentForeground.getRed(),
                    currentForeground.getGreen(), currentForeground.getBlue(),
                    currentForeground.getAlpha() - 25);
            getStatusLabel().setForeground(newColor);
            getStatusLabel().repaint();
            // }
            // TC-2000311 je comprends pas a quoi ca sert, a part frizzer les ui ?
            // si on utilise un Timer, pourquoi utiliser ça ?
            /*try {
                Thread.sleep(200);
            } catch (InterruptedException eee) {
                eee.printStackTrace();
            }*/
        }
    }

    /**
     * This method initializes jScrollPane1
     * 
     * @return javax.swing.JScrollPane
     */
    protected JLabel getStatusLabel() {
        if (statusLabel == null) {
            statusLabel = new JLabel();
            statusLabel.setText(EMPTY_STATUS);
        }
        return statusLabel;
    }

    /** DOCUMENTME Method */
    protected void initialize() {
        initializeUI();
        statusForeground = getStatusLabel().getForeground();
    }

    /** This method initializes this */
    protected void initializeUI() {
        java.awt.GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setBorder(javax.swing.BorderFactory
                .createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        gridBagConstraints3.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints3.weightx = 1.0D;
        gridBagConstraints3.insets = new java.awt.Insets(2, 2, 2, 2);
        this.add(getStatusLabel(), gridBagConstraints3);

        box = new Box(0);
        this.add(box);
        box.add(new MemoryStatus());
        box.add(new Clock());
    }

    /**
     * The main program for the StatusBar class
     * 
     * @param args The command line arguments
     */
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        StatusBar sb = new StatusBar();
        frame.setSize(800, 50);
        frame.getContentPane().add(sb);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        sb.setStatus("StatusBar test");
        frame.setVisible(true);
    }

    /**
     * Sets the status attribute of the StatusBar object
     * 
     * @param status The new status value
     */
    public void setStatus(String status) {
        // public synchronized void setStatus(String status) {
        stopStatusFader();
        getStatusLabel().setText(status);
        startStatusFader();

    }

    /** DOCUMENTME Method */
    protected void startStatusFader() {
        statusReferenceContent = getStatusLabel().getText();

        int millisecondsPerMinute = 5000;
        timer = new Timer(millisecondsPerMinute, this);
        timer.setRepeats(false);
        timer.setInitialDelay((int) ((long) millisecondsPerMinute - System
                .currentTimeMillis()
                % (long) millisecondsPerMinute) + 500);
        timer.start();
    }

    /** DOCUMENTME Method */
    protected void stopStatusFader() {
        if (timer != null) {
            timer.stop();
            getStatusLabel().setForeground(statusForeground);
        }
    }

    /** DOCUMENTME Description of the Class */
    class Clock extends JLabel implements ActionListener {

        private static final long serialVersionUID=1L;
        /** DOCUMENTME Description of the Field */
        private Timer timer;

        /** DOCUMENTME Constructor for the Clock object */
        public Clock() {
            setForeground(Color.BLACK);
            setBackground(Color.WHITE);
        }

        /**
         * DOCUMENTME Method
         * 
         * @param evt DOCUMENTME Description of the Parameter
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            update();
        }

        /** Adds a feature to the Notify attribute of the Clock object */
        @Override
        public void addNotify() {
            super.addNotify();
            update();
            int millisecondsPerMinute = 60000;
            timer = new Timer(millisecondsPerMinute, this);
            timer.setInitialDelay((int) ((long) millisecondsPerMinute - System
                    .currentTimeMillis()
                    % (long) millisecondsPerMinute) + 500);
            timer.start();
        }

        /**
         * Gets the time attribute of the Clock object
         * 
         * @return The time value
         */
        private String getTime() {
            return DateFormat.getTimeInstance(3).format(new Date());
        }

        @Override
        public void removeNotify() {
            timer.stop();
            super.removeNotify();
        }

        /** DOCUMENTME Method */
        private void update() {
            setText(getTime());
        }
    }

    /** DOCUMENTME Description of the Class */
    class MemoryStatus extends JComponent implements ActionListener {

        private static final long serialVersionUID=1L;

        /** DOCUMENTME Description of the Field */
        private LineMetrics lm;

        /** DOCUMENTME Description of the Field */
        private final static String memoryTestStr = "99999/99999Mb";
        /** DOCUMENTME Description of the Field */
        private Color progressBackground;
        /** DOCUMENTME Description of the Field */
        private Color progressForeground;
        /** DOCUMENTME Description of the Field */
        private Timer timer;

        /** DOCUMENTME Constructor for the MemoryStatus object */
        public MemoryStatus() {
            Font font = (new JLabel()).getFont();
            setFont(font);
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = font.getStringBounds("99999/99999Mb", frc);
            Dimension dim = new Dimension((int) bounds.getWidth(), (int) bounds
                    .getHeight());
            setPreferredSize(dim);
            setMaximumSize(dim);
            lm = font.getLineMetrics(memoryTestStr, frc);
            setForeground(Color.BLACK);
            setBackground(Color.WHITE);
            progressForeground = Color.decode("#cccccc");
            progressBackground = Color.decode("#666699a");
        }

        /**
         * DOCUMENTME Method
         * 
         * @param evt DOCUMENTME Description of the Parameter
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            repaint();
        }

        /** Adds a feature to the Notify attribute of the MemoryStatus object */
        @Override
        public void addNotify() {
            super.addNotify();
            timer = new Timer(2000, this);
            timer.start();
        }

        /**
         * DOCUMENTME Method
         * 
         * @param g DOCUMENTME Description of the Parameter
         */
        @Override
        public void paintComponent(Graphics g) {
            Insets insets = new Insets(0, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int) (runtime.freeMemory() / 1024L);
            int totalMemory = (int) (runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            int width = getWidth() - insets.left - insets.right;
            int height = getHeight() - insets.top - insets.bottom - 1;
            float fraction = (float) usedMemory / (float) totalMemory;
            g.setColor(progressBackground);
            g.fillRect(insets.left, insets.top,
                    (int) ((float) width * fraction), height);
            // No i18n string was :
            // String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
            String str = _("nuitonwidgets.message.statusbar.memory", usedMemory / 1024, totalMemory / 1024);
            FontRenderContext frc = new FontRenderContext(null, false, false);
            Rectangle2D bounds = g.getFont().getStringBounds(str, frc);
            Graphics g2 = g.create();
            g2.setClip(insets.left, insets.top,
                    (int) ((float) width * fraction), height);
            g2.setColor(progressForeground);
            g2.drawString(str, insets.left
                    + (int) ((double) width - bounds.getWidth()) / 2,
                    (int) ((float) insets.top + lm.getAscent()));
            g2.dispose();
            g2 = g.create();
            g2.setClip(insets.left + (int) ((float) width * fraction),
                    insets.top, getWidth() - insets.left
                            - (int) ((float) width * fraction), height);
            g2.setColor(getForeground());
            g2.drawString(str, insets.left
                    + (int) ((double) width - bounds.getWidth()) / 2,
                    (int) ((float) insets.top + lm.getAscent()));
            g2.dispose();
        }

        /** DOCUMENTME Method */
        @Override
        public void removeNotify() {
            timer.stop();
            super.removeNotify();
        }
    }

}
