/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.ui;

import com.google.common.io.Files;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.ui.JRSTCommandModel;
import org.nuiton.jrst.ui.JRSTView;
import org.nuiton.jrst.ui.XslPanel;

public class JRSTViewHandler {
    protected static Log log = LogFactory.getLog(JRSTViewHandler.class);
    protected JRSTView jrstView;

    public JRSTViewHandler(JRSTView jrstView) {
        this.jrstView = jrstView;
    }

    public void init() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrstView.getXslRadio());
        group.add(this.jrstView.getFormat());
        this.addXslLocation();
    }

    public int askEcraser() {
        return JOptionPane.showConfirmDialog(this.jrstView, I18n.t((String)"overwriteGraph?", (Object[])new Object[0]));
    }

    public String[] getFormats() {
        String[] formats = "xml|xhtml|docbook|html|htmlInnerBody|xdoc|fo|pdf".split("\\|");
        return formats;
    }

    public void cancel() {
        System.exit(0);
    }

    public void addXslLocation() {
        JAXXInitialContext context = new JAXXInitialContext();
        context.add((Object)this.jrstView);
        JRSTCommandModel model = this.jrstView.getModel();
        context.add((Object)model);
        XslPanel xslPanel = new XslPanel((JAXXContext)context);
        xslPanel.setModel(model);
        xslPanel.setModel(model);
        int panelNumber = model.getPanelNumber();
        xslPanel.setPanelNumber(panelNumber);
        JPanel xslListPanel = this.jrstView.getXslListPanel();
        xslListPanel.add((Component)((Object)xslPanel));
        this.jrstView.pack();
    }

    public void convert() {
        if (this.jrstView.getOpenLocation() == null) {
            this.jrstView.getErrorLbl().setText(I18n.t((String)"openEmpty?", (Object[])new Object[0]));
            this.jrstView.getErrorLbl().setForeground(Color.RED);
            this.jrstView.pack();
        } else {
            this.launchJRST();
            this.jrstView.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchJRST() {
        JRSTCommandModel model = this.jrstView.getModel();
        File fileIn = model.getOpenFile();
        if (fileIn != null) {
            int choix;
            String xslListOrFormat = model.isFormatEnabled() != false ? model.getSelectedFormat() : model.getXsls();
            File outputFile = model.getSaveFile();
            if (outputFile.exists() && (choix = this.jrstView.getHandler().askEcraser()) == 1) {
                return;
            }
            if (model.getSaveFile() == null && outputFile.isFile()) {
                String outputPath = fileIn.getAbsolutePath();
                String ext = Files.getFileExtension((String)outputPath);
                outputPath = ext.isEmpty() ? outputPath + "." + xslListOrFormat : outputPath.replace("." + ext, "." + xslListOrFormat);
                outputFile = new File(outputPath);
            }
            try {
                JRST.generate(xslListOrFormat, fileIn, outputFile, JRST.Overwrite.ALLTIME, model.isSimpleMode());
            }
            catch (Exception e) {
                log.error((Object)"Can't generate the document with this configuration", (Throwable)e);
            }
            finally {
                this.jrstView.dispose();
            }
        }
    }
}

