/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import org.nuiton.jrst.ui.JRSTView;
import org.nuiton.util.StringUtil;
import org.python.google.common.collect.Lists;

public class JRSTCommandModel {
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected Boolean overwrite = Boolean.FALSE;
    protected Boolean simpleMode = Boolean.FALSE;
    protected Boolean formatEnabled = Boolean.TRUE;
    protected File saveFile;
    protected File openFile;
    protected String selectedFormat;
    protected List<File> xslFileList;
    protected JRSTView jrstView;

    public JRSTCommandModel(JRSTView jrstView) {
        this.jrstView = jrstView;
        this.xslFileList = Lists.newArrayList();
        this.selectedFormat = "xml";
    }

    public Boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(Boolean overwrite) {
        Boolean oldValue = this.isOverwrite();
        this.overwrite = overwrite;
        this.firePropertyChange("overwrite", oldValue, overwrite);
    }

    public Boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(Boolean simpleMode) {
        Boolean oldValue = this.isSimpleMode();
        this.simpleMode = simpleMode;
        this.firePropertyChange("simpleMode", oldValue, simpleMode);
    }

    public Boolean isFormatEnabled() {
        return this.formatEnabled;
    }

    public void setFormatEnabled(Boolean formatEnabled) {
        Boolean oldValue = this.isFormatEnabled();
        this.formatEnabled = formatEnabled;
        this.firePropertyChange("formatEnabled", oldValue, formatEnabled);
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File saveFile) {
        File oldValue = this.getSaveFile();
        this.saveFile = saveFile;
        this.firePropertyChange("saveFile", oldValue, saveFile);
    }

    public File getOpenFile() {
        return this.openFile;
    }

    public void setOpenFile(File openFile) {
        File oldValue = this.getOpenFile();
        this.openFile = openFile;
        this.firePropertyChange("openFile", oldValue, openFile);
    }

    public String getSelectedFormat() {
        return this.selectedFormat;
    }

    public void setSelectedFormat(String selectedFormat) {
        String oldValue = this.getSelectedFormat();
        this.selectedFormat = selectedFormat;
        this.firePropertyChange("selectedFormat", oldValue, selectedFormat);
    }

    public List<File> getXslFileList() {
        return this.xslFileList;
    }

    public void setXslFileList(List<File> xslFileList) {
        List<File> oldValue = this.getXslFileList();
        this.xslFileList = xslFileList;
        this.firePropertyChange("xslFileList", oldValue, xslFileList);
    }

    public String getXsls() {
        String xslAsString = StringUtil.join(this.getXslFileList(), (StringUtil.ToString)new StringUtil.ToString<File>(){

            public String toString(File file) {
                return file.getAbsolutePath();
            }
        }, (String)",", (boolean)true);
        return xslAsString;
    }

    public void addXslFile(File xslFile, int index) {
        List<File> oldValue = this.getXslFileList();
        this.xslFileList.add(index, xslFile);
        this.firePropertyChange("xslFileList", oldValue, this.xslFileList);
    }

    public File getXslFile(Integer number) {
        if (this.xslFileList.size() <= number) {
            return null;
        }
        return this.xslFileList.get(number);
    }

    public int getPanelNumber() {
        return this.xslFileList.size();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }
}

