/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.ui;

import com.google.common.io.Files;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.nuiton.jrst.ui.FileEditor;

public class FileEditorHandler {
    public static final String SEPARATOR_REGEX = "\\s*,\\s*";
    protected FileEditor view;

    public FileEditorHandler(FileEditor view) {
        this.view = view;
    }

    public void openLocation() {
        boolean fileEnabled;
        File startFile = this.view.getSelectedFile();
        String startPath = this.view.getStartPath();
        startFile = startFile == null && startPath != null ? new File(startPath) : new File(System.getProperty("user.home"));
        JFileChooser fc = new JFileChooser(startFile);
        fc.setDialogTitle(this.view.getTitle());
        fc.setAcceptAllFileFilterUsed(this.view.getAcceptAllFileFilterUsed());
        boolean directoryEnabled = this.view.isDirectoryEnabled();
        if (directoryEnabled) {
            fc.setFileSelectionMode(1);
        }
        if (fileEnabled = this.view.isFileEnabled().booleanValue()) {
            if (directoryEnabled) {
                fc.setFileSelectionMode(2);
            } else {
                fc.setFileSelectionMode(0);
            }
            String extsAsString = this.view.getExts();
            if (extsAsString != null) {
                String[] exts = extsAsString.split(SEPARATOR_REGEX);
                String extsDescription = this.view.getExtsDescription();
                String[] descs = new String[]{};
                if (extsDescription != null) {
                    descs = extsDescription.split(SEPARATOR_REGEX);
                }
                for (int i = 0; i < exts.length; ++i) {
                    String ext;
                    String desc = ext = exts[i];
                    if (descs.length > i) {
                        desc = descs[i];
                    }
                    fc.addChoosableFileFilter(new ExtentionFileFiler(ext, desc));
                }
            }
        }
        if (!directoryEnabled && !fileEnabled) {
            throw new IllegalArgumentException("You must enable at least file or directory to open dialog");
        }
        int returnVal = fc.showOpenDialog(this.view);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.view.setSelectedFile(file);
        }
    }

    public static class ExtentionFileFiler
    extends FileFilter {
        protected String ext;
        protected String desciption;

        public ExtentionFileFiler(String ext, String desciption) {
            this.ext = ext;
            this.desciption = desciption;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String fileExtension = Files.getFileExtension((String)file.getName());
            return this.ext.equals(fileExtension);
        }

        @Override
        public String getDescription() {
            return this.desciption;
        }
    }
}

