/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.legacy.directive;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.nuiton.jrst.JRSTDirective;

public class ImageDirective
implements JRSTDirective {
    protected static final String SCALE = "scale";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";

    @Override
    public Node parse(Element e) {
        String[] lines;
        Element result = DocumentHelper.createElement((String)"image");
        if (e.getParent() != null && "substitution_definition".equals(e.getParent().getName())) {
            String ref = e.getParent().attributeValue("name");
            result.addAttribute("alt", ref);
        }
        result.addAttribute("uri", e.attributeValue("value"));
        Pattern arg = Pattern.compile(":([^:]+):\\s*(.*)");
        for (String l : lines = e.getText().split("\n")) {
            Matcher matcher = arg.matcher(l.trim());
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (SCALE.equalsIgnoreCase(name)) {
                if (!result.asXML().matches(".*width=\".*\".*")) {
                    result.addAttribute(WIDTH, value + (value.matches(".*%") ? "" : "%"));
                }
                if (!result.asXML().matches(".*height=\".*\".*")) {
                    result.addAttribute(HEIGHT, value + (value.matches(".*%") ? "" : "%"));
                }
            }
            result.addAttribute(name, value);
        }
        return result;
    }
}

