/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.legacy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.jrst.JRSTDirective;
import org.nuiton.jrst.legacy.JRSTLexer;
import org.nuiton.jrst.legacy.ReStructuredText;
import org.nuiton.jrst.legacy.directive.ContentDirective;
import org.nuiton.jrst.legacy.directive.DateDirective;
import org.nuiton.jrst.legacy.directive.ImageDirective;
import org.nuiton.jrst.legacy.directive.SectnumDirective;
import org.nuiton.util.StringUtil;

public class JRSTReader {
    private static Log log = LogFactory.getLog(JRSTReader.class);
    protected static final String ANONYMOUS = "anonymous";
    protected static final String AUTO = "auto";
    protected static final String AUTONUM = "autoNum";
    protected static final String AUTONUMLABEL = "autoNumLabel";
    protected static final String AUTOSYMBOL = "autoSymbol";
    protected static final String ATTR_REFID = "refid";
    protected static final String ATTR_INLINE = "inline";
    protected static final String ATTR_IDS = "ids";
    protected static final String BACKREFS = "backrefs";
    protected static final String BULLET = "bullet";
    protected static final String CLASS = "class";
    protected static final String CONTENTS = "contents";
    protected static final String DELIMITER = "delimiter";
    protected static final String DELIMITEREXISTE = "delimiterExiste";
    protected static final String ENUMTYPE = "enumtype";
    protected static final String FOOTNOTES = "footnotes";
    protected static final String ID = "id";
    protected static final String INCLUDE = "include";
    protected static final String LEVEL = "level";
    protected static final String NAME = "name";
    protected static final String NAMES = "names";
    protected static final String NUM = "num";
    protected static final String REFURI = "refuri";
    protected static final String PREFIX = "prefix";
    protected static final String REMOVE = "remove";
    protected static final String START = "start";
    protected static final String SECTNUM = "sectnum";
    protected static final String SUBEXISTE = "subExiste";
    protected static final String SUFFIX = "suffix";
    protected static final String TRUE = "true";
    protected static final String TYPE = "type";
    protected static final String TARGETANONYMOUS = "targetAnonymous";
    protected static final String VALUE = "value";
    protected boolean ERROR_MISSING_ITEM;
    protected static int MAX_SECTION_DEPTH = -1000;
    protected static Map<String, JRSTDirective> defaultDirectives = new HashMap<String, JRSTDirective>();
    protected Map<String, JRSTDirective> directives = new HashMap<String, JRSTDirective>();
    private boolean sectnum;
    private Element footer;
    private int idMax;
    private int symbolMax;
    private int symbolMaxRef;
    private LinkedList<Integer> lblFootnotes = new LinkedList();
    private LinkedList<Integer> lblFootnotesRef = new LinkedList();
    private LinkedList<Element> eFootnotes = new LinkedList();
    private LinkedList<Element> eTarget = new LinkedList();
    private LinkedList<Element> eTargetAnonymous = new LinkedList();
    private LinkedList<Element> eTargetAnonymousCopy = new LinkedList();
    private LinkedList<Element> eTitle = new LinkedList();

    public static JRSTDirective getDefaultDirective(String name) {
        return defaultDirectives.get(name);
    }

    public static void addDefaultDirectives(String name, JRSTDirective directive) {
        defaultDirectives.put(name, directive);
    }

    public JRSTDirective getDirective(String name) {
        return this.directives.get(name);
    }

    public void addDirectives(String name, JRSTDirective directive) {
        this.directives.put(name, directive);
    }

    public Document read(Reader reader) throws Exception {
        JRSTLexer lexer = new JRSTLexer(reader);
        try {
            Element root = this.composeDocument(lexer);
            Document result = DocumentHelper.createDocument();
            result.setRootElement(root);
            root.accept((Visitor)new VisitorSupport(){

                public void visit(Element e) {
                    block6: {
                        e.addAttribute(JRSTReader.LEVEL, null);
                        String type = e.attributeValue(JRSTReader.TYPE);
                        if (type != null && type.equals(JRSTReader.CONTENTS)) {
                            JRSTReader.this.composeContents(e);
                            e.addAttribute(JRSTReader.TYPE, null);
                        }
                        if (JRSTReader.TRUE.equalsIgnoreCase(e.attributeValue(JRSTReader.ATTR_INLINE))) {
                            e.addAttribute(JRSTReader.ATTR_INLINE, null);
                            try {
                                JRSTReader.this.inline(e);
                            }
                            catch (DocumentException eee) {
                                if (log.isWarnEnabled()) {
                                    log.warn((Object)("Can't inline text for " + e), (Throwable)eee);
                                }
                            }
                            catch (UnsupportedEncodingException ee) {
                                if (!log.isWarnEnabled()) break block6;
                                log.warn((Object)("Unsupported encoding " + e), (Throwable)ee);
                            }
                        }
                    }
                }
            });
            return result;
        }
        catch (Exception eee) {
            log.error((Object)I18n.t((String)"JRST parsing error line %d char %s:\n%s", (Object[])new Object[]{lexer.getLineNumber(), lexer.getCharNumber(), lexer.readNotBlanckLine()}));
            throw eee;
        }
    }

    private void composeContents(Element e) {
        Element result = DocumentHelper.createElement((String)"topic");
        String option = e.getText();
        int depth = -1;
        Pattern pattern = Pattern.compile("\\s*\\:depth\\:\\s*\\p{Digit}+");
        Matcher matcher = pattern.matcher(option);
        if (matcher.matches() && (matcher = (pattern = Pattern.compile("\\p{Digit}+")).matcher(matcher.group())).find()) {
            depth = Integer.parseInt(matcher.group());
        }
        int levelInit = 0;
        boolean noTitle = false;
        try {
            levelInit = Integer.parseInt(this.eTitle.getFirst().attributeValue(LEVEL));
        }
        catch (NumberFormatException eee) {
            log.error((Object)("Can't parse level in: " + this.eTitle.getFirst().asXML()), (Throwable)eee);
            return;
        }
        catch (NoSuchElementException eee) {
            noTitle = true;
        }
        LinkedList<Element> title = new LinkedList<Element>();
        for (int i = 0; i < this.eTitle.size(); ++i) {
            ++this.idMax;
            this.eTitle.get(i).addAttribute(ATTR_REFID, ID + this.idMax);
        }
        for (Element el : this.eTitle) {
            int level = Integer.parseInt(el.attributeValue(LEVEL));
            el.addAttribute(LEVEL, "" + (level -= levelInit));
            if (depth == -1) {
                title.add(el);
                continue;
            }
            if (depth <= level) continue;
            title.add(el);
        }
        e.addAttribute(CLASS, CONTENTS);
        String titleValue = e.attributeValue(VALUE);
        e.addAttribute(VALUE, null);
        String value = titleValue.trim().toLowerCase();
        if (value.matches("\\s*")) {
            value = CONTENTS;
            titleValue = "Contents";
        }
        e.addAttribute(ATTR_IDS, value);
        e.addAttribute(NAMES, value);
        result.addElement("title").setText(titleValue);
        if (!noTitle) {
            result.add(this.composeLineContent(title, ""));
        }
        e.setText("");
        e.appendContent((Branch)result);
    }

    private Element composeLineContent(LinkedList<Element> title, String num) {
        Element result = DocumentHelper.createElement((String)"bullet_list");
        if (this.sectnum) {
            result.addAttribute(CLASS, "auto-toc");
        }
        Element item = null;
        int cnt = 0;
        while (!title.isEmpty()) {
            Element e = title.getFirst();
            int level = Integer.parseInt(e.attributeValue(LEVEL));
            LinkedList<Element> child = new LinkedList<Element>();
            if (level <= 0) {
                ++cnt;
                title.removeFirst();
                item = result.addElement("list_item");
                Element para = item.addElement("paragraph");
                Element reference = para.addElement("reference");
                String text = e.getText();
                String id = e.attributeValue(ATTR_REFID);
                reference.addAttribute(ATTR_IDS, id);
                reference.addAttribute(ATTR_REFID, text.replaceAll("\\W+", " ").trim().toLowerCase().replaceAll("\\W+", "-"));
                if (this.sectnum) {
                    Element generated = reference.addElement("generated").addAttribute(CLASS, SECTNUM);
                    generated.setText(num + cnt + "   ");
                    for (int i = 0; i < this.eTitle.size(); ++i) {
                        if (!this.eTitle.get(i).attributeValue(ATTR_REFID).equals(id)) continue;
                        Element generatedTitle = this.eTitle.get(i).addElement("generated");
                        generatedTitle.addAttribute(CLASS, SECTNUM);
                        generatedTitle.setText(num + cnt + "   ");
                    }
                }
                text = text.trim();
                text = text.replaceAll("_", "");
                text = ReStructuredText.REGEX_STRONG.matcher(text).replaceAll("<strong>$1</strong>");
                text = ReStructuredText.REGEX_EMPHASIS.matcher(text).replaceAll("<emphasis>$1</emphasis>");
                try {
                    Element textElement = DocumentHelper.parseText((String)("<TMP>" + text + "</TMP>")).getRootElement();
                    reference.appendContent((Branch)textElement);
                }
                catch (DocumentException eee) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't inline text for " + e), (Throwable)eee);
                }
                continue;
            }
            do {
                e.addAttribute(LEVEL, "" + (level - 1));
                child.add(e);
                title.removeFirst();
                if (title.isEmpty()) continue;
                e = title.getFirst();
                level = Integer.parseInt(e.attributeValue(LEVEL));
            } while (!title.isEmpty() && level > 0);
            String numTmp = "";
            if (this.sectnum) {
                numTmp = num + cnt + ".";
            }
            if (item != null) {
                item.add(this.composeLineContent(child, numTmp));
                continue;
            }
            result.add(this.composeLineContent(child, numTmp));
        }
        return result;
    }

    private Element composeDocument(JRSTLexer lexer) throws Exception {
        String txt;
        LinkedList<Element> listItem;
        Element result = DocumentHelper.createElement((String)"document");
        result.addAttribute(LEVEL, String.valueOf(MAX_SECTION_DEPTH - 1));
        Element item = null;
        this.skipBlankLine(lexer);
        LinkedList<Element> items = lexer.refTarget();
        for (Element e : items) {
            this.eTarget.add(e);
        }
        item = lexer.peekHeader();
        if (this.itemEquals("header", item)) {
            Element decoration = result.addElement("decoration");
            Element header = decoration.addElement("header");
            header.addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
        }
        if (this.itemEquals("footer", item = lexer.peekFooter())) {
            this.footer = DocumentHelper.createElement((String)"decoration");
            Element header = this.footer.addElement("footer");
            header.addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
        }
        if ((listItem = lexer.peekTargetAnonymous()) != null) {
            for (Element e : listItem) {
                Element anonym = DocumentHelper.createElement((String)"target");
                anonym.addAttribute(ANONYMOUS, "1");
                ++this.idMax;
                anonym.addAttribute(ATTR_IDS, ID + this.idMax);
                anonym.addAttribute(REFURI, e.attributeValue(REFURI).trim());
                this.eTargetAnonymous.add(anonym);
                this.eTargetAnonymousCopy.add(anonym);
            }
        }
        if (this.itemEquals(REMOVE, item = lexer.peekRemove())) {
            lexer.remove();
        }
        this.skipBlankLine(lexer);
        List<Element> comments = lexer.peekAllComment();
        this.skipBlankLine(lexer);
        item = lexer.peekTitle();
        if (this.itemEquals("title", item)) {
            lexer.remove();
            Element title = result.addElement("title");
            txt = item.getText();
            result.addAttribute(ATTR_IDS, txt.replaceAll("[(\\W+)_]", " ").toLowerCase().trim().replaceAll("\\s+", "-"));
            result.addAttribute(NAMES, txt.toLowerCase().replaceAll("[(\\W+)_&&[^\\:]]+", " ").trim());
            this.copyLevel(item, title);
            title.addAttribute(ATTR_INLINE, TRUE).setText(txt.trim());
        }
        this.skipBlankLine(lexer);
        item = lexer.peekTitle();
        if (this.itemEquals("title", item)) {
            lexer.remove();
            Element subtitle = result.addElement("subtitle");
            txt = item.getText();
            subtitle.addAttribute(ATTR_IDS, txt.replaceAll("[(\\W+)_]", " ").toLowerCase().trim().replaceAll("\\s+", "-"));
            subtitle.addAttribute(NAMES, txt.toLowerCase().replaceAll("[(\\W+)_]", " ").trim());
            this.copyLevel(item, subtitle);
            DocumentHelper.createElement((String)FOOTNOTES);
            subtitle.addAttribute(ATTR_INLINE, TRUE).setText(txt.trim());
        }
        this.skipBlankLine(lexer);
        item = lexer.peekDocInfo();
        Element documentinfo = null;
        while (this.itemEquals("docinfo", item) || this.itemEquals("field_list", item)) {
            if (documentinfo == null) {
                documentinfo = result.addElement("docinfo");
            }
            this.skipBlankLine(lexer);
            if (this.itemEquals("field_list", item)) {
                Element field = this.composeFieldItemList(lexer);
                documentinfo.add(field);
            } else {
                if ("author".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("author").addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
                } else if ("date".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("date").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("organization".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("organization").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("contact".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("contact").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("address".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("address").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("version".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("version").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("revision".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("revision").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("status".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("status").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("copyright".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    documentinfo.addElement("copyright").addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
                } else if ("authors".equalsIgnoreCase(item.attributeValue(TYPE))) {
                    Element authors = documentinfo.addElement("authors");
                    int t = 0;
                    String line = item.getText();
                    for (int i = 0; i < line.length(); ++i) {
                        if (line.charAt(i) != ';' && line.charAt(i) != ',') continue;
                        authors.addElement("author").addAttribute(ATTR_INLINE, TRUE).setText(line.substring(t, i).trim());
                        t = i + 1;
                    }
                    authors.addElement("author").addAttribute(ATTR_INLINE, TRUE).setText(line.substring(t, line.length()).trim());
                }
                lexer.remove();
            }
            item = lexer.peekDocInfo();
        }
        for (Element comment : comments) {
            result.add(this.composeComment(comment));
        }
        item = lexer.peekTitle();
        while (this.itemNotEquals("title", item) && !lexer.eof()) {
            this.composeBody(lexer, result);
            item = lexer.peekTitle();
        }
        item = lexer.peekTitle();
        while (this.itemEquals("title", item, true, lexer.eof())) {
            Element section = this.composeSection(lexer);
            result.add(section);
            item = lexer.peekTitle();
        }
        if (this.footer != null) {
            result.add(this.footer);
        }
        return result;
    }

    private void skipBlankLine(JRSTLexer lexer) throws IOException, DocumentException {
        Element item = lexer.peekBlankLine();
        while (this.itemEquals("blankLine", item)) {
            lexer.remove();
            item = lexer.peekBlankLine();
        }
    }

    private Element composeBody(JRSTLexer lexer, Element parent) throws Exception {
        Element item = lexer.peekTitleOrBodyElement();
        if (item == null && !lexer.eof()) {
            item = lexer.peekTitleOrBodyElement();
        }
        while (!lexer.eof() && this.itemNotEquals("title", item) && this.isUpperLevel(item, parent)) {
            Element para;
            Element list;
            if (this.itemEquals("blankLine", item)) {
                lexer.remove();
            } else if (this.itemEquals(REMOVE, item)) {
                lexer.remove();
            } else if (this.itemEquals(INCLUDE, item)) {
                lexer.remove();
                list = this.composeInclude(item);
                parent.add(list);
            } else if (this.itemEquals("doctest_block", item)) {
                lexer.remove();
                list = this.composeDoctestBlock(item);
                parent.add(list);
            } else if (this.itemEquals("admonition", item)) {
                lexer.remove();
                list = this.composeAdmonition(item);
                parent.add(list);
            } else if (this.itemEquals("sidebar", item)) {
                lexer.remove();
                list = this.composeSidebar(item);
                parent.add(list);
            } else if (this.itemEquals("topic", item)) {
                lexer.remove();
                list = this.composeTopic(item);
                parent.add(list);
            } else if (this.itemEquals("transition", item)) {
                lexer.remove();
                para = parent.addElement("transition");
                this.copyLevel(item, para);
            } else if (this.itemEquals("paragraph", item)) {
                lexer.remove();
                para = parent.addElement("paragraph");
                this.copyLevel(item, para);
                para.addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
            } else if (this.itemEquals("directive", item)) {
                lexer.remove();
                Node directive = this.composeDirective(item);
                parent.add(directive);
            } else if (this.itemEquals("substitution_definition", item)) {
                lexer.remove();
                Element subst = this.composeSubstitutionDefinition(item);
                parent.add(subst);
            } else if (this.itemEquals("literal_block", item)) {
                lexer.remove();
                para = parent.addElement("literal_block");
                this.copyLevel(item, para);
                para.setText(item.getText());
            } else if (this.itemEquals("table", item)) {
                lexer.remove();
                Element table = this.composeTable(item);
                parent.add(table);
            } else if (this.itemEquals("line_block", item)) {
                lexer.remove();
                list = this.composeLineBlock(lexer, item);
                parent.add(list);
            } else if (this.itemEquals("bullet_list", item)) {
                list = this.composeBulletList(lexer);
                parent.add(list);
            } else if (this.itemEquals("enumerated_list", item)) {
                list = this.composeEnumeratedList(lexer);
                parent.add(list);
            } else if (this.itemEquals("definition_list", item)) {
                list = this.composeDefinitionList(lexer);
                parent.add(list);
            } else if (this.itemEquals("field_list", item)) {
                list = this.composeFieldList(lexer);
                parent.add(list);
            } else if (this.itemEquals("block_quote", item)) {
                lexer.remove();
                list = this.composeBlockQuote(item);
                parent.add(list);
            } else if (this.itemEquals("option_list", item)) {
                list = this.composeOptionList(lexer);
                parent.add(list);
            } else if (this.itemEquals("target", item)) {
                lexer.remove();
                list = this.composeTarget(item);
                if (list != null) {
                    try {
                        parent.add(list);
                    }
                    catch (IllegalAddException illegalAddException) {}
                } else {
                    System.err.println("Unknown target name : \"" + item.attributeValue(ATTR_IDS) + "\"");
                }
            } else if (this.itemEquals(TARGETANONYMOUS, item)) {
                lexer.remove();
                list = this.composeTargetAnonymous(item);
                parent.add(list);
            } else if (this.itemEquals(FOOTNOTES, item)) {
                lexer.remove();
                for (Element l : list = this.composeFootnote(item)) {
                    parent.add(l);
                }
            } else if (this.itemEquals("comment", item)) {
                lexer.remove();
                list = this.composeComment(item);
                parent.add(list);
            } else {
                if (this.ERROR_MISSING_ITEM) {
                    throw new DocumentException("Unknow item type: " + item.getName());
                }
                lexer.remove();
            }
            item = lexer.peekTitleOrBodyElement();
        }
        return parent;
    }

    private Element composeInclude(Element item) throws Exception {
        String option = item.attributeValue("option");
        String path = item.getText();
        Element result = null;
        if (option.equals("literal")) {
            result = DocumentHelper.createElement((String)"literal_block");
            FileReader reader = new FileReader(path);
            BufferedReader bf = new BufferedReader(reader);
            String line = "";
            String lineTmp = bf.readLine();
            while (lineTmp != null) {
                line = line + '\n' + lineTmp;
                lineTmp = bf.readLine();
            }
            result.setText(line);
        } else {
            File fileIn = new File(path);
            URL url = fileIn.toURI().toURL();
            InputStreamReader in = new InputStreamReader(url.openStream());
            Document doc = this.newJRSTReader(in);
            result = doc.getRootElement();
        }
        return result;
    }

    private Element composeComment(Element item) {
        return item;
    }

    private Element composeTargetAnonymous(Element item) {
        Element result = null;
        result = this.eTargetAnonymousCopy.getFirst();
        this.eTargetAnonymousCopy.removeFirst();
        return result;
    }

    private Element composeTarget(Element item) {
        Element result = null;
        for (Element e : this.eTarget) {
            if (!e.attributeValue(ID).equals(item.attributeValue(ID))) continue;
            result = e;
        }
        return result;
    }

    private Element[] composeFootnote(Element item) throws Exception {
        Element[] result = null;
        if (this.itemEquals(FOOTNOTES, item)) {
            List footnotes = item.selectNodes("footnote");
            result = new Element[footnotes.size()];
            int cnt = 0;
            for (Element footnote : footnotes) {
                int i;
                result[cnt] = DocumentHelper.createElement((String)"footnote");
                Element efootnote = DocumentHelper.createElement((String)"footnote");
                int labelMax = 0;
                for (int i2 = 0; i2 < this.lblFootnotes.size(); ++i2) {
                    int lbl = this.lblFootnotes.get(i2);
                    labelMax = Math.max(lbl, labelMax);
                }
                boolean[] labels = new boolean[labelMax];
                for (i = 0; i < labels.length; ++i) {
                    labels[i] = false;
                }
                for (i = 0; i < this.lblFootnotes.size(); ++i) {
                    labels[this.lblFootnotes.get((int)i).intValue() - 1] = true;
                }
                ++this.idMax;
                String name = null;
                String id = "";
                String label = null;
                String type = footnote.attributeValue(TYPE);
                if (type.equals(AUTONUM) || type.equals(AUTONUMLABEL)) {
                    result[cnt].addAttribute(AUTO, "1");
                }
                if (type.equals(AUTOSYMBOL)) {
                    result[cnt].addAttribute(AUTO, "*");
                }
                result[cnt].addAttribute(BACKREFS, ID + this.idMax);
                efootnote.addAttribute(BACKREFS, ID + this.idMax);
                if (type.equals(NUM) || type.equals(AUTONUMLABEL)) {
                    name = footnote.attributeValue(NAME);
                    if (type.equals(AUTONUMLABEL)) {
                        id = name;
                    } else {
                        label = name;
                    }
                }
                if (type.equals(AUTONUM) || type.equals(AUTONUMLABEL)) {
                    boolean done = false;
                    for (int i3 = 0; i3 < labels.length && !done; ++i3) {
                        if (labels[i3]) continue;
                        done = true;
                        label = "" + (i3 + 1);
                    }
                    if (!done) {
                        label = "" + (labels.length + 1);
                    }
                    if (type.equals(AUTONUM)) {
                        name = label;
                    }
                }
                if (type.equals(AUTOSYMBOL)) {
                    int nb = Math.abs(this.symbolMax / 10) + 1;
                    char symbol = "*\u2020\u2021\u00a7\u00b6#\u2660\u2665\u2666\u2663".charAt(this.symbolMax % 10);
                    label = "";
                    for (int j = 0; j < nb; ++j) {
                        label = label + symbol;
                    }
                    ++this.symbolMax;
                }
                result[cnt].addAttribute(ATTR_IDS, "" + id);
                efootnote.addAttribute(ATTR_IDS, "" + id);
                if (!type.equals(AUTOSYMBOL)) {
                    result[cnt].addAttribute(NAME, "" + name);
                    efootnote.addAttribute(NAME, "" + name);
                }
                result[cnt].addElement("label").setText("" + label);
                efootnote.addAttribute("label", "" + label);
                if (!type.equals(AUTOSYMBOL)) {
                    this.lblFootnotes.add(Integer.parseInt(label));
                }
                efootnote.addAttribute(TYPE, type);
                this.eFootnotes.add(efootnote);
                String text = footnote.getText();
                Document doc = this.newJRSTReader(new StringReader(text));
                result[cnt].appendContent((Branch)doc.getRootElement());
                ++cnt;
            }
        }
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].attributeValue(ATTR_IDS).equals("")) continue;
            ++this.idMax;
            result[i].addAttribute(ATTR_IDS, ID + this.idMax);
            this.eFootnotes.get(i).addAttribute(ATTR_IDS, ID + this.idMax);
        }
        return result;
    }

    private Element composeOptionList(JRSTLexer lexer) throws DocumentException, Exception {
        Element item = lexer.peekOption();
        Element result = DocumentHelper.createElement((String)"option_list");
        while (this.itemEquals("option_list", item)) {
            lexer.remove();
            Element optionListItem = result.addElement("option_list_item");
            Element optionGroup = optionListItem.addElement("option_group");
            List option = item.selectNodes("option");
            for (Element e : option) {
                Element eOption = optionGroup.addElement("option");
                eOption.addElement("option_string").setText(e.attributeValue("option_string"));
                if (!e.attributeValue(DELIMITEREXISTE).equals(TRUE)) continue;
                eOption.addElement("option_argument").addAttribute(DELIMITER, e.attributeValue(DELIMITER)).setText(e.attributeValue("option_argument"));
            }
            Element description = optionListItem.addElement("description");
            String text = item.getText();
            Document doc = this.newJRSTReader(new StringReader(text));
            description.appendContent((Branch)doc.getRootElement());
            item = lexer.peekOption();
        }
        return result;
    }

    private Element composeTopic(Element item) throws Exception {
        Element result = null;
        result = DocumentHelper.createElement((String)"topic");
        result.addElement("title").addAttribute(ATTR_INLINE, TRUE).setText(item.attributeValue("title"));
        String text = item.getText();
        Document doc = this.newJRSTReader(new StringReader(text));
        result.appendContent((Branch)doc.getRootElement());
        return result;
    }

    private Element composeSidebar(Element item) throws Exception {
        Element result = null;
        result = DocumentHelper.createElement((String)"sidebar");
        result.addElement("title").addAttribute(ATTR_INLINE, TRUE).setText(item.attributeValue("title"));
        if (item.attributeValue(SUBEXISTE).equals(TRUE)) {
            result.addElement("subtitle").addAttribute(ATTR_INLINE, TRUE).setText(item.attributeValue("subtitle"));
        }
        String text = item.getText();
        Document doc = this.newJRSTReader(new StringReader(text));
        result.appendContent((Branch)doc.getRootElement());
        return result;
    }

    private Element composeLineBlock(JRSTLexer lexer, Element item) throws Exception {
        Element result = null;
        result = DocumentHelper.createElement((String)"line_block");
        List lines = item.selectNodes("line");
        int[] levels = new int[lines.size()];
        int cnt = 0;
        for (Element l : lines) {
            levels[cnt] = Integer.parseInt(l.attributeValue(LEVEL));
            ++cnt;
        }
        cnt = 0;
        boolean[] lineDone = new boolean[lines.size()];
        for (int i = 0; i < lineDone.length; ++i) {
            lineDone[i] = false;
        }
        for (Element l : lines) {
            if (levels[cnt] == 0) {
                result.addElement("line").addAttribute(ATTR_INLINE, TRUE).setText(l.getText());
            } else if (!lineDone[cnt]) {
                Element newItem = DocumentHelper.createElement((String)"line_block");
                Boolean done = false;
                for (int i = cnt; i < lines.size() && !done.booleanValue(); ++i) {
                    if (levels[i] > 0) {
                        Element eLine = newItem.addElement("line");
                        eLine.addAttribute(LEVEL, "" + (levels[i] - 1));
                        eLine.setText(((Element)lines.get(i)).getText());
                        lineDone[i] = true;
                        continue;
                    }
                    done = true;
                }
                Element eLineBlock = result.addElement("line_block");
                eLineBlock.appendContent((Branch)this.composeLineBlock(lexer, newItem));
            }
            ++cnt;
        }
        return result;
    }

    private Element composeDoctestBlock(Element item) {
        return item;
    }

    private Element composeBlockQuote(Element item) throws Exception {
        Element result = null;
        result = DocumentHelper.createElement((String)"block_quote");
        String text = item.getText();
        Document doc = this.newJRSTReader(new StringReader(text));
        result.appendContent((Branch)doc.getRootElement());
        String sAttribution = item.attributeValue("attribution");
        if (sAttribution != null) {
            Element attribution = result.addElement("attribution");
            attribution.setText(sAttribution);
            attribution.addAttribute(ATTR_INLINE, TRUE);
        }
        return result;
    }

    private Element composeAdmonition(Element item) throws Exception {
        Element result = null;
        if (item.attributeValue(TYPE).equalsIgnoreCase("admonition")) {
            result = DocumentHelper.createElement((String)"admonition");
            String title = item.attributeValue("title");
            String admonitionClass = "admonition_" + title;
            admonitionClass = admonitionClass.toLowerCase().replaceAll("\\p{Punct}", "");
            admonitionClass = admonitionClass.replace(' ', '-');
            admonitionClass = admonitionClass.replace('\n', '-');
            result.addAttribute(CLASS, admonitionClass);
            result.addElement("title").addAttribute(ATTR_INLINE, TRUE).setText(title.trim());
        } else {
            result = DocumentHelper.createElement((String)item.attributeValue(TYPE).toLowerCase());
        }
        String text = item.getText();
        Document doc = this.newJRSTReader(new StringReader(text));
        result.appendContent((Branch)doc.getRootElement());
        return result;
    }

    private Node composeDirective(Element item) {
        JRSTDirective directive;
        Element result = item;
        String type = item.attributeValue(TYPE);
        if (type.equals(SECTNUM)) {
            this.sectnum = true;
        }
        if ((directive = this.getDirective(type)) == null) {
            directive = JRSTReader.getDefaultDirective(type);
        }
        if (directive != null) {
            result = directive.parse(item);
        } else {
            log.warn((Object)("Unknow directive type '" + type + "' in: " + item));
        }
        return result;
    }

    private Element composeSubstitutionDefinition(Element item) {
        Element result = item;
        Element child = (Element)item.selectSingleNode("*");
        Node newChild = this.composeDirective(child);
        result.remove(child);
        result.add(newChild);
        return result;
    }

    private Element composeTable(Element item) throws Exception {
        Element result = DocumentHelper.createElement((String)"table");
        int tableWidth = Integer.parseInt(item.attributeValue("width"));
        TreeSet<Integer> beginCellList = new TreeSet<Integer>();
        for (Element cell : item.selectNodes("row/cell")) {
            Integer begin = Integer.valueOf(cell.attributeValue("indexStart"));
            beginCellList.add(begin);
        }
        int[] beginCell = new int[beginCellList.size() + 1];
        int[] lengthCell = new int[beginCellList.size()];
        int cellNumber = 0;
        Iterator iterator = beginCellList.iterator();
        while (iterator.hasNext()) {
            int b;
            beginCell[cellNumber] = b = ((Integer)iterator.next()).intValue();
            if (cellNumber > 0) {
                lengthCell[cellNumber - 1] = beginCell[cellNumber] - beginCell[cellNumber - 1];
            }
            ++cellNumber;
        }
        beginCell[cellNumber] = tableWidth;
        lengthCell[cellNumber - 1] = beginCell[cellNumber] - beginCell[cellNumber - 1];
        Element tgroup = result.addElement("tgroup").addAttribute("cols", String.valueOf(cellNumber));
        for (int width : lengthCell) {
            tgroup.addElement("colspec").addAttribute("colwidth", String.valueOf(width));
        }
        Element rowList = null;
        rowList = TRUE.equals(item.attributeValue("header")) ? tgroup.addElement("thead") : tgroup.addElement("tbody");
        List rows = item.selectNodes("row");
        for (int r = 0; r < rows.size(); ++r) {
            Element row = rowList.addElement("row");
            List cells = ((Element)rows.get(r)).selectNodes("cell");
            for (int c = 0; c < cells.size(); ++c) {
                Element cell = (Element)cells.get(c);
                if (TRUE.equals(cell.attributeValue("used"))) continue;
                Element entry = row.addElement("entry");
                String text = "";
                int morerows = -1;
                Element tmpCell = null;
                String cellStart = cell.attributeValue("indexStart");
                do {
                    tmpCell = (Element)((Element)rows.get(r + ++morerows)).selectSingleNode("cell[@indexStart=" + cellStart + "]");
                    text = text + tmpCell.getText();
                    tmpCell.addAttribute("used", TRUE);
                } while (!TRUE.equals(tmpCell.attributeValue("end")));
                if (morerows > 0) {
                    entry.addAttribute("morerows", String.valueOf(morerows));
                }
                int morecols = 0;
                tmpCell = (Element)cells.get(c + morecols);
                int cellEnd = Integer.parseInt(tmpCell.attributeValue("indexEnd"));
                while (cellEnd + 1 != beginCell[c + morecols + 1]) {
                    ++morecols;
                }
                if (morecols > 0) {
                    entry.addAttribute("morecols", String.valueOf(morecols));
                }
                Document doc = this.newJRSTReader(new StringReader(text));
                entry.appendContent((Branch)doc.getRootElement());
            }
            if (!TRUE.equals(((Element)rows.get(r)).attributeValue("endHeader"))) continue;
            rowList = tgroup.addElement("tbody");
        }
        return result;
    }

    private Element composeBulletList(JRSTLexer lexer) throws Exception {
        Element item = lexer.peekBulletList();
        Element result = DocumentHelper.createElement((String)"bullet_list");
        this.copyLevel(item, result);
        result.addAttribute(BULLET, item.attributeValue(BULLET));
        while (this.itemEquals("bullet_list", item) && this.isSameLevel(item, result) && this.hasSameAttribute(item, result, BULLET)) {
            lexer.remove();
            Element bullet = result.addElement("list_item");
            this.copyLevel(item, bullet);
            bullet.addElement("paragraph").addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
            this.composeBody(lexer, bullet);
            item = lexer.peekBulletList();
        }
        return result;
    }

    private Element composeEnumeratedList(JRSTLexer lexer) throws Exception {
        Element item = lexer.peekEnumeratedList();
        Element result = DocumentHelper.createElement((String)"enumerated_list");
        this.copyLevel(item, result);
        String enumType = item.attributeValue(ENUMTYPE);
        if (!enumType.equals("arabic")) {
            result.addAttribute(START, item.attributeValue(START));
        }
        result.addAttribute(PREFIX, item.attributeValue(PREFIX));
        result.addAttribute(SUFFIX, item.attributeValue(SUFFIX));
        result.addAttribute(ENUMTYPE, enumType);
        while (this.itemEquals("enumerated_list", item) && this.isSameLevel(item, result) && this.hasSameAttribute(item, result, PREFIX, SUFFIX) && (AUTO.equals(item.attributeValue(ENUMTYPE)) || this.hasSameAttribute(item, result, ENUMTYPE))) {
            lexer.remove();
            Element e = result.addElement("list_item");
            this.copyLevel(item, e);
            e.addElement("paragraph").addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
            this.composeBody(lexer, e);
            item = lexer.peekEnumeratedList();
        }
        return result;
    }

    private Element composeDefinitionList(JRSTLexer lexer) throws Exception {
        Element item = lexer.peekBodyElement();
        Element result = DocumentHelper.createElement((String)"definition_list");
        this.copyLevel(item, result);
        while (this.itemEquals("definition_list", item) && this.isSameLevel(item, result)) {
            String[] classifiers;
            lexer.remove();
            Element def = result.addElement("definition_list_item");
            this.copyLevel(item, def);
            Element term = def.addElement("term");
            this.copyLevel(item, term);
            term.addAttribute(ATTR_INLINE, TRUE).setText(item.attributeValue("term"));
            for (String classifierText : classifiers = StringUtil.split((String)item.attributeValue("classifiers"), (String)" : ")) {
                Element classifier = def.addElement("classifier");
                this.copyLevel(item, classifier);
                classifier.addAttribute(ATTR_INLINE, TRUE).setText(classifierText);
            }
            Element definition = def.addElement("definition");
            definition.addElement("paragraph").addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
            this.copyLevel(item, definition);
            this.composeBody(lexer, definition);
            item = lexer.peekBodyElement();
        }
        return result;
    }

    private Element composeFieldList(JRSTLexer lexer) throws Exception {
        Element item = lexer.peekBodyElement();
        Element result = DocumentHelper.createElement((String)"field_list");
        this.copyLevel(item, result);
        while (this.itemEquals("field_list", item) && this.isSameLevel(item, result)) {
            Element field = this.composeFieldItemList(lexer);
            result.add(field);
            item = lexer.peekBodyElement();
        }
        return result;
    }

    private Element composeFieldItemList(JRSTLexer lexer) throws Exception {
        Element item = lexer.peekFieldList();
        if (this.itemEquals("field_list", item)) {
            lexer.remove();
            Element field = DocumentHelper.createElement((String)"field");
            this.copyLevel(item, field);
            Element fieldName = field.addElement("field_name");
            this.copyLevel(item, fieldName);
            fieldName.addAttribute(ATTR_INLINE, TRUE).setText(item.attributeValue(NAME));
            Element fieldBody = field.addElement("field_body");
            fieldBody.addElement("paragraph").addAttribute(ATTR_INLINE, TRUE).setText(item.getText());
            this.copyLevel(item, fieldBody);
            this.composeBody(lexer, fieldBody);
            return field;
        }
        throw new DocumentException("Waiting for field_list and found " + item.getName());
    }

    private Element composeSection(JRSTLexer lexer) throws Exception {
        Element result = DocumentHelper.createElement((String)"section");
        Element firstTitle = null;
        Element item = null;
        item = lexer.peekTitle();
        if (this.itemEquals("title", item, true, lexer.eof())) {
            lexer.remove();
            firstTitle = item;
            Element title = result.addElement("title");
            this.copyLevel(item, result);
            this.copyLevel(item, title);
            title.addAttribute(ATTR_INLINE, TRUE).setText(item.getText().trim());
            result.addAttribute(ATTR_IDS, item.getText().replaceAll("\\W+", " ").trim().toLowerCase().replaceAll("\\W+", "-"));
            result.addAttribute(NAME, item.getText().toLowerCase().trim());
            this.eTitle.add(title);
        }
        item = lexer.peekTitle();
        while (this.itemNotEquals("title", item) && !lexer.eof()) {
            this.composeBody(lexer, result);
            item = lexer.peekTitle();
        }
        item = lexer.peekTitle();
        while (this.itemEquals("title", item) && this.isUpperLevel(item, firstTitle)) {
            Element section = this.composeSection(lexer);
            result.add(section);
            item = lexer.peekTitle();
        }
        return result;
    }

    private boolean isUpperLevel(Element subSection, Element section) throws DocumentException {
        int sectionLevel;
        int subSectionLevel = Integer.parseInt(subSection.attributeValue(LEVEL));
        boolean result = subSectionLevel > (sectionLevel = Integer.parseInt(section.attributeValue(LEVEL)));
        return result;
    }

    private boolean isSameLevel(Element subSection, Element section) throws DocumentException {
        int sectionLevel;
        int subSectionLevel = Integer.parseInt(subSection.attributeValue(LEVEL));
        boolean result = subSectionLevel == (sectionLevel = Integer.parseInt(section.attributeValue(LEVEL)));
        return result;
    }

    private boolean hasSameAttribute(Element e1, Element e2, String ... attnames) {
        boolean result = true;
        for (String attname : attnames) {
            String a2;
            String a1 = e1.attributeValue(attname);
            if (ObjectUtils.equals((Object)a1, (Object)(a2 = e2.attributeValue(attname)))) continue;
            result = false;
            break;
        }
        return result;
    }

    private void copyLevel(Element from, Element to) throws DocumentException {
        String level = from.attributeValue(LEVEL);
        if (level == null) {
            throw new DocumentException("Element without level: " + from);
        }
        to.addAttribute(LEVEL, level);
    }

    private boolean itemEquals(String name, Element e) throws DocumentException {
        boolean result = this.itemEquals(name, e, false, false);
        return result;
    }

    private boolean itemEquals(String name, Element e, boolean throwError, boolean eof) throws DocumentException {
        boolean result;
        boolean bl = result = e != null && name.equals(e.getName());
        if (this.ERROR_MISSING_ITEM && !result && throwError && !eof) {
            throw new DocumentException("Malformed document waiting " + name + " and found " + (e != null ? e.getName() : "null"));
        }
        return result;
    }

    private boolean itemNotEquals(String name, Element e) {
        boolean result = e == null || !name.equals(e.getName());
        return result;
    }

    private Document newJRSTReader(Reader r) throws Exception {
        JRSTReader reader = new JRSTReader();
        reader.setVariable(this.idMax, this.symbolMax, this.symbolMaxRef, this.lblFootnotes, this.lblFootnotesRef, this.eFootnotes, this.eTarget, this.eTargetAnonymous, this.eTargetAnonymousCopy);
        return reader.read(r);
    }

    public void setVariable(int idMax, int symbolMax, int symbolMaxRef, LinkedList<Integer> lblFootnotes, LinkedList<Integer> lblFootnotesRef, LinkedList<Element> eFootnotes, LinkedList<Element> eTarget, LinkedList<Element> eTargetAnonymous, LinkedList<Element> eTargetAnonymousCopy) {
        this.idMax = idMax;
        this.symbolMax = symbolMax;
        this.symbolMaxRef = symbolMaxRef;
        this.lblFootnotes = lblFootnotes;
        this.lblFootnotesRef = lblFootnotesRef;
        this.eFootnotes = eFootnotes;
        this.eTarget = eTarget;
        this.eTargetAnonymous = eTargetAnonymous;
        this.eTargetAnonymousCopy = eTargetAnonymousCopy;
    }

    private void inline(Element e) throws DocumentException, UnsupportedEncodingException {
        int i;
        Object ref;
        String key;
        int end;
        int start;
        String text = e.getText();
        text = StringEscapeUtils.escapeXml((String)text);
        HashMap<String, String> temporaries = new HashMap<String, String>();
        Matcher matcher = ReStructuredText.REGEX_LITERAL.matcher(text);
        int index = 0;
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            String literal = "<literal>" + matcher.group(1) + "</" + "literal" + ">";
            key = "literal" + index++;
            temporaries.put(key, literal);
            text = text.substring(0, start) + "<tmp>" + key + "</tmp>" + text.substring(end);
            matcher = ReStructuredText.REGEX_LITERAL.matcher(text);
        }
        matcher = ReStructuredText.REGEX_INLINE_REFERENCE.matcher(text);
        index = 0;
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            ref = DocumentHelper.createElement((String)"reference");
            ref.addAttribute(REFURI, StringEscapeUtils.unescapeXml((String)matcher.group(2)));
            ref.setText(StringEscapeUtils.unescapeXml((String)matcher.group(1)));
            key = "inlineReference" + index++;
            temporaries.put(key, ref.asXML());
            text = text.substring(0, start) + "<tmp>" + key + "</tmp>" + text.substring(end);
            matcher = ReStructuredText.REGEX_INLINE_REFERENCE.matcher(text);
        }
        text = ReStructuredText.REGEX_EMAIL.matcher(text).replaceAll("$1<reference refuri='mailto:$2'>$2</reference>$3");
        text = ReStructuredText.REGEX_STRONG.matcher(text).replaceAll("<strong>$1</strong>");
        text = ReStructuredText.REGEX_EMPHASIS.matcher(text).replaceAll("<emphasis>$1</emphasis>");
        text = ReStructuredText.REGEX_REFERENCE.matcher(text).replaceAll("<reference refuri='$1'>$1</reference>$2");
        matcher = ReStructuredText.REGEX_FOOTNOTE_REFERENCE.matcher(text);
        while (matcher.find()) {
            String txtDebut = text.substring(0, matcher.start());
            String txtFin = text.substring(matcher.end() - 1, text.length() - 1);
            Element footnote = DocumentHelper.createElement((String)"footnote_reference");
            String sFootnote = matcher.group();
            boolean done = false;
            for (i = 0; i < sFootnote.length() && !done; ++i) {
                String label;
                if (sFootnote.charAt(i) != ']') continue;
                String id = sFootnote.substring(1, i);
                if (id.equals("*")) {
                    int j;
                    int nb = Math.abs(this.symbolMaxRef / 10) + 1;
                    char symbol = "*\u2020\u2021\u00a7\u00b6#\u2660\u2665\u2666\u2663".charAt(this.symbolMaxRef % 10);
                    String label2 = "";
                    for (j = 0; j < nb; ++j) {
                        label2 = label2 + symbol;
                    }
                    ++this.symbolMaxRef;
                    footnote.addAttribute(AUTO, "*");
                    for (j = 0; j < this.eFootnotes.size(); ++j) {
                        Element eFootnote = this.eFootnotes.get(j);
                        if (!eFootnote.attributeValue("label").equals(label2)) continue;
                        footnote.addAttribute(ATTR_IDS, eFootnote.attributeValue(BACKREFS));
                        footnote.addAttribute(ATTR_REFID, eFootnote.attributeValue(ATTR_IDS));
                    }
                    footnote.setText(label2);
                } else if (id.matches("[1-9]+")) {
                    for (int j = 0; j < this.eFootnotes.size(); ++j) {
                        Element eFootnote = this.eFootnotes.get(j);
                        if (!eFootnote.attributeValue("label").equals(id)) continue;
                        footnote.addAttribute(ATTR_IDS, eFootnote.attributeValue(BACKREFS));
                        footnote.addAttribute(ATTR_REFID, eFootnote.attributeValue(ATTR_IDS));
                    }
                    footnote.setText(id);
                    this.lblFootnotesRef.add(Integer.parseInt(id));
                } else if (id.equals("#")) {
                    int j;
                    int lblMax = 0;
                    for (int j2 = 0; j2 < this.lblFootnotesRef.size(); ++j2) {
                        lblMax = Math.max(lblMax, this.lblFootnotesRef.get(j2));
                    }
                    boolean[] lbls = new boolean[lblMax];
                    for (j = 0; j < lbls.length; ++j) {
                        lbls[j] = false;
                    }
                    for (j = 0; j < this.lblFootnotesRef.size(); ++j) {
                        lbls[this.lblFootnotesRef.get((int)j).intValue() - 1] = true;
                    }
                    boolean valide = false;
                    do {
                        int j3;
                        boolean trouve = false;
                        label = null;
                        for (j3 = 0; j3 < lbls.length && !trouve; ++j3) {
                            if (lbls[j3]) continue;
                            trouve = true;
                            label = "" + (j3 + 1);
                        }
                        if (!trouve) {
                            label = "" + (lbls.length + 1);
                        }
                        footnote.addAttribute(AUTO, "1");
                        for (j3 = 0; j3 < this.eFootnotes.size(); ++j3) {
                            Element eFootnote = this.eFootnotes.get(j3);
                            if (!eFootnote.attributeValue("label").equals(label)) continue;
                            if (!eFootnote.attributeValue(TYPE).equals(AUTONUMLABEL)) {
                                footnote.addAttribute(ATTR_IDS, eFootnote.attributeValue(BACKREFS));
                                footnote.addAttribute(ATTR_REFID, eFootnote.attributeValue(ATTR_IDS));
                                footnote.setText(label);
                                this.lblFootnotesRef.add(Integer.parseInt(label));
                                valide = true;
                                continue;
                            }
                            valide = false;
                            lbls[Integer.parseInt((String)label) - 1] = true;
                        }
                    } while (!valide);
                } else {
                    footnote.addAttribute(AUTO, "1");
                    String name = id.substring(1);
                    boolean trouve = false;
                    for (int j = 0; j < this.eFootnotes.size() && !trouve; ++j) {
                        Element eFootnote = this.eFootnotes.get(j);
                        if (!eFootnote.attributeValue(NAMES).equals(name)) continue;
                        footnote.addAttribute(ATTR_IDS, eFootnote.attributeValue(BACKREFS));
                        footnote.addAttribute(ATTR_REFID, eFootnote.attributeValue(ATTR_IDS));
                        label = eFootnote.attributeValue("label");
                        footnote.setText(label);
                        this.lblFootnotesRef.add(Integer.parseInt(label));
                        trouve = true;
                    }
                    footnote.addAttribute(NAMES, name);
                }
                done = true;
            }
            text = txtDebut + footnote.asXML() + txtFin;
            matcher = ReStructuredText.REGEX_FOOTNOTE_REFERENCE.matcher(text);
        }
        matcher = ReStructuredText.REGEX_ANONYMOUS_HYPERLINK_REFERENCE.matcher(text);
        while (matcher.find()) {
            String txtDebut = text.substring(0, matcher.start());
            String txtFin = text.substring(matcher.end(), text.length());
            ref = text.substring(matcher.start(), matcher.end() - 2);
            ref = ((String)ref).replaceAll("`", "");
            Element anonym = DocumentHelper.createElement((String)"reference");
            anonym.addAttribute(ANONYMOUS, "1");
            anonym.addAttribute(NAME, ((String)ref).trim());
            if (!this.eTargetAnonymous.isEmpty()) {
                Element target = this.eTargetAnonymous.getFirst();
                this.eTargetAnonymous.removeFirst();
                anonym.addAttribute(REFURI, target.attributeValue(REFURI));
            }
            anonym.setText((String)ref);
            text = txtDebut + anonym.asXML() + txtFin;
            matcher = ReStructuredText.REGEX_ANONYMOUS_HYPERLINK_REFERENCE.matcher(text);
        }
        matcher = ReStructuredText.REGEX_HYPERLINK_REFERENCE.matcher(text);
        while (matcher.find()) {
            String txtDebut = text.substring(0, matcher.start());
            String txtFin = text.substring(matcher.end(), text.length());
            ref = text.substring(matcher.start(), matcher.end() - 1);
            ref = StringEscapeUtils.unescapeXml((String)ref);
            ref = ((String)ref).replaceAll("(&apos;|_)", "");
            ref = ((String)ref).replaceAll("`", "");
            Element hyper = DocumentHelper.createElement((String)"reference");
            hyper.addAttribute(NAME, (String)ref);
            boolean trouve = false;
            for (i = 0; i < this.eTarget.size() && !trouve; ++i) {
                Element el = this.eTarget.get(i);
                String refTmp = URLEncoder.encode(((String)ref).replaceAll("\\s", "-").toLowerCase(), "UTF-8");
                if (!el.attributeValue(ID).equalsIgnoreCase(refTmp)) continue;
                hyper.addAttribute(REFURI, el.attributeValue(REFURI));
                trouve = true;
            }
            if (!trouve) {
                hyper.addAttribute(ATTR_REFID, (String)ref);
            }
            hyper.setText((String)ref);
            text = txtDebut + hyper.asXML() + " " + txtFin;
            matcher = ReStructuredText.REGEX_HYPERLINK_REFERENCE.matcher(text);
        }
        matcher = ReStructuredText.REGEX_SUBSTITUTION_REFERENCE.matcher(text);
        int begin = 0;
        while (matcher.find(begin)) {
            String start2 = text.substring(0, matcher.start());
            String end2 = text.substring(matcher.end());
            String ref2 = matcher.group(1);
            Node subst = e.selectSingleNode("//substitution_definition[@name='" + ref2 + "']/child::node()");
            text = subst == null ? start2 + "|" + ref2 + "|" : start2 + subst.asXML();
            begin = text.length();
            text = text + end2;
            matcher = ReStructuredText.REGEX_SUBSTITUTION_REFERENCE.matcher(text);
        }
        Pattern p = Pattern.compile("<tmp>([^<>]+)</tmp>");
        matcher = p.matcher(text);
        while (matcher.find()) {
            String start3 = text.substring(0, matcher.start());
            String end3 = text.substring(matcher.end());
            String tempKey = matcher.group(1);
            text = start3 + (String)temporaries.get(tempKey) + end3;
            matcher = p.matcher(text);
        }
        String resultElementText = text.trim();
        Element result = DocumentHelper.parseText((String)("<TMP>" + resultElementText + "</TMP>")).getRootElement();
        e.setText("");
        e.appendContent((Branch)result);
    }

    static {
        defaultDirectives.put("image", new ImageDirective());
        defaultDirectives.put("date", new DateDirective());
        defaultDirectives.put("time", new DateDirective());
        defaultDirectives.put(CONTENTS, new ContentDirective());
        defaultDirectives.put(SECTNUM, new SectnumDirective());
    }
}

