/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.legacy;

import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.nuiton.jrst.legacy.AdvancedReader;
import org.nuiton.jrst.legacy.JRSTReader;

public class JRSTLexer {
    private static Log log = LogFactory.getLog(JRSTLexer.class);
    public static final String BULLET_CHAR = "*+-";
    public static final String TITLE_CHAR = "-=-~'`^+:!\"#$%&*,./;|?@\\_[\\]{}<>()";
    public static final String DOCINFO_ITEM = "author|authors|organization|address|contact|version|revision|status|date|copyright";
    public static final String ADMONITION_PATTERN = "admonition|attention|caution|danger|error|hint|important|note|tip|warning";
    public static final String TITLE = "title";
    public static final String DOCINFO = "docinfo";
    public static final String DECORATION = "decoration";
    public static final String HEADER = "header";
    public static final String FOOTER = "footer";
    public static final String TRANSITION = "transition";
    public static final String SIDEBAR = "sidebar";
    public static final String TOPIC = "topic";
    public static final String LITERAL_BLOCK = "literal_block";
    public static final String PARAGRAPH = "paragraph";
    public static final String BLANK_LINE = "blankLine";
    public static final String COMMENT = "comment";
    public static final String SUBSTITUTION_DEFINITION = "substitution_definition";
    public static final String BULLET_LIST = "bullet_list";
    public static final String FIELD_LIST = "field_list";
    public static final String DEFINITION_LIST = "definition_list";
    public static final String ENUMERATED_LIST = "enumerated_list";
    public static final String OPTION_LIST = "option_list";
    public static final String LINE_BLOCK = "line_block";
    public static final String LINE = "line";
    public static final String ATTRIBUTION = "attribution";
    public static final String DOCTEST_BLOCK = "doctest_block";
    public static final String ADMONITION = "admonition";
    public static final String TARGET = "target";
    public static final String FOOTNOTE = "footnote";
    public static final String FOOTNOTES = "footnotes";
    public static final String LEVEL = "level";
    public static final String TARGETANONYMOUS = "targetAnonymous";
    public static final String TABLE = "table";
    public static final String ROW = "row";
    public static final String CELL = "cell";
    public static final String TABLE_HEADER = "header";
    public static final String TABLE_WIDTH = "width";
    public static final String ROW_END_HEADER = "endHeader";
    public static final String CELL_INDEX_START = "indexStart";
    public static final String CELL_INDEX_END = "indexEnd";
    public static final String CELL_BEGIN = "begin";
    public static final String CELL_END = "end";
    public static final String REMOVE = "remove";
    public static final String INCLUDE = "include";
    public static final String DIRECTIVE = "directive";
    public static final String DIRECTIVE_TYPE = "type";
    public static final String DIRECTIVE_VALUE = "value";
    public static final String AUTONUM = "autoNum";
    public static final String AUTONUMLABEL = "autoNumLabel";
    public static final String AUTOSYMBOL = "autoSymbol";
    public static final String BULLET = "bullet";
    public static final String CHAR = "char";
    public static final String ID = "id";
    public static final String CLASSIFIERS = "classifiers";
    public static final String DELIMITER = "delimiter";
    public static final String DELIMITEREXISTE = "delimiterExiste";
    public static final String ENUMTYPE = "enumtype";
    public static final String REFURI = "refuri";
    public static final String OPTION = "option";
    public static final String LITERAL = "literal";
    public static final String NAME = "name";
    public static final String NUM = "num";
    public static final String OPTIONARGUMENT = "option_argument";
    public static final String OPTIONSTRING = "option_string";
    public static final String PREFIX = "prefix";
    public static final String START = "start";
    public static final String SUBEXISTE = "subExiste";
    public static final String SUFFIX = "suffix";
    public static final String SUBTITLE = "subtitle";
    public static final String TERM = "term";
    public static final String TITLEATTR = "title";
    public static final String XMLSPACE = "xml:space";
    public static final String TYPE = "type";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private List<String> titleLevels = new ArrayList<String>();
    private AdvancedReader in;
    private int elementLength;

    public JRSTLexer(Reader reader) {
        this.in = new AdvancedReader(reader);
    }

    public boolean eof() throws IOException {
        this.in.mark();
        this.in.skipBlankLines();
        boolean result = this.in.eof();
        this.in.reset();
        return result;
    }

    public void remove() throws IOException {
        this.in.skip(this.elementLength);
    }

    private void beginPeek() throws IOException {
        this.elementLength = 0;
        this.in.mark();
    }

    private void endPeek() throws IOException {
        this.elementLength = this.in.readSinceMark();
        this.in.reset();
    }

    private String[] readBlock(int minLeftMargin) throws IOException {
        String[] result = new String[]{};
        String firstLine = this.in.readLine();
        if (firstLine != null) {
            this.in.unread(firstLine, true);
            int level = this.level(firstLine);
            if (level >= minLeftMargin) {
                result = this.in.readWhile("^\\s{" + level + "}\\S+.*");
            }
        }
        return result;
    }

    private String joinBlock(String[] lines) {
        String result = this.joinBlock(lines, " ", true);
        return result;
    }

    private String joinBlock(String[] lines, String joinSep, boolean trim) {
        String result = "";
        String sep = "";
        for (String line : lines) {
            if (trim) {
                line = line.trim();
            }
            result = result + sep + line;
            sep = joinSep;
        }
        return result;
    }

    public Element peekHeader() throws IOException {
        this.beginPeek();
        Element result = null;
        String[] line = this.in.readAll();
        if (line != null) {
            int i = 0;
            for (String l : line) {
                ++i;
                if (!l.matches("^\\s*.. header:: .*")) continue;
                int level = this.level(l);
                l = l.replaceAll("^\\s*.. header:: ", "");
                result = DocumentHelper.createElement((String)"header").addAttribute(LEVEL, String.valueOf(level));
                result.addAttribute(LINE, "" + i);
                result.setText(l);
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekFooter() throws IOException {
        this.beginPeek();
        Element result = null;
        String[] line = this.in.readAll();
        if (line != null) {
            int i = 0;
            for (String l : line) {
                ++i;
                if (!l.matches("^\\s*.. footer:: .*")) continue;
                int level = this.level(l);
                l = l.replaceAll("^\\s*.. footer:: ", "");
                result = DocumentHelper.createElement((String)FOOTER).addAttribute(LEVEL, String.valueOf(level));
                result.addAttribute(LINE, "" + i);
                result.setText(l);
            }
        }
        this.endPeek();
        return result;
    }

    public LinkedList<Element> peekTargetAnonymous() throws IOException {
        this.beginPeek();
        LinkedList<Element> result = new LinkedList<Element>();
        String[] line = this.in.readAll();
        if (line != null) {
            int i = 0;
            for (String l : line) {
                ++i;
                if (!l.matches("^\\s*__ .+$|^\\s*\\.\\. __\\:.+$")) continue;
                log.debug((Object)l);
                Element resultTmp = DocumentHelper.createElement((String)TARGETANONYMOUS);
                resultTmp.addAttribute(LEVEL, "" + this.level(l));
                Matcher matcher = Pattern.compile("__ |.. __: ").matcher(l);
                if (matcher.find()) {
                    resultTmp.addAttribute(REFURI, l.substring(matcher.end(), l.length()));
                }
                result.add(resultTmp);
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekTitleOrBodyElement() throws IOException {
        Element result = null;
        if (result == null) {
            result = this.peekTitle();
        }
        if (result == null) {
            result = this.peekBodyElement();
        }
        return result;
    }

    public Element peekDocInfo() throws IOException {
        Element result = null;
        if (result == null) {
            result = this.peekDocInfoItem();
        }
        if (result == null) {
            result = this.peekFieldList();
        }
        return result;
    }

    public Element peekBodyElement() throws IOException {
        Element result = null;
        if (result == null) {
            result = this.peekInclude();
        }
        if (result == null) {
            result = this.peekDoctestBlock();
        }
        if (result == null) {
            result = this.peekAdmonition();
        }
        if (result == null) {
            result = this.peekSidebar();
        }
        if (result == null) {
            result = this.peekTopic();
        }
        if (result == null) {
            result = this.peekRemove();
        }
        if (result == null) {
            result = this.peekDirectiveOrReference();
        }
        if (result == null) {
            result = this.peekTransition();
        }
        if (result == null) {
            result = this.peekTable();
        }
        if (result == null) {
            result = this.peekLineBlock();
        }
        if (result == null) {
            result = this.peekBulletList();
        }
        if (result == null) {
            result = this.peekOption();
        }
        if (result == null) {
            result = this.peekEnumeratedList();
        }
        if (result == null) {
            result = this.peekTarget();
        }
        if (result == null) {
            result = this.peekFootnote();
        }
        if (result == null) {
            result = this.peekComment();
        }
        if (result == null) {
            result = this.peekDefinitionList();
        }
        if (result == null) {
            result = this.peekFieldList();
        }
        if (result == null) {
            result = this.peekTargetAnonymousBody();
        }
        if (result == null) {
            result = this.peekLiteralBlock();
        }
        if (result == null) {
            result = this.peekBlockQuote();
        }
        if (result == null) {
            result = this.peekBlankLine();
        }
        if (result == null) {
            result = this.peekPara();
        }
        return result;
    }

    public Element peekRemove() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null) {
            if (line.matches("^\\s*.. header:: .*")) {
                result = DocumentHelper.createElement((String)REMOVE).addAttribute(LEVEL, "" + this.level(line));
            }
            if (line.matches("^\\s*.. footer:: .*")) {
                result = DocumentHelper.createElement((String)REMOVE).addAttribute(LEVEL, "" + this.level(line));
            }
        }
        this.endPeek();
        return result;
    }

    private Element peekInclude() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\s*\\.\\.\\sinclude\\:\\:.+$")) {
            result = DocumentHelper.createElement((String)INCLUDE);
            result.addAttribute(LEVEL, "" + this.level(line));
            String option = line.substring(line.indexOf("::") + 2).trim();
            result.addAttribute(OPTION, "");
            if (option.trim().equalsIgnoreCase(LITERAL)) {
                result.addAttribute(OPTION, LITERAL);
                line = this.in.readLine();
                result.setText(line.trim());
            } else {
                result.setText(option);
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekOption() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^(\\s*((--?)|(//?))\\w+([ =][<a-zA-Z][\\w-><]*)?)\\s*.*$")) {
            int delimiter;
            result = DocumentHelper.createElement((String)OPTION_LIST).addAttribute(LEVEL, "" + this.level(line));
            do {
                Matcher matcher = Pattern.compile("[-/][-/]?.+").matcher(line);
                matcher.find();
                Element option = result.addElement(OPTION);
                String option_stringTmp = matcher.group();
                matcher = Pattern.compile("^[-/][-/]?\\w+").matcher(option_stringTmp);
                matcher.find();
                String option_string = matcher.group();
                option.addAttribute(OPTIONSTRING, option_string);
                boolean done = false;
                delimiter = 46;
                if (option_stringTmp.length() > matcher.end()) {
                    delimiter = option_stringTmp.charAt(matcher.end());
                    option_stringTmp = option_stringTmp.substring(matcher.end(), option_stringTmp.length());
                } else {
                    done = true;
                }
                option.addAttribute(DELIMITEREXISTE, FALSE);
                if (delimiter == 32 && option_stringTmp.charAt(1) == ' ') {
                    done = true;
                }
                String option_argument = null;
                if (!(delimiter != 61 && delimiter != 32 || done)) {
                    option.addAttribute(DELIMITEREXISTE, TRUE);
                    option.addAttribute(DELIMITER, "" + (char)delimiter);
                    matcher = Pattern.compile((char)delimiter + "(([a-zA-Z][\\w-]+)|(<[a-zA-Z][^>]*>))").matcher(option_stringTmp);
                    if (matcher.find()) {
                        option_argument = matcher.group().substring(1, matcher.group().length());
                        option.addAttribute(OPTIONARGUMENT, option_argument);
                        int size = option_argument.length() + 1;
                        if (option_stringTmp.length() < size && option_stringTmp.charAt(size) == ',') {
                            delimiter = 44;
                        } else {
                            done = true;
                        }
                    } else {
                        option_argument = option_stringTmp;
                        option.addAttribute(OPTIONARGUMENT, option_argument);
                        line = this.in.readLine();
                        if (line != null) {
                            result.setText(line.trim());
                        }
                    }
                }
                if (delimiter == 44) {
                    line = line.substring(option_string.length() + 1 + (option_argument == null ? 0 : option_argument.length()));
                }
                if (!done) continue;
                result.setText(option_stringTmp.substring(matcher.end(), option_stringTmp.length()).trim() + " " + this.joinBlock(this.readBlock(1)));
            } while (delimiter == 44);
        }
        this.endPeek();
        return result;
    }

    private Element peekTopic() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\.\\.\\s+(topic)::\\s+(.*)$")) {
            Matcher matcher = Pattern.compile("topic::").matcher(line);
            matcher.find();
            result = DocumentHelper.createElement((String)TOPIC).addAttribute(LEVEL, "" + this.level(line));
            String title = line.substring(matcher.end(), line.length());
            result.addAttribute("title", title);
            line = this.in.readLine();
            if (line.matches("\\s*")) {
                line = this.in.readLine();
            }
            int level = this.level(line);
            String[] lines = null;
            if (level != 0) {
                lines = this.in.readWhile("(^ {" + level + "}.*)|(\\s*)");
                String txt = line;
                for (String txtTmp : lines) {
                    txt = txt + "\n" + txtTmp.trim();
                }
                result.setText(txt);
            }
        }
        this.endPeek();
        return result;
    }

    private Element peekSidebar() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\.\\.\\s*(sidebar)::\\s*(.*)$")) {
            Matcher matcher = Pattern.compile("sidebar::").matcher(line);
            matcher.find();
            result = DocumentHelper.createElement((String)SIDEBAR).addAttribute(LEVEL, "" + this.level(line));
            String title = line.substring(matcher.end(), line.length());
            result.addAttribute("title", title);
            line = this.in.readLine();
            if (line.matches("^\\s+:subtitle:\\s*(.*)$*")) {
                matcher = Pattern.compile(":subtitle:\\s*").matcher(line);
                matcher.find();
                String subTitle = line.substring(matcher.end(), line.length());
                result.addAttribute(SUBEXISTE, TRUE);
                result.addAttribute(SUBTITLE, subTitle);
                line = this.in.readLine();
            } else {
                result.addAttribute(SUBEXISTE, FALSE);
            }
            String txt = this.joinBlock(this.readBlock(this.level(line)));
            result.setText(txt);
        }
        this.endPeek();
        return result;
    }

    private Element peekLineBlock() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("\\|\\s.*")) {
            int i;
            String[] linesTmp = this.readBlock(0);
            String[] lines = new String[linesTmp.length + 1];
            lines[0] = line;
            for (int i2 = 0; i2 < linesTmp.length; ++i2) {
                lines[i2 + 1] = linesTmp[i2];
            }
            int[] levelsTmp = new int[lines.length];
            int levelmin = 999;
            result = DocumentHelper.createElement((String)LINE_BLOCK).addAttribute(LEVEL, "0");
            for (i = 0; i < levelsTmp.length; ++i) {
                lines[i] = lines[i].replaceAll("\\|\\s?", "");
            }
            for (i = 0; i < levelsTmp.length; ++i) {
                levelsTmp[i] = this.level(lines[i]);
            }
            for (int i3 : levelsTmp) {
                levelmin = Math.min(levelmin, i3);
            }
            int cnt = 0;
            String lineAv = "";
            int[] levels = new int[levelsTmp.length];
            for (String l : lines) {
                if (!l.matches("\\s*")) {
                    int level = levelsTmp[cnt] - levelmin;
                    if (level != 0) {
                        if (cnt != 0) {
                            if (!lineAv.matches("\\s*")) {
                                int levelAv = levelsTmp[cnt - 1] - levelmin;
                                if (levelAv < level) {
                                    int levelAp;
                                    levels[cnt] = levels[cnt - 1] + 1;
                                    if (cnt != levels.length && (levelAp = levelsTmp[cnt + 1] - levelmin) < level && levelAv < levelAp) {
                                        int n = cnt;
                                        levels[n] = levels[n] + 1;
                                    }
                                } else {
                                    levels[cnt] = levels[cnt - 1] - 1;
                                }
                            } else {
                                levels[cnt] = 1;
                            }
                        } else {
                            levels[cnt] = 1;
                        }
                    } else {
                        levels[cnt] = 0;
                    }
                } else {
                    levels[cnt] = cnt != 0 ? levels[cnt - 1] : 0;
                }
                ++cnt;
                lineAv = l;
            }
            for (int i4 = 0; i4 < levels.length; ++i4) {
                Element eLine = result.addElement(LINE);
                eLine.addAttribute(LEVEL, "" + levels[i4]);
                eLine.setText(lines[i4].trim());
            }
        }
        this.endPeek();
        return result;
    }

    private Element peekDoctestBlock() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\s*>>>\\s.*")) {
            int level = this.level(line);
            result = DocumentHelper.createElement((String)DOCTEST_BLOCK).addAttribute(LEVEL, String.valueOf(level));
            result.addAttribute(XMLSPACE, "preserve");
            line = line + "\n" + this.joinBlock(this.readBlock(level));
            result.setText(line);
        }
        this.endPeek();
        return result;
    }

    private Element peekBlockQuote() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("\\s.*")) {
            int level = this.level(line);
            String savedLine = line + " " + this.joinBlock(this.readBlock(level));
            line = this.in.readLine();
            if (line != null) {
                level = this.level(line);
                String blockQuote = null;
                if (level != 0) {
                    String[] lines;
                    String txt = line;
                    for (String l : lines = this.in.readWhile("(^ {" + level + "}.*)|(\\s*)")) {
                        if (l.matches("^ {" + level + "}--\\s*.*")) {
                            blockQuote = l;
                            blockQuote = blockQuote.replaceAll("--", "").trim();
                            continue;
                        }
                        txt = txt + "\n" + l;
                    }
                    result = DocumentHelper.createElement((String)"block_quote").addAttribute(LEVEL, String.valueOf(level));
                    if (blockQuote != null) {
                        result.addAttribute(ATTRIBUTION, blockQuote);
                    }
                    result.setText(savedLine + txt);
                }
            }
        }
        this.endPeek();
        return result;
    }

    protected Element peekAdmonition() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null) {
            String lineTest = line.toLowerCase();
            Pattern pAdmonition = Pattern.compile("^\\s*\\.\\.\\s(admonition|attention|caution|danger|error|hint|important|note|tip|warning)::\\s*(.*)$");
            Matcher matcher = pAdmonition.matcher(lineTest);
            if (matcher.matches()) {
                boolean admonition = false;
                matcher = Pattern.compile(ADMONITION_PATTERN).matcher(lineTest);
                matcher.find();
                int level = this.level(line);
                result = DocumentHelper.createElement((String)ADMONITION).addAttribute(LEVEL, "" + level);
                if (matcher.group().equals(ADMONITION)) {
                    admonition = true;
                    result.addAttribute("type", ADMONITION);
                    String title = line.substring(matcher.end() + 2, line.length());
                    result.addAttribute("title", title);
                } else {
                    result.addAttribute("type", matcher.group());
                }
                String firstLine = "";
                if (!admonition && matcher.end() + 2 < line.length()) {
                    firstLine = line.substring(matcher.end() + 2, line.length());
                }
                if ((line = this.in.readLine()) != null) {
                    if (line.matches("\\s*")) {
                        line = this.in.readLine();
                    }
                    if (line != null && !line.matches("\\s*")) {
                        level = this.level(line);
                        String txt = firstLine.trim() + "\n" + line + "\n";
                        txt = txt + "\n" + this.readBlockWithBlankLine(level);
                        result.setText(txt);
                    } else {
                        result.setText(firstLine);
                    }
                } else {
                    result.setText(firstLine);
                }
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekBlankLine() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("\\s*")) {
            int level = this.level(line);
            result = DocumentHelper.createElement((String)BLANK_LINE).addAttribute(LEVEL, String.valueOf(level));
        }
        this.endPeek();
        return result;
    }

    public Element peekDirectiveOrReference() throws IOException {
        Pattern pImage;
        Matcher matcher;
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && (matcher = (pImage = Pattern.compile("^\\.\\.\\s*(?:\\|([^|]+)\\|)?\\s*(\\w+)::\\s*(.*)$")).matcher(line)).matches()) {
            String ref = matcher.group(1);
            String directiveType = matcher.group(2);
            String directiveValue = matcher.group(3);
            Element directive = null;
            if (ref != null && !"".equals(ref)) {
                result = DocumentHelper.createElement((String)SUBSTITUTION_DEFINITION);
                result.addAttribute(NAME, ref);
                directive = result.addElement(DIRECTIVE);
            } else {
                directive = result = DocumentHelper.createElement((String)DIRECTIVE);
            }
            result.addAttribute(LEVEL, "0");
            directive.addAttribute("type", directiveType);
            directive.addAttribute(DIRECTIVE_VALUE, directiveValue);
            String[] lines = this.readBlock(1);
            String text = this.joinBlock(lines, "\n", false);
            directive.setText(text);
        }
        this.endPeek();
        return result;
    }

    public Element peekTransition() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("\\s*") && (line = this.in.readLine()) != null && line.matches("-{3,}\\s*") && (line = this.in.readLine()) != null && line.matches("\\s*")) {
            result = DocumentHelper.createElement((String)TRANSITION).addAttribute(LEVEL, String.valueOf(0));
        }
        this.endPeek();
        return result;
    }

    public Element peekPara() throws IOException {
        String[] lines;
        this.beginPeek();
        Element result = null;
        do {
            int i;
            if ((lines = this.readBlock(0)).length <= 0) continue;
            int level = this.level(lines[0]);
            String para = this.joinBlock(lines);
            boolean literal = false;
            if (para.endsWith(": ::")) {
                para = para.substring(0, para.length() - " ::".length());
                this.in.unread("::", true);
                for (i = 0; i < level; ++i) {
                    this.in.add(' ');
                }
                literal = true;
            } else if (para.endsWith("::")) {
                para = para.substring(0, para.length() - ":".length());
                this.in.unread("::", true);
                for (i = 0; i < level; ++i) {
                    this.in.add(' ');
                }
                literal = true;
            }
            if (para.length() == 0 || ":".equals(para)) {
                if (!literal) continue;
                this.in.readLine();
                continue;
            }
            result = DocumentHelper.createElement((String)PARAGRAPH).addAttribute(LEVEL, String.valueOf(level)).addText(para);
        } while (result == null && lines.length > 0);
        this.endPeek();
        return result;
    }

    public Element peekLiteralBlock() throws IOException {
        this.beginPeek();
        Element result = null;
        String[] prefix = this.in.readLines(2);
        if (prefix.length == 2 && prefix[0].matches("\\s*::\\s*") && prefix[1].matches("\\s*")) {
            int level = this.level(prefix[0]);
            String para = this.in.readLine();
            if (para != null) {
                para = para.substring(++level) + "\n";
                String[] lines = this.in.readWhile("(^ {" + level + "}.*|\\s*)");
                while (lines.length > 0) {
                    for (String line : lines) {
                        para = !line.matches("\\s*") ? para + line.substring(level) + "\n" : para + "\n";
                    }
                    lines = this.in.readWhile("(^ {" + level + "}.*|\\s*)");
                }
                result = DocumentHelper.createElement((String)LITERAL_BLOCK).addAttribute(LEVEL, String.valueOf(level)).addText(para);
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekDocInfoItem() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^:((?i)author|authors|organization|address|contact|version|revision|status|date|copyright):.*$")) {
            result = DocumentHelper.createElement((String)DOCINFO);
            result.addAttribute(LEVEL, "0");
            String infotype = line.substring(1, line.indexOf(":", 1));
            String text = line.substring(line.indexOf(":", 1) + 1).trim();
            String[] textTmp = this.in.readWhile("^\\s+.*");
            if (textTmp.length != 0) {
                this.in.mark();
            }
            for (String txt : textTmp) {
                text = text + "\n" + txt.trim();
            }
            text = text.replaceAll("\\$\\w+: (.+?)\\$", "$1");
            result.addAttribute("type", infotype).addText(text);
        }
        this.endPeek();
        return result;
    }

    public Element peekTable() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null) {
            Pattern pTableBegin = Pattern.compile("^\\s*(\\+-+)+\\+\\s*$");
            Matcher matcher = null;
            matcher = pTableBegin.matcher(line);
            if (matcher.matches()) {
                result = DocumentHelper.createElement((String)TABLE);
                result.addAttribute("header", FALSE);
                int level = this.level(line);
                result.addAttribute(LEVEL, String.valueOf(level));
                line = line.trim();
                int tableWidth = line.length();
                result.addAttribute(TABLE_WIDTH, String.valueOf(tableWidth));
                Pattern pCellEnd = Pattern.compile("^\\s{" + level + "}(\\+-+\\+|\\|(?:[^+]+))([^+]+(?:\\+|\\|\\s*$)|-+\\+)*\\s*");
                Pattern pCell = Pattern.compile("^\\s{" + level + "}(\\|[^|]+)+\\|\\s*$");
                Pattern pHeader = Pattern.compile("^\\s{" + level + "}(\\+=+)+\\+\\s*$");
                Pattern pEnd = Pattern.compile("^\\s{" + level + "}(\\+-+)+\\+\\s*$");
                String lastSeparationLine = line;
                String lastLine = line;
                Element row = DocumentHelper.createElement((String)ROW);
                String[] table = this.in.readUntilBlank();
                boolean done = false;
                for (String l : table) {
                    done = false;
                    if ((l = l.trim()).length() != tableWidth) {
                        result = null;
                        break;
                    }
                    matcher = pEnd.matcher(l);
                    if (!done && matcher.matches()) {
                        lastSeparationLine = l;
                        for (Element cell : row.elements()) {
                            cell.addAttribute(CELL_END, TRUE);
                        }
                        row.addAttribute(ROW_END_HEADER, FALSE);
                        result.add(row);
                        row = DocumentHelper.createElement((String)ROW);
                        done = true;
                    }
                    matcher = pHeader.matcher(l);
                    if (!done && matcher.matches()) {
                        lastSeparationLine = l;
                        for (Element cell : row.elements()) {
                            cell.addAttribute(CELL_END, TRUE);
                        }
                        row.addAttribute(ROW_END_HEADER, TRUE);
                        result.add(row);
                        result.addAttribute("header", TRUE);
                        row = DocumentHelper.createElement((String)ROW);
                        done = true;
                    }
                    matcher = pCell.matcher(l);
                    if (!done && matcher.matches()) {
                        row.addAttribute("debug", "pCell");
                        int start = -1;
                        String content = "";
                        matcher = Pattern.compile("([^|]+)\\|").matcher(l);
                        int cellNumber = 0;
                        while (matcher.find()) {
                            int tmpstart = matcher.start(1);
                            int end = matcher.end(1);
                            String tmpcontent = matcher.group(1);
                            if ((lastLine.charAt(end) == '|' || lastLine.charAt(end) == '+') && lastSeparationLine.charAt(end) == '+') {
                                content = "".equals(content) ? tmpcontent : content + tmpcontent;
                                if (start == -1) {
                                    start = tmpstart;
                                }
                                Element cell = null;
                                if (row.nodeCount() <= cellNumber) {
                                    cell = row.addElement(CELL);
                                    cell.addAttribute(CELL_END, FALSE);
                                } else {
                                    cell = (Element)row.node(cellNumber);
                                }
                                cell.addAttribute(CELL_INDEX_START, String.valueOf(start));
                                cell.addAttribute(CELL_INDEX_END, String.valueOf(end));
                                cell.setText(cell.getText() + content + "\n");
                                start = end + 1;
                                content = "";
                            } else {
                                if (start == -1) {
                                    start = tmpstart;
                                }
                                content = content + tmpcontent + "|";
                                --cellNumber;
                            }
                            ++cellNumber;
                        }
                        done = true;
                    }
                    matcher = pCellEnd.matcher(l);
                    if (!done && matcher.matches()) {
                        row.addAttribute("debug", "pCellEnd");
                        for (Element cell : row.elements()) {
                            cell.addAttribute(CELL_END, TRUE);
                        }
                        StringBuffer tmp = new StringBuffer(l);
                        int start = -1;
                        String content = "";
                        matcher = Pattern.compile("([^+|]+|-+)([+|])").matcher(l);
                        int cellNumber = 0;
                        while (matcher.find()) {
                            int tmpstart = matcher.start(1);
                            int end = matcher.end(1);
                            String tmpcontent = matcher.group(1);
                            String ender = matcher.group(2);
                            if (!tmpcontent.matches("-+")) {
                                if (lastLine.charAt(end) == '|') {
                                    if (start == -1) {
                                        start = tmpstart;
                                    }
                                    String old = lastSeparationLine.substring(start - 1, end + 1);
                                    tmp.replace(start - 1, end + 1, old);
                                    if ("".equals(content)) {
                                        content = tmpcontent;
                                    }
                                    Element cell = null;
                                    cell = row.nodeCount() <= cellNumber ? row.addElement(CELL) : (Element)row.node(cellNumber);
                                    cell.setText(cell.getText() + content + "\n");
                                    cell.addAttribute(CELL_END, FALSE);
                                    cell.addAttribute(CELL_INDEX_START, String.valueOf(start));
                                    cell.addAttribute(CELL_INDEX_END, String.valueOf(end));
                                    start = end + 1;
                                    content = "";
                                } else {
                                    content = content + tmpcontent + ender;
                                }
                            }
                            ++cellNumber;
                        }
                        lastSeparationLine = tmp.toString();
                        row.addAttribute(ROW_END_HEADER, FALSE);
                        result.add(row);
                        row = DocumentHelper.createElement((String)ROW);
                        done = true;
                    }
                    if (!done) {
                        log.warn((Object)("Bad table format line " + this.in.getLineNumber()));
                    }
                    lastLine = l;
                }
            } else if (line.matches("^\\s*(=+ +)+=+\\s*$")) {
                Matcher matcher2;
                int i;
                result = DocumentHelper.createElement((String)TABLE);
                line = line.trim();
                Pattern pBordersEquals = Pattern.compile("^\\s*(=+ +)+=+\\s*$");
                Pattern pBordersTiret = Pattern.compile("^\\s*(-+ +)+-+\\s*$");
                Pattern pBorders = Pattern.compile("^\\s*([=-]+ +)+[=-]+\\s*$");
                String[] table = this.in.readUntilBlank();
                int tableWidth = line.length();
                int nbSeparations = 0;
                for (String l : table) {
                    if (l.length() > tableWidth) {
                        tableWidth = l.length();
                    }
                    if (!(matcher = pBordersEquals.matcher(l)).matches()) continue;
                    ++nbSeparations;
                }
                result.addAttribute("header", "" + (nbSeparations == 2));
                int level = this.level(line);
                result.addAttribute(LEVEL, String.valueOf(level));
                result.addAttribute(TABLE_WIDTH, String.valueOf(tableWidth + 1));
                Element row = DocumentHelper.createElement((String)ROW);
                LinkedList<Integer> columns = new LinkedList<Integer>();
                matcher = Pattern.compile("=+\\s+").matcher(line);
                int cellNumber = 0;
                while (matcher.find()) {
                    columns.add(matcher.end());
                    ++cellNumber;
                }
                columns.add(tableWidth);
                String lineRef = line.replace('=', '-');
                LinkedList<String> tableTmp = new LinkedList<String>();
                for (i = 0; i < table.length - 1; ++i) {
                    tableTmp.add(table[i]);
                    if (table[i].equals("") || table[i + 1].substring(0, (Integer)columns.get(0)).matches("\\s*")) continue;
                    matcher = pBorders.matcher(table[i]);
                    matcher2 = pBorders.matcher(table[i + 1]);
                    if (matcher.matches() || matcher2.matches() || table[i + 1].equals("")) continue;
                    tableTmp.add(lineRef);
                }
                tableTmp.add(table[table.length - 1]);
                table = new String[tableTmp.size()];
                for (i = 0; i < tableTmp.size(); ++i) {
                    table[i] = (String)tableTmp.get(i);
                }
                boolean done = false;
                LinkedList<String> lastLines = new LinkedList<String>();
                int separation = 1;
                for (String l : table) {
                    if (l == null) continue;
                    done = false;
                    matcher = pBordersTiret.matcher(l);
                    matcher2 = pBordersEquals.matcher(l);
                    if (matcher.matches() || matcher2.matches()) {
                        while (!lastLines.isEmpty()) {
                            matcher = Pattern.compile("[-=]+\\s*").matcher(l);
                            String tmpLine = (String)lastLines.getLast();
                            lastLines.removeLast();
                            int cellNumber2 = 0;
                            while (matcher.find()) {
                                Element cell = null;
                                cell = row.nodeCount() <= cellNumber2 ? row.addElement(CELL) : (Element)row.node(cellNumber2);
                                if (matcher.start() < tmpLine.length()) {
                                    if (columns.size() - 1 == cellNumber2) {
                                        cell.setText(tmpLine.substring(matcher.start(), tmpLine.length()) + "\n");
                                    } else if (matcher.end() < tmpLine.length()) {
                                        cell.setText(tmpLine.substring(matcher.start(), matcher.end()) + "\n");
                                    } else {
                                        cell.setText(tmpLine.substring(matcher.start(), tmpLine.length()) + "\n");
                                    }
                                }
                                if (lastLines.size() == 0) {
                                    row.addAttribute("debug", "pCell");
                                    cell.addAttribute(CELL_END, TRUE);
                                } else {
                                    row.addAttribute("debug", "pCellEnd");
                                    cell.addAttribute(CELL_END, FALSE);
                                }
                                cell.addAttribute(CELL_INDEX_START, String.valueOf(matcher.start() + 1));
                                if (line.length() == matcher.end()) {
                                    cell.addAttribute(CELL_INDEX_END, String.valueOf(columns.get(columns.size() - 1)));
                                } else {
                                    cell.addAttribute(CELL_INDEX_END, String.valueOf(matcher.end()));
                                }
                                ++cellNumber2;
                            }
                            if (matcher2.matches()) {
                                row.addAttribute(ROW_END_HEADER, "" + (++separation == 2));
                            } else {
                                row.addAttribute(ROW_END_HEADER, FALSE);
                            }
                            result.add(row);
                            row = DocumentHelper.createElement((String)ROW);
                            done = true;
                        }
                    }
                    if (!done && l.matches("^\\s*(.+ +)+.+\\s*$")) {
                        lastLines.addFirst(l);
                        done = true;
                    }
                    if (done) continue;
                    log.warn((Object)("Bad table format line " + this.in.getLineNumber()));
                }
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekBulletList() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\s*[" + this.escapeRegex(BULLET_CHAR) + "] +\\S.*")) {
            int level = this.level(line);
            String bullet = line.substring(level, level + 1);
            result = DocumentHelper.createElement((String)BULLET_LIST).addAttribute(LEVEL, String.valueOf(level)).addAttribute(BULLET, bullet);
            if (!this.in.eof()) {
                String[] content = this.readBlock(level + 1);
                line = line + " " + this.joinBlock(content);
            }
            String text = line.substring(level + 1).trim();
            result.addText(text);
            this.in.skipBlankLines();
        }
        this.endPeek();
        return result;
    }

    public Element peekFieldList() throws IOException {
        Pattern pattern;
        Matcher matcher;
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && (matcher = (pattern = Pattern.compile("^\\s*:([^:]+): [^\\s].*")).matcher(line)).matches()) {
            int level = this.level(line);
            String name = matcher.group(1);
            int begin = matcher.end(1) + 1;
            result = DocumentHelper.createElement((String)FIELD_LIST).addAttribute(LEVEL, String.valueOf(level)).addAttribute(NAME, name);
            if (!this.in.eof()) {
                String[] content = this.readBlock(level + 1);
                line = line + " " + this.joinBlock(content);
            }
            String text = line.substring(begin).trim();
            result.addText(text);
        }
        this.endPeek();
        return result;
    }

    public Element peekDefinitionList() throws IOException {
        this.beginPeek();
        Element result = null;
        String[] lines = this.in.readLines(2);
        if (lines.length == 2) {
            int level = this.level(lines[0]);
            int levelDef = this.level(lines[1]);
            if (levelDef != lines[1].length() && level < levelDef) {
                this.in.unread(lines[1], true);
                Pattern pattern = Pattern.compile("^\\s*([^:]+)(?: : (.*))?");
                Matcher matcher = pattern.matcher(lines[0]);
                if (matcher.matches()) {
                    String term = matcher.group(1);
                    String classifiers = matcher.group(2);
                    result = DocumentHelper.createElement((String)DEFINITION_LIST).addAttribute(LEVEL, String.valueOf(level)).addAttribute(TERM, term).addAttribute(CLASSIFIERS, classifiers);
                }
            }
        }
        this.endPeek();
        return result;
    }

    public Element peekEnumeratedList() throws IOException {
        Pattern pattern;
        Matcher matcher;
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && (matcher = (pattern = Pattern.compile("^\\s*(\\(?)(#|\\d+|[a-z]|[A-Z]|[ivxlcdm]+|[IVXLCDM]+)([\\.)]) [^\\s].*")).matcher(line)).matches()) {
            int level = this.level(line);
            String prefix = matcher.group(1);
            String start = matcher.group(2);
            String suffix = matcher.group(3);
            int begin = matcher.end(3);
            String enumtype = "auto";
            if (start.matches("\\d+")) {
                enumtype = "arabic";
            } else if (start.matches("(i|[ivxlcdm][ivxlcdm]+)")) {
                enumtype = "lowerroman";
                start = "1";
            } else if (start.matches("(I|[IVXLCDM][IVXLCDM]+)")) {
                enumtype = "upperroman";
                start = "1";
            } else if (start.matches("[a-z]+")) {
                enumtype = "loweralpha";
                start = String.valueOf(start.charAt(0) - 97);
            } else if (start.matches("[A-Z]+")) {
                enumtype = "upperalpha";
                start = String.valueOf(start.charAt(0) - 65);
            }
            result = DocumentHelper.createElement((String)ENUMERATED_LIST).addAttribute(LEVEL, String.valueOf(level)).addAttribute(START, start).addAttribute(PREFIX, prefix).addAttribute(SUFFIX, suffix).addAttribute(ENUMTYPE, enumtype);
            if (line.endsWith(": ::")) {
                line = line.substring(0, line.length() - " ::".length());
                this.in.unread("::", true);
            } else if (line.endsWith("::")) {
                line = line.substring(0, line.length() - ":".length());
                this.in.unread("::", true);
            }
            if (!this.in.eof()) {
                String[] content = this.readBlock(level + 1);
                String tempLine = " " + this.joinBlock(content);
                if (tempLine.endsWith(": ::")) {
                    tempLine = tempLine.substring(0, tempLine.length() - " ::".length());
                    this.in.unread("::", true);
                } else if (tempLine.endsWith("::")) {
                    tempLine = tempLine.substring(0, tempLine.length() - ":".length());
                    this.in.unread("::", true);
                }
                line = line + tempLine;
            }
            String text = line.substring(begin).trim();
            result.addText(text);
            this.in.skipBlankLines();
        }
        this.endPeek();
        return result;
    }

    public Element peekTitle() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null) {
            if (this.startsWithTitleChar(line)) {
                String[] titles = this.in.readLines(2);
                if (titles.length == 2 && line.length() >= titles[0].length() && line.length() == titles[1].length() && line.equals(titles[1])) {
                    result = DocumentHelper.createElement((String)"title").addAttribute("type", "double").addAttribute(CHAR, titles[1].substring(0, 1)).addText(titles[0]);
                }
            } else {
                String title = this.in.readLine();
                if (title != null && this.startsWithTitleChar(title) && line.replaceFirst("\\s*$", "").length() == title.length()) {
                    result = DocumentHelper.createElement((String)"title").addAttribute("type", "simple").addAttribute(CHAR, title.substring(0, 1)).addText(line.replaceFirst("\\s*$", ""));
                }
            }
        }
        if (result != null) {
            int level;
            String titleLevel = result.attributeValue(CHAR);
            if ("double".equals(result.attributeValue("type"))) {
                titleLevel = titleLevel + titleLevel;
            }
            if ((level = this.titleLevels.indexOf(titleLevel)) == -1) {
                level = this.titleLevels.size();
                this.titleLevels.add(titleLevel);
            }
            result.addAttribute(LEVEL, String.valueOf(JRSTReader.MAX_SECTION_DEPTH + level));
        }
        this.endPeek();
        return result;
    }

    public Element peekTarget() throws IOException {
        this.beginPeek();
        String line = this.in.readLine();
        Element result = null;
        if (line != null && line.matches("^\\s*\\.\\.\\s_[^_:].+:.*")) {
            result = DocumentHelper.createElement((String)TARGET);
            Matcher matcher = Pattern.compile("\\.\\.\\s_").matcher(line);
            if (matcher.find()) {
                int i = line.indexOf(58);
                result.addAttribute(ID, URLEncoder.encode(line.substring(matcher.end(), i).toLowerCase().replaceAll(" ", "-"), "UTF-8"));
                result.addAttribute(LEVEL, "" + this.level(line));
            }
        }
        this.endPeek();
        return result;
    }

    public LinkedList<Element> refTarget() throws IOException {
        this.beginPeek();
        String[] lines = this.in.readAll();
        LinkedList<Element> result = new LinkedList<Element>();
        for (String line : lines) {
            if (!line.matches("^\\s*\\.\\.\\s_[^_:].+:.*")) continue;
            result.add(DocumentHelper.createElement((String)TARGET));
            Matcher matcher = Pattern.compile("\\.\\.\\s_").matcher(line);
            if (!matcher.find()) continue;
            boolean done = false;
            for (int i = matcher.end(); i < line.length() && !done; ++i) {
                if (line.charAt(i) != ':') continue;
                result.getLast().addAttribute(LEVEL, "" + this.level(line));
                result.getLast().addAttribute(ID, URLEncoder.encode(line.substring(matcher.end(), i).replaceAll(" ", "-").toLowerCase(), "UTF-8"));
                result.getLast().addAttribute(NAME, line.substring(matcher.end(), i).toLowerCase());
                if (i + 2 > line.length()) {
                    line = this.in.readLine();
                    if (line == null) {
                        line = "";
                    }
                    result.getLast().addAttribute(REFURI, line.trim());
                } else {
                    result.getLast().addAttribute(REFURI, line.substring(i + 2, line.length()));
                }
                done = true;
            }
        }
        this.endPeek();
        return result;
    }

    private Element peekTargetAnonymousBody() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\s*__ .+$|^\\s*\\.\\. __\\:.+$")) {
            result = DocumentHelper.createElement((String)TARGETANONYMOUS);
            result.addAttribute(LEVEL, "" + this.level(line));
        }
        this.endPeek();
        return result;
    }

    private Element peekComment() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\.\\.\\s+.*$")) {
            int level;
            result = DocumentHelper.createElement((String)COMMENT);
            result.addAttribute(LEVEL, "0");
            result.addAttribute(XMLSPACE, "preserve");
            result.setText(line.substring(2).trim());
            line = this.in.readLine();
            if (line != null && (level = this.level(line)) > 0) {
                String[] lines = this.readBlock(level);
                String text = line.substring(level);
                for (String l : lines) {
                    text = text + "\n" + l.substring(level);
                }
                result.addText(text);
            }
        }
        this.endPeek();
        return result;
    }

    public List<Element> peekAllComment() throws IOException {
        this.beginPeek();
        ArrayList<Element> result = new ArrayList<Element>();
        String[] lines = this.in.readWhile("^\\.\\.\\s*.*$");
        if (lines != null) {
            for (String line : lines) {
                Element comment = DocumentHelper.createElement((String)COMMENT);
                comment.addAttribute(LEVEL, "0");
                comment.addAttribute(XMLSPACE, "preserve");
                comment.setText(line.substring(2).trim());
                result.add(comment);
            }
            this.in.mark();
        }
        this.endPeek();
        return result;
    }

    public Element peekFootnote() throws IOException {
        this.beginPeek();
        Element result = null;
        String line = this.in.readLine();
        if (line != null && line.matches("^\\s*\\.\\.\\s\\[(#|[0-9]|\\*).*\\]\\s.+$")) {
            result = DocumentHelper.createElement((String)FOOTNOTES);
            boolean bLine = false;
            do {
                bLine = false;
                Element footnote = result.addElement(FOOTNOTE);
                Matcher matcher = Pattern.compile("\\.\\.\\s\\[").matcher(line);
                if (!matcher.find()) continue;
                boolean done = false;
                for (int i = matcher.end(); i < line.length() && !done; ++i) {
                    if (line.charAt(i) != ']') continue;
                    result.addAttribute(LEVEL, "" + this.level(line));
                    String id = line.substring(matcher.end(), i);
                    if (id.matches("\\*")) {
                        footnote.addAttribute("type", AUTOSYMBOL);
                    } else if (id.matches("[0-9]")) {
                        footnote.addAttribute("type", NUM);
                        footnote.addAttribute(NAME, id);
                    } else if (id.equals("#")) {
                        footnote.addAttribute("type", AUTONUM);
                    } else {
                        footnote.addAttribute("type", AUTONUMLABEL);
                        footnote.addAttribute(NAME, id.substring(1));
                    }
                    String text = line.substring(i + 2, line.length());
                    int levelAv = this.level(line);
                    line = this.in.readLine();
                    if (line != null) {
                        if (line.matches("^\\s*\\.\\.\\s\\[(#|[0-9]|\\*).*\\]\\s.+$")) {
                            bLine = true;
                        } else {
                            String[] lines;
                            int level = this.level(line);
                            if (levelAv < level) {
                                lines = this.in.readWhile("(^ {" + level + "}.*)|(\\s*)");
                                text = text + "\n" + line.trim();
                                for (String l : lines) {
                                    text = text + "\n" + l.trim();
                                }
                            } else if (line.matches("\\s*")) {
                                level = levelAv + 1;
                                lines = this.in.readWhile("(^ {" + level + "}.*)|(\\s*)");
                                text = text + "\n" + line.trim();
                                for (String l : lines) {
                                    text = text + "\n" + l.trim();
                                }
                            }
                        }
                        if (!bLine) {
                            this.in.skipBlankLines();
                            String[] linesTmp = this.in.readWhile("^\\s*\\.\\.\\s\\[(#|[0-9]|\\*).*\\]\\s.+$");
                            if (linesTmp.length > 0) {
                                line = linesTmp[0];
                                bLine = true;
                            }
                        }
                    }
                    if (line == null) {
                        line = "";
                    }
                    footnote.setText(text);
                    done = true;
                }
            } while (bLine);
        }
        this.endPeek();
        return result;
    }

    private String readBlockWithBlankLine(int level) throws IOException {
        String txt = "";
        String[] lines = this.in.readWhile("(^ {" + level + "}.*)|(\\s*)");
        while (lines.length > 0) {
            for (String l : lines) {
                l = l.trim();
                txt = txt + l + "\n";
            }
            lines = this.in.readWhile("(^ {" + level + "}.*)|(\\s*)");
        }
        return txt;
    }

    public String readNotBlanckLine() throws IOException {
        this.beginPeek();
        this.in.skipBlankLines();
        String line = this.joinBlock(this.in.readUntilBlank(), "\n", false);
        this.endPeek();
        return line;
    }

    public int getLineNumber() {
        return this.in.getLineNumber();
    }

    public int getCharNumber() {
        return this.in.getCharNumber();
    }

    private boolean startsWithTitleChar(String line) {
        if (line == null || line.length() < 2) {
            return false;
        }
        boolean result = line.matches("([" + this.escapeRegex(TITLE_CHAR) + "])\\1+");
        return result;
    }

    private String escapeRegex(String text) {
        String result = text.replaceAll("([()[\\\\]*+?.])", "\\\\$1");
        return result;
    }

    private int level(String line) {
        int result;
        String sTmp = line.replaceAll("\\s", " ");
        for (result = 0; sTmp.length() > result && sTmp.charAt(result) == ' '; ++result) {
        }
        return result;
    }
}

