/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.legacy;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.collections.primitives.ArrayCharList;
import org.apache.commons.collections.primitives.CharList;

public class AdvancedReader {
    protected static final String TAB = "    ";
    protected static final int READ_AHEAD = 80;
    protected Reader in;
    protected CharList buffer;
    protected int charNumber;
    protected int charNumberMark;
    protected int lineNumber;
    protected int lineNumberMark;
    protected int nextChar;
    protected int markChar;
    protected int readInMark;
    protected boolean nlTwoCtrlChars = false;
    protected boolean noNlAtEOF = false;

    public AdvancedReader(Reader in) {
        this.in = new LineNumberReader(in);
        this.buffer = new ArrayCharList();
    }

    public void mark() throws IOException {
        this.markChar = this.nextChar;
        this.charNumberMark = this.charNumber;
        this.lineNumberMark = this.lineNumber;
        this.free(this.markChar);
    }

    public void reset() throws IOException {
        this.nextChar = this.markChar;
        this.charNumber = this.charNumberMark;
        this.lineNumber = this.lineNumberMark;
    }

    public int readSinceMark() {
        return this.nextChar - this.markChar;
    }

    public int getCharNumber() {
        return this.charNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private int free(int number) throws IOException {
        int result = Math.min(this.buffer.size(), number);
        this.buffer.subList(0, result).clear();
        this.nextChar -= result;
        this.markChar -= result;
        return result;
    }

    private void fill(int number) throws IOException {
        char[] cbuf;
        int read;
        int needed = this.nextChar + number - this.buffer.size();
        if (needed > 0 && (read = this.in.read(cbuf = new char[needed + 80])) != -1) {
            for (int i = 0; i < read; ++i) {
                this.buffer.add(cbuf[i]);
            }
        }
    }

    public boolean eof() throws IOException {
        boolean result;
        boolean bl = result = -1 == this.read();
        if (!result) {
            this.unread(1);
        }
        return result;
    }

    public int skip(int number) throws IOException {
        int result;
        for (result = 0; result < number && this.read() != -1; ++result) {
        }
        return result;
    }

    public void add(char character) {
        this.buffer.add(this.nextChar, character);
    }

    public int unread(int number) {
        int result = Math.min(number, this.nextChar);
        this.nextChar -= result;
        this.charNumber -= result;
        for (int i = this.nextChar; i < this.nextChar + result; ++i) {
            if (this.buffer.get(i) != '\n' && (this.buffer.get(i) != '\r' || i + 1 >= this.nextChar + result || this.buffer.get(i + 1) == '\n')) continue;
            --this.lineNumber;
        }
        return result;
    }

    public int unread(String line, boolean addNewLine) {
        int result = this.unread(line.length() + (addNewLine ? (this.nlTwoCtrlChars ? 2 : 1) : 0));
        return result;
    }

    public int unread(String[] lines, boolean addNewLine) {
        int result = 0;
        for (String line : lines) {
            result += this.unread(line, addNewLine);
        }
        return result;
    }

    public int read() throws IOException {
        this.fill(1);
        int result = -1;
        if (this.nextChar < this.buffer.size()) {
            result = this.buffer.get(this.nextChar++);
            ++this.charNumber;
            if ((char)result == '\n' || (char)result == '\r' && this.nextChar < this.buffer.size() && this.buffer.get(this.nextChar) != '\n') {
                ++this.lineNumber;
            }
        }
        return result;
    }

    public String readLine() throws IOException {
        StringBuffer result = new StringBuffer(80);
        int c = this.read();
        while (c != -1 && c != 10 && c != 13) {
            result.append((char)c);
            c = this.read();
        }
        this.nlTwoCtrlChars = false;
        if (c == 13) {
            c = this.read();
            if (c != 10 && c != -1) {
                this.unread(1);
            } else {
                this.nlTwoCtrlChars = true;
            }
        }
        this.noNlAtEOF = false;
        if (c == -1 && result.length() >= 0) {
            if (c == -1 && result.length() == 0) {
                return null;
            }
            this.noNlAtEOF = true;
            return result.toString();
        }
        return result.toString();
    }

    public void skipBlankLines() throws IOException {
        this.readUntil("^\\s*\\S+.*");
    }

    String[] readAll() throws IOException {
        String[] result = this.readLines(-1);
        return result;
    }

    public String[] readLines(int count) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String tmp = "";
        for (int i = count; tmp != null && i != 0; --i) {
            tmp = this.readLine();
            if (tmp == null) continue;
            result.add(tmp);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] readUntilBlank() throws IOException {
        String[] result = this.readUntil("\\s*");
        return result;
    }

    public String[] readUntil(String pattern) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String tmp = this.readLine();
        while (tmp != null && !tmp.matches(pattern)) {
            result.add(tmp);
            tmp = this.readLine();
        }
        if (tmp != null) {
            this.unread(tmp.length() + (!this.noNlAtEOF ? (this.nlTwoCtrlChars ? 2 : 1) : 0));
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] readWhile(String pattern) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String tmp = this.readLine();
        while (tmp != null && tmp.matches(pattern)) {
            result.add(tmp);
            tmp = this.readLine();
        }
        if (tmp != null) {
            this.unread(tmp.length() + (!this.noNlAtEOF ? (this.nlTwoCtrlChars ? 2 : 1) : 0));
        }
        return result.toArray(new String[result.size()]);
    }
}

