/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst.convertisor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;

public abstract class DocUtilsVisitor
extends VisitorSupport {
    public static final String EMPTY_STRING = "";
    public static final String LINE_SEPARATOR = "\n";
    public static final String SPACE = " ";
    private static Log log = LogFactory.getLog(DocUtilsVisitor.class);
    protected List<Element> cachedElements = new ArrayList<Element>();
    protected StringBuilder rstResult = new StringBuilder();

    public abstract String composeDocument(Element var1);

    public abstract String composeTitle(Element var1);

    public abstract String composeSubTitle(Element var1);

    public abstract String composeDocInfo(Element var1);

    public abstract String composeAutor(Element var1);

    public abstract String composeAutors(Element var1);

    public abstract String composeOrganisation(Element var1);

    public abstract String composeAddress(Element var1);

    public abstract String composeContact(Element var1);

    public abstract String composeVersion(Element var1);

    public abstract String composeResvision(Element var1);

    public abstract String composeStatus(Element var1);

    public abstract String composeDate(Element var1);

    public abstract String composeCopyright(Element var1);

    public abstract String composeDecoration(Element var1);

    public abstract String composeHeader(Element var1);

    public abstract String composeFooter(Element var1);

    public abstract String composeSection(Element var1);

    public abstract String composeTopic(Element var1);

    public abstract String composeSideBar(Element var1);

    public abstract String composeTransition(Element var1);

    public abstract String composeParagraph(Element var1);

    public abstract String composeCompound(Element var1);

    public abstract String composeContainer(Element var1);

    public abstract String composeBulletList(Element var1);

    public abstract String composeEnumeratedList(Element var1);

    public abstract String composeListItem(Element var1);

    public abstract String composeDefinitionList(Element var1);

    public abstract String composeDefinitionListItem(Element var1);

    public abstract String composeTerm(Element var1);

    public abstract String composeClassifier(Element var1);

    public abstract String composeDefinition(Element var1);

    public abstract String composeFieldList(Element var1);

    public abstract String composeField(Element var1);

    public abstract String composeFieldName(Element var1);

    public abstract String composeFieldBody(Element var1);

    public abstract String composeOptionList(Element var1);

    public abstract String composeOptionListItem(Element var1);

    public abstract String composeOptionGroup(Element var1);

    public abstract String composeOption(Element var1);

    public abstract String composeOptionString(Element var1);

    public abstract String composeOptionArgument(Element var1);

    public abstract String composeDescription(Element var1);

    public abstract String composeLiteralBlock(Element var1);

    public abstract String composeLineBlock(Element var1);

    public abstract String composeLine(Element var1);

    public abstract String composeBlockQuote(Element var1);

    public abstract String composeAttribution(Element var1);

    public abstract String composeDocTestBlock(Element var1);

    public abstract String composeAttention(Element var1);

    public abstract String composeCaution(Element var1);

    public abstract String composeDanger(Element var1);

    public abstract String composeError(Element var1);

    public abstract String composeHint(Element var1);

    public abstract String composeImportant(Element var1);

    public abstract String composeNote(Element var1);

    public abstract String composeTip(Element var1);

    public abstract String composeWarning(Element var1);

    public abstract String composeAdmonition(Element var1);

    public abstract String composeFootnote(Element var1);

    public abstract String composeCitation(Element var1);

    public abstract String composeLabel(Element var1);

    public abstract String composeRubric(Element var1);

    public abstract String composeTarget(Element var1);

    public abstract String composeSubstitutionDefinition(Element var1);

    public abstract String composeComment(Element var1);

    public abstract String composePending(Element var1);

    public abstract String composeFigure(Element var1);

    public abstract String composeImage(Element var1);

    public abstract String composeCaption(Element var1);

    public abstract String composeLegend(Element var1);

    public abstract String composeSystemMessage(Element var1);

    public abstract String composeRaw(Element var1);

    public abstract String composeTable(Element var1);

    public abstract String composeTgroup(Element var1);

    public abstract String composeColspec(Element var1);

    public abstract String composeThead(Element var1);

    public abstract String composeTbody(Element var1);

    public abstract String composeRow(Element var1);

    public abstract String composeEntry(Element var1);

    public abstract String composeEmphasis(Element var1);

    public abstract String composeStrong(Element var1);

    public abstract String composeLiteral(Element var1);

    public abstract String composeReference(Element var1);

    public abstract String composeFootnoteReference(Element var1);

    public abstract String composeCitationReference(Element var1);

    public abstract String composeSubstitutionReference(Element var1);

    public abstract String composeTitleReference(Element var1);

    public abstract String composeAbbreviation(Element var1);

    public abstract String composeAcronyme(Element var1);

    public abstract String composeSuperscipt(Element var1);

    public abstract String composeSubscript(Element var1);

    public abstract String composeInline(Element var1);

    public abstract String composeProblematic(Element var1);

    public abstract String composeGenerated(Element var1);

    public void visit(Element e) {
        if (!this.cachedElements.contains(e)) {
            log.debug((Object)("entre element " + e.getName()));
            this.addCachedElement(e);
            if (this.elementEquals("document", e)) {
                this.appendResult(this.composeDocument(e));
            } else if (this.elementEquals("title", e)) {
                this.appendResult(this.composeTitle(e));
            } else if (this.elementEquals("subtitle", e)) {
                this.appendResult(this.composeSubTitle(e));
            } else if (this.elementEquals("docinfo", e)) {
                this.appendResult(this.composeDocInfo(e));
            } else if (this.elementEquals("author", e)) {
                this.appendResult(this.composeAutor(e));
            } else if (this.elementEquals("authors", e)) {
                this.appendResult(this.composeAutors(e));
            } else if (this.elementEquals("organization", e)) {
                this.appendResult(this.composeOrganisation(e));
            } else if (this.elementEquals("address", e)) {
                this.appendResult(this.composeAddress(e));
            } else if (this.elementEquals("contact", e)) {
                this.appendResult(this.composeContact(e));
            } else if (this.elementEquals("version", e)) {
                this.appendResult(this.composeVersion(e));
            } else if (this.elementEquals("revision", e)) {
                this.appendResult(this.composeResvision(e));
            } else if (this.elementEquals("status", e)) {
                this.appendResult(this.composeStatus(e));
            } else if (this.elementEquals("date", e)) {
                this.appendResult(this.composeDate(e));
            } else if (this.elementEquals("copyright", e)) {
                this.appendResult(this.composeCopyright(e));
            } else if (this.elementEquals("decoration", e)) {
                this.appendResult(this.composeDecoration(e));
            } else if (this.elementEquals("header", e)) {
                this.appendResult(this.composeHeader(e));
            } else if (this.elementEquals("footer", e)) {
                this.appendResult(this.composeFooter(e));
            } else if (this.elementEquals("section", e)) {
                this.appendResult(this.composeSection(e));
            } else if (this.elementEquals("topic", e)) {
                this.appendResult(this.composeTopic(e));
            } else if (this.elementEquals("sidebar", e)) {
                this.appendResult(this.composeSideBar(e));
            } else if (this.elementEquals("transition", e)) {
                this.appendResult(this.composeTransition(e));
            } else if (this.elementEquals("paragraph", e)) {
                this.appendResult(this.composeParagraph(e));
            } else if (this.elementEquals("compound", e)) {
                this.appendResult(this.composeCompound(e));
            } else if (this.elementEquals("container", e)) {
                this.appendResult(this.composeContainer(e));
            } else if (this.elementEquals("bullet_list", e)) {
                this.appendResult(this.composeBulletList(e));
            } else if (this.elementEquals("enumerated_list", e)) {
                this.appendResult(this.composeEnumeratedList(e));
            } else if (this.elementEquals("list_item", e)) {
                this.appendResult(this.composeListItem(e));
            } else if (this.elementEquals("definition_list", e)) {
                this.appendResult(this.composeDefinitionList(e));
            } else if (this.elementEquals("definition_list_item", e)) {
                this.appendResult(this.composeDefinitionListItem(e));
            } else if (this.elementEquals("term", e)) {
                this.appendResult(this.composeTerm(e));
            } else if (this.elementEquals("classifier", e)) {
                this.appendResult(this.composeClassifier(e));
            } else if (this.elementEquals("definition", e)) {
                this.appendResult(this.composeDefinition(e));
            } else if (this.elementEquals("field_list", e)) {
                this.appendResult(this.composeFieldList(e));
            } else if (this.elementEquals("field", e)) {
                this.appendResult(this.composeField(e));
            } else if (this.elementEquals("field_name", e)) {
                this.appendResult(this.composeFieldName(e));
            } else if (this.elementEquals("field_body", e)) {
                this.appendResult(this.composeFieldBody(e));
            } else if (this.elementEquals("option_list", e)) {
                this.appendResult(this.composeOptionList(e));
            } else if (this.elementEquals("option_list_item", e)) {
                this.appendResult(this.composeOptionListItem(e));
            } else if (this.elementEquals("option_group", e)) {
                this.appendResult(this.composeOptionGroup(e));
            } else if (this.elementEquals("option", e)) {
                this.appendResult(this.composeOption(e));
            } else if (this.elementEquals("option_string", e)) {
                this.appendResult(this.composeOptionString(e));
            } else if (this.elementEquals("option_argument", e)) {
                this.appendResult(this.composeOptionArgument(e));
            } else if (this.elementEquals("description", e)) {
                this.appendResult(this.composeDescription(e));
            } else if (this.elementEquals("literal_block", e)) {
                this.appendResult(this.composeLiteralBlock(e));
            } else if (this.elementEquals("line_block", e)) {
                this.appendResult(this.composeLineBlock(e));
            } else if (this.elementEquals("line", e)) {
                this.appendResult(this.composeLine(e));
            } else if (this.elementEquals("block_quote", e)) {
                this.appendResult(this.composeBlockQuote(e));
            } else if (this.elementEquals("attribution", e)) {
                this.appendResult(this.composeAttribution(e));
            } else if (this.elementEquals("doctest_block", e)) {
                this.appendResult(this.composeDocTestBlock(e));
            } else if (this.elementEquals("attention", e)) {
                this.appendResult(this.composeAttention(e));
            } else if (this.elementEquals("caution", e)) {
                this.appendResult(this.composeCaution(e));
            } else if (this.elementEquals("danger", e)) {
                this.appendResult(this.composeDanger(e));
            } else if (this.elementEquals("error", e)) {
                this.appendResult(this.composeError(e));
            } else if (this.elementEquals("hint", e)) {
                this.appendResult(this.composeHint(e));
            } else if (this.elementEquals("important", e)) {
                this.appendResult(this.composeImportant(e));
            } else if (this.elementEquals("note", e)) {
                this.appendResult(this.composeNote(e));
            } else if (this.elementEquals("tip", e)) {
                this.appendResult(this.composeTip(e));
            } else if (this.elementEquals("warning", e)) {
                this.appendResult(this.composeWarning(e));
            } else if (this.elementEquals("admonition", e)) {
                this.appendResult(this.composeAdmonition(e));
            } else if (this.elementEquals("footnote", e)) {
                this.appendResult(this.composeFootnote(e));
            } else if (this.elementEquals("citation", e)) {
                this.appendResult(this.composeCitation(e));
            } else if (this.elementEquals("label", e)) {
                this.appendResult(this.composeLabel(e));
            } else if (this.elementEquals("rubric", e)) {
                this.appendResult(this.composeRubric(e));
            } else if (this.elementEquals("target", e)) {
                this.appendResult(this.composeTarget(e));
            } else if (this.elementEquals("substitution_definition", e)) {
                this.appendResult(this.composeSubstitutionDefinition(e));
            } else if (this.elementEquals("comment", e)) {
                this.appendResult(this.composeComment(e));
            } else if (this.elementEquals("pending", e)) {
                this.appendResult(this.composePending(e));
            } else if (this.elementEquals("figure", e)) {
                this.appendResult(this.composeFigure(e));
            } else if (this.elementEquals("image", e)) {
                this.appendResult(this.composeImage(e));
            } else if (this.elementEquals("caption", e)) {
                this.appendResult(this.composeCaption(e));
            } else if (this.elementEquals("legend", e)) {
                this.appendResult(this.composeLegend(e));
            } else if (this.elementEquals("system_message", e)) {
                this.appendResult(this.composeSystemMessage(e));
            } else if (this.elementEquals("raw", e)) {
                this.appendResult(this.composeRaw(e));
            } else if (this.elementEquals("table", e)) {
                this.appendResult(this.composeTable(e));
            } else if (this.elementEquals("tgroup", e)) {
                this.appendResult(this.composeTgroup(e));
            } else if (this.elementEquals("colspec", e)) {
                this.appendResult(this.composeColspec(e));
            } else if (this.elementEquals("thead", e)) {
                this.appendResult(this.composeThead(e));
            } else if (this.elementEquals("tbody", e)) {
                this.appendResult(this.composeTbody(e));
            } else if (this.elementEquals("row", e)) {
                this.appendResult(this.composeRow(e));
            } else if (this.elementEquals("entry", e)) {
                this.appendResult(this.composeEntry(e));
            } else if (this.elementEquals("emphasis", e)) {
                this.appendResult(this.composeEmphasis(e));
            } else if (this.elementEquals("strong", e)) {
                this.appendResult(this.composeStrong(e));
            } else if (this.elementEquals("literal", e)) {
                this.appendResult(this.composeLiteral(e));
            } else if (this.elementEquals("reference", e)) {
                this.appendResult(this.composeReference(e));
            } else if (this.elementEquals("footnote_reference", e)) {
                this.appendResult(this.composeFootnoteReference(e));
            } else if (this.elementEquals("citation_reference", e)) {
                this.appendResult(this.composeCitationReference(e));
            } else if (this.elementEquals("substitution_reference", e)) {
                this.appendResult(this.composeSubstitutionReference(e));
            } else if (this.elementEquals("title_reference", e)) {
                this.appendResult(this.composeTitleReference(e));
            } else if (this.elementEquals("abbreviation", e)) {
                this.appendResult(this.composeAbbreviation(e));
            } else if (this.elementEquals("acronym", e)) {
                this.appendResult(this.composeAcronyme(e));
            } else if (this.elementEquals("superscript", e)) {
                this.appendResult(this.composeSuperscipt(e));
            } else if (this.elementEquals("subscript", e)) {
                this.appendResult(this.composeSubscript(e));
            } else if (this.elementEquals("inline", e)) {
                this.appendResult(this.composeInline(e));
            } else if (this.elementEquals("problematic", e)) {
                this.appendResult(this.composeProblematic(e));
            } else if (this.elementEquals("generated", e)) {
                this.appendResult(this.composeGenerated(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseDocument(Element el) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("This element : " + el.getName()));
        }
        DocUtilsVisitor visitor = (DocUtilsVisitor)((Object)((Object)((Object)this)).getClass().newInstance());
        try {
            el.accept((Visitor)visitor);
            String result = visitor.getResult();
            if (log.isDebugEnabled()) {
                log.debug((Object)("document parsing result:\n" + result));
            }
            String string = result;
            this.addCachedElements(visitor.getCachedElements());
            visitor.clear();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.addCachedElements(visitor.getCachedElements());
                visitor.clear();
                throw throwable;
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Cant compose document for reason " + ex.getMessage()), (Throwable)ex);
                }
                return EMPTY_STRING;
            }
        }
    }

    public String getResult() {
        return this.rstResult.toString();
    }

    public void clear() {
        this.cachedElements.clear();
        this.rstResult = null;
    }

    protected void appendResult(String result) {
        this.rstResult.append(result);
    }

    protected boolean elementEquals(String name, Element e) {
        return e.getName().equals(name);
    }

    protected List<Element> getCachedElements() {
        return this.cachedElements;
    }

    protected void addCachedElement(Element e) {
        this.cachedElements.add(e);
    }

    protected void addCachedElements(List<Element> elements) {
        this.cachedElements.addAll(elements);
    }

    protected String indent(String toIndent, int l) {
        String prefix = EMPTY_STRING;
        for (int i = 0; i < l; ++i) {
            prefix = prefix + SPACE;
        }
        StringBuilder buffer = new StringBuilder();
        for (String s : toIndent.split(LINE_SEPARATOR)) {
            buffer.append(prefix).append(s).append(LINE_SEPARATOR);
        }
        return buffer.toString();
    }
}

