/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import com.lowagie.text.Image;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;

public class JRSTUserAgent
implements UserAgentCallback {
    protected static Log log = LogFactory.getLog(JRSTUserAgent.class);
    protected NaiveUserAgent delegate;
    protected String path;
    private SharedContext sharedContext;

    public JRSTUserAgent(String path) {
        this.path = path;
        this.delegate = new NaiveUserAgent();
    }

    public CSSResource getCSSResource(String uri) {
        return this.delegate.getCSSResource(uri);
    }

    public ImageResource getImageResource(String uri) {
        uri = this.resolveURI(uri);
        return this.createImageResource(uri);
    }

    protected ImageResource createImageResource(String uri) {
        ImageResource imageResource = null;
        try {
            URL source = new URI(uri).toURL();
            Image image = Image.getInstance((URL)source);
            this.scaleToOutputResolution(image);
            ITextFSImage iTextFSImage = new ITextFSImage(image);
            imageResource = new ImageResource(uri, (FSImage)iTextFSImage);
        }
        catch (Exception eee) {
            log.error((Object)"Failed to create image resource", (Throwable)eee);
        }
        return imageResource;
    }

    public XMLResource getXMLResource(String uri) {
        return this.delegate.getXMLResource(uri);
    }

    public byte[] getBinaryResource(String uri) {
        return this.delegate.getBinaryResource(uri);
    }

    public boolean isVisited(String uri) {
        return this.delegate.isVisited(uri);
    }

    public void setBaseURL(String url) {
        this.delegate.setBaseURL(url);
    }

    public String getBaseURL() {
        return this.delegate.getBaseURL();
    }

    public String resolveURI(String uri) {
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this.path == null) {
            try {
                URL result = new URL(uri);
                this.setBaseURL(result.toExternalForm());
            }
            catch (MalformedURLException e) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    log.info((Object)("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri));
                    return null;
                }
            }
        }
        try {
            return new URL(uri).toString();
        }
        catch (MalformedURLException e) {
            try {
                File filePath = new File(this.path);
                URI resourcePath = filePath.toURI();
                resourcePath = resourcePath.resolve(uri);
                URL result = resourcePath.toURL();
                ret = result.toURI().toString();
            }
            catch (Exception e1) {
                log.error((Object)("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this.path), (Throwable)e1);
            }
            return ret;
        }
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.sharedContext.getDotsPerPixel();
        image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
    }

    public SharedContext getSharedContext() {
        return this.sharedContext;
    }

    public void setSharedContext(SharedContext sharedContext) {
        this.sharedContext = sharedContext;
    }
}

