/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.nuiton.jrst.JRST;
import org.nuiton.jrst.JRSTEntityResolver;
import org.nuiton.jrst.JRSTToXmlStrategy;
import org.python.util.PythonInterpreter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@Component(role=JRSTToXmlStrategy.class, hint="docutils", description="Transform a RST model (using jython + docutils), to a xml format.")
public class JRSTToXmlStrategyDocutils
implements JRSTToXmlStrategy {
    private static final String DOCUTILS_LAUNCHER = "__run__.py";
    private static final String IMPORT_SCRIPT = "import __run__";
    private static final String WINDOWS_NAME = "win";
    private static final String OS_NAME = "os.name";
    private static final String BANG = "!";
    private static final String FILE_URI_PREFIX = "file:";
    private static final Log log = LogFactory.getLog(JRSTToXmlStrategyDocutils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document generateRstToXml(File in, String encoding) throws Exception {
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            URL resource = JRST.class.getResource("/__run__.py");
            String docutilsPath = resource.getPath().replaceAll(DOCUTILS_LAUNCHER, "");
            docutilsPath = docutilsPath.replaceAll(BANG, "");
            docutilsPath = docutilsPath.replaceAll(FILE_URI_PREFIX, "");
            PythonInterpreter interp = new PythonInterpreter();
            String commandImport = IMPORT_SCRIPT;
            interp.exec(commandImport);
            String filePath = in.getAbsolutePath();
            String property = System.getProperty(OS_NAME).toLowerCase();
            if (property.contains(WINDOWS_NAME)) {
                filePath = filePath.replaceAll("\\\\", "\\\\\\\\");
            }
            interp.setOut((OutputStream)out);
            String commandExec = String.format("__run__.exec_docutils('%s', '%s', '%s')", docutilsPath, "xml", filePath);
            interp.exec(commandExec);
            interp.cleanup();
            String xmlString = new String(out.toByteArray(), encoding);
            Document doc = null;
            try {
                doc = this.parseText(xmlString);
            }
            catch (DocumentException e) {
                log.error((Object)"Error during the creation of the document", (Throwable)e);
            }
            out.close();
            Document document = doc;
            return document;
        }
    }

    protected Document parseText(String text) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new JRSTEntityResolver());
        InputSource source = new InputSource(new StringReader(text));
        String encoding = JRSTToXmlStrategyDocutils.getEncoding(text);
        source.setEncoding(encoding);
        Document result = reader.read(source);
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }
}

