/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FasterCachedResourceResolver;
import org.nuiton.util.Resource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JRSTResourceResolver
extends FasterCachedResourceResolver {
    private static Log log = LogFactory.getLog(JRSTResourceResolver.class);
    protected String xsl;

    public JRSTResourceResolver(String xsl) {
        this.xsl = xsl;
    }

    public Source resolve(String href, String base) {
        Source resolved = super.resolve(href, base);
        if (resolved != null) {
            return resolved;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOLVING: href: " + href + " base: " + base));
        }
        String xslDir = this.xsl.substring(0, this.xsl.lastIndexOf(47) + 1);
        String resouceFullName = xslDir + href;
        if (log.isDebugEnabled()) {
            log.debug((Object)("RESOLVING: resouceFullName: " + resouceFullName));
        }
        try {
            InputStream stream;
            File file = new File(resouceFullName);
            if (file.exists()) {
                stream = new FileInputStream(file);
            } else {
                try {
                    stream = Resource.getURL((String)resouceFullName).openStream();
                }
                catch (Exception e) {
                    stream = Resource.getURL((String)("/docbook/common/" + href)).openStream();
                }
            }
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = parserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource source = null;
                    String smallSystemId = systemId.substring(systemId.lastIndexOf("/") + 1);
                    URL url = Resource.getURL((String)("/docbook/common/" + smallSystemId));
                    if (url != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Resolved entity url : " + url));
                        }
                        InputStream stream = url.openStream();
                        source = new InputSource(stream);
                    }
                    return source;
                }
            });
            InputSource inSrc = new InputSource(stream);
            SAXSource saxs = new SAXSource(xmlReader, inSrc);
            return saxs;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }
}

