/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class JRSTInterface
extends JDialog {
    private static final long serialVersionUID = 5327326730753891936L;
    private JPanel savePanel;
    private JPanel formatPanel;
    private JPanel openPanel;
    private JPanel formatLigne;
    private JPanel xslLigne;
    private JComboBox formatList;
    private JButton boutonAnnuler;
    private JButton boutonConvertir;
    private JPanel panelPrincipal;
    private JPanel boutonPanel;
    private JPanel simpleModePanel;
    private JButton boutonSaveLocation;
    private JLabel errorLbl;
    private JButton boutonOpenLocation;
    private JButton boutonXslLocation;
    private String[] listFormats;
    private JTextField saveText;
    private JTextField openText;
    private JTextField xslText;
    private JRadioButton format;
    private JRadioButton xslRadio;
    private JCheckBox simpleModeChechBox;
    private LinkedList<JPanel> ListAddXslPanel;
    private LinkedList<JTextField> ListXslText;
    private LinkedList<JButton> ListXslBouton;
    private LinkedList<JButton> ListXslBoutonLocation;
    private boolean ecrase;
    private boolean simpleMode;
    private String[] commande;
    private ImageIcon open = Resource.getIcon((String)"icone/open.png");
    private ImageIcon delete = Resource.getIcon((String)"icone/cancel.png");
    private ImageIcon more = Resource.getIcon((String)"icone/more.gif");
    private LinkedList<Container> composantsXSL;

    public JRSTInterface(String o) {
        this.setFormats(o);
        this.setDefaultCloseOperation(2);
        this.setTitle("JRST");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelPrincipal(), "Center");
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setLayout(new BoxLayout(this.panelPrincipal, 1));
            this.panelPrincipal.add(this.getErrorLabel());
            this.panelPrincipal.add(this.getOuvrirPanel());
            this.panelPrincipal.add(this.getSavePanel());
            this.panelPrincipal.add(this.getFormatPanel());
            this.panelPrincipal.add(this.getSimpleModePanel());
            this.panelPrincipal.add(this.getBoutonPanel());
        }
        return this.panelPrincipal;
    }

    private JLabel getErrorLabel() {
        if (this.errorLbl == null) {
            this.errorLbl = new JLabel("");
        }
        return this.errorLbl;
    }

    private JPanel getBoutonPanel() {
        if (this.boutonPanel == null) {
            this.boutonPanel = new JPanel();
            this.boutonPanel.setLayout(new FlowLayout());
            this.boutonPanel.add(this.getBoutonAnnuler());
            this.boutonPanel.add(this.getBoutonConvertir());
        }
        return this.boutonPanel;
    }

    private JCheckBox getSimpleCheckBox() {
        if (this.simpleModeChechBox == null) {
            this.simpleModeChechBox = new JCheckBox("Simple mode");
            this.simpleModeChechBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRSTInterface.this.setMode();
                }
            });
        }
        return this.simpleModeChechBox;
    }

    private JPanel getSimpleModePanel() {
        if (this.simpleModePanel == null) {
            this.simpleModePanel = new JPanel();
            this.simpleModePanel.setLayout(new FlowLayout(0));
            this.simpleModePanel.add(this.getSimpleCheckBox());
        }
        return this.simpleModePanel;
    }

    private JButton getBoutonConvertir() {
        if (this.boutonConvertir == null) {
            this.boutonConvertir = new JButton();
            this.boutonConvertir.setText(I18n.t((String)"btnConvert", (Object[])new Object[0]));
            this.boutonConvertir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRSTInterface.this.convert();
                }
            });
        }
        return this.boutonConvertir;
    }

    private JButton getBoutonAnnuler() {
        if (this.boutonAnnuler == null) {
            this.boutonAnnuler = new JButton();
            this.boutonAnnuler.setText(I18n.t((String)"btnCancel", (Object[])new Object[0]));
            this.boutonAnnuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRSTInterface.this.annuler();
                }
            });
        }
        return this.boutonAnnuler;
    }

    private JPanel getFormatPanel() {
        if (this.formatPanel == null) {
            this.composantsXSL = new LinkedList();
            this.ListAddXslPanel = new LinkedList();
            this.ListXslBouton = new LinkedList();
            this.ListXslText = new LinkedList();
            this.ListXslBoutonLocation = new LinkedList();
            this.formatPanel = new JPanel();
            this.formatPanel.setLayout(new BoxLayout(this.formatPanel, 1));
            ButtonGroup group = new ButtonGroup();
            group.add(this.getFormat());
            group.add(this.getXslRadio());
            this.formatPanel.add(this.getFormatLigne());
            this.formatPanel.add(this.getXslPanel());
            for (JPanel p : this.getListAddXslPanel()) {
                this.formatPanel.add(p);
            }
        }
        return this.formatPanel;
    }

    private LinkedList<JPanel> getListAddXslPanel() {
        if (this.ListAddXslPanel.size() == 0) {
            this.ListAddXslPanel.add(this.ajoutXSL());
            this.getFormatList().setEnabled(this.getFormat().isSelected());
            for (Container c : this.composantsXSL) {
                c.setEnabled(!this.getFormat().isSelected());
            }
        }
        return this.ListAddXslPanel;
    }

    private JPanel ajoutXSL() {
        JButton b = new JButton(this.more);
        b.setPreferredSize(new Dimension(20, 20));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                if (b.getIcon() == JRSTInterface.this.more) {
                    JRSTInterface.this.ajout();
                } else {
                    JRSTInterface.this.supprimerXslLigne((JButton)e.getSource());
                }
            }
        });
        this.composantsXSL.add(b);
        this.ListXslBouton.add(b);
        JTextField t = new JTextField();
        t.setColumns(40);
        t.setVisible(false);
        this.composantsXSL.add(t);
        this.ListXslText.add(t);
        JButton b2 = new JButton(this.open);
        b2.setPreferredSize(new Dimension(30, 30));
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRSTInterface.this.openXslLocation((JButton)e.getSource());
            }
        });
        b2.setVisible(false);
        this.composantsXSL.add(b2);
        this.ListXslBoutonLocation.add(b2);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(b);
        p.add(t);
        p.add(b2);
        return p;
    }

    private void supprimerXslLigne(JButton button) {
        boolean done = false;
        for (int i = 0; i < this.ListXslBouton.size() && !done; ++i) {
            if (this.ListXslBouton.get(i) != button) continue;
            done = true;
            this.ListAddXslPanel.get(i).setVisible(false);
            this.ListXslBouton.remove(i);
            this.ListAddXslPanel.remove(i);
            this.ListXslBoutonLocation.remove(i);
            this.ListXslText.remove(i);
            this.pack();
        }
    }

    private void ajout() {
        this.ListXslBoutonLocation.getLast().setVisible(true);
        this.ListXslText.getLast().setVisible(true);
        this.ListXslBouton.getLast().setIcon(this.delete);
        this.ListAddXslPanel.add(this.ajoutXSL());
        this.formatPanel.add(this.ListAddXslPanel.getLast());
        this.pack();
    }

    private JPanel getFormatLigne() {
        if (this.formatLigne == null) {
            this.formatLigne = new JPanel();
            this.formatLigne.setLayout(new FlowLayout(3));
            this.formatLigne.add(this.getFormat());
            this.formatLigne.add(this.getFormatList());
        }
        return this.formatLigne;
    }

    private JPanel getXslPanel() {
        if (this.xslLigne == null) {
            this.xslLigne = new JPanel();
            this.xslLigne.setLayout(new FlowLayout(4));
            this.xslLigne.add(this.getXslRadio());
            this.xslLigne.add(this.getXslText());
            this.xslLigne.add(this.getBoutonXslLocation());
        }
        return this.xslLigne;
    }

    private JButton getBoutonXslLocation() {
        if (this.boutonXslLocation == null) {
            this.boutonXslLocation = new JButton(this.open);
            this.boutonXslLocation.setPreferredSize(new Dimension(30, 30));
            this.boutonXslLocation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRSTInterface.this.openXslLocation((JButton)e.getSource());
                }
            });
            this.boutonXslLocation.setEnabled(false);
            this.ListXslBoutonLocation.add(this.boutonXslLocation);
            this.composantsXSL.add(this.boutonXslLocation);
        }
        return this.boutonXslLocation;
    }

    private void openXslLocation(JButton b) {
        JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
        fc.showOpenDialog(this);
        File file = fc.getSelectedFile();
        if (file != null) {
            int i = 0;
            for (JButton btmp : this.ListXslBoutonLocation) {
                if (btmp == b) {
                    this.ListXslText.get(i).setText(file.getAbsolutePath());
                }
                ++i;
            }
        }
    }

    private JTextField getXslText() {
        if (this.xslText == null) {
            this.xslText = new JTextField();
            this.xslText.setColumns(30);
            this.xslText.setEnabled(false);
            this.composantsXSL.add(this.xslText);
            this.ListXslText.add(this.xslText);
        }
        return this.xslText;
    }

    private JRadioButton getFormat() {
        if (this.format == null) {
            this.format = new JRadioButton("Format : ");
            this.format.setSelected(true);
            this.format.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JRSTInterface.this.formatEnable();
                }
            });
        }
        return this.format;
    }

    private JRadioButton getXslRadio() {
        if (this.xslRadio == null) {
            this.xslRadio = new JRadioButton(I18n.t((String)"externalXSL", (Object[])new Object[0]));
        }
        return this.xslRadio;
    }

    private void formatEnable() {
        this.getFormatList().setEnabled(this.getFormat().isSelected());
        for (Container c : this.composantsXSL) {
            c.setEnabled(!this.getFormat().isSelected());
        }
    }

    private JComboBox getFormatList() {
        if (this.formatList == null) {
            this.formatList = new JComboBox<String>(this.listFormats);
        }
        return this.formatList;
    }

    private JPanel getSavePanel() {
        if (this.savePanel == null) {
            this.savePanel = new JPanel();
            this.savePanel.setLayout(new FlowLayout());
            this.savePanel.add(new JLabel(I18n.t((String)"saveAs", (Object[])new Object[0])));
            this.savePanel.add(this.getSaveText());
            this.savePanel.add(this.getBoutonSaveLocation());
        }
        return this.savePanel;
    }

    private JButton getBoutonSaveLocation() {
        if (this.boutonSaveLocation == null) {
            this.boutonSaveLocation = new JButton(this.open);
            this.boutonSaveLocation.setPreferredSize(new Dimension(30, 30));
            this.boutonSaveLocation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRSTInterface.this.openSaveLocation();
                }
            });
        }
        return this.boutonSaveLocation;
    }

    private JPanel getOuvrirPanel() {
        if (this.openPanel == null) {
            this.openPanel = new JPanel();
            this.openPanel.setLayout(new FlowLayout());
            this.openPanel.add(new JLabel(I18n.t((String)"open", (Object[])new Object[0])));
            this.openPanel.add(this.getOpenText());
            this.openPanel.add(this.getBoutonOpenLocation());
        }
        return this.openPanel;
    }

    private JTextField getSaveText() {
        if (this.saveText == null) {
            this.saveText = new JTextField();
            this.saveText.setColumns(31);
        }
        return this.saveText;
    }

    private JTextField getOpenText() {
        if (this.openText == null) {
            this.openText = new JTextField();
            this.openText.setColumns(31);
        }
        return this.openText;
    }

    private JButton getBoutonOpenLocation() {
        if (this.boutonOpenLocation == null) {
            this.boutonOpenLocation = new JButton(this.open);
            this.boutonOpenLocation.setPreferredSize(new Dimension(30, 30));
            this.boutonOpenLocation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRSTInterface.this.openOpenLocation();
                }
            });
        }
        return this.boutonOpenLocation;
    }

    private void openOpenLocation() {
        JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
        fc.showOpenDialog(this);
        File file = fc.getSelectedFile();
        if (file != null) {
            this.getOpenText().setText(file.getAbsolutePath());
        }
    }

    private void openSaveLocation() {
        JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
        fc.showSaveDialog(this);
        File file = fc.getSelectedFile();
        if (file != null) {
            if (file.exists()) {
                int choix = this.askEcraser();
                if (choix == 0) {
                    this.ecrase = true;
                    this.getSaveText().setText(file.getAbsolutePath());
                } else if (choix == 1) {
                    this.openSaveLocation();
                }
            } else {
                this.getSaveText().setText(file.getAbsolutePath());
            }
        }
    }

    public int askEcraser() {
        int choix = JOptionPane.showConfirmDialog(this, I18n.t((String)"overwriteGraph?", (Object[])new Object[0]));
        return choix;
    }

    public void setFormats(String formats) {
        this.listFormats = formats.split("\\|");
    }

    private void annuler() {
        System.exit(0);
    }

    private void setMode() {
        this.simpleMode = !this.simpleMode;
    }

    private void convert() {
        boolean exit = false;
        if (this.getOpenText().getText().equals("")) {
            this.getErrorLabel().setText(I18n.t((String)"openEmpty?", (Object[])new Object[0]));
            this.getErrorLabel().setForeground(Color.RED);
            this.pack();
        } else {
            File file;
            if (!this.ecrase && (file = new File(this.getSaveText().getText())).exists()) {
                int choix = this.askEcraser();
                if (choix == 0) {
                    this.ecrase = true;
                } else if (choix == 1) {
                    exit = true;
                }
            }
            if (!exit) {
                String cmd = "";
                if (this.ecrase) {
                    cmd = cmd + "--force ";
                }
                if (this.simpleMode) {
                    cmd = cmd + "--simple ";
                }
                if (this.getFormat().isSelected()) {
                    cmd = cmd + "-t " + this.getFormatList().getSelectedItem();
                } else {
                    cmd = cmd + "-x ";
                    for (JTextField t : this.ListXslText) {
                        if (t.getText().equals("")) continue;
                        cmd = cmd + t.getText() + ",";
                    }
                    cmd = cmd.substring(0, cmd.length() - 1);
                }
                if (this.getSaveText().getText().length() > 0) {
                    cmd = cmd + " -o " + this.getSaveText().getText();
                }
                cmd = cmd + " " + this.getOpenText().getText() + " ";
                this.commande = cmd.trim().split(" ");
                this.dispose();
            }
        }
    }

    public String[] getCmd() {
        return this.commande;
    }
}

