/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedList;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.nuiton.jrst.legacy.DocumentHandler;
import org.nuiton.jrst.legacy.DocumentWalker;
import org.nuiton.util.FasterCachedResourceResolver;
import org.xml.sax.ContentHandler;

public class JRSTGenerator
implements DocumentHandler {
    static boolean DEBUG = true;
    private static Log log = LogFactory.getLog(JRSTGenerator.class);
    protected Writer out;
    protected int sectionLevel;
    protected int indent;
    protected String listType = "bullet|enumerated|...";
    protected int enumStart = 1;
    protected URIResolver uriResolver;

    public JRSTGenerator() {
    }

    public JRSTGenerator(Writer out) {
        this.out = out;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void generate(Document doc) throws IOException {
        this.generate(doc, this);
    }

    public void generate(Document doc, DocumentHandler handler) {
        DocumentWalker walker = new DocumentWalker(handler);
        walker.walk(doc);
    }

    public void generate(Document doc, ContentHandler handler) throws IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (this.uriResolver != null) {
            factory.setURIResolver(this.uriResolver);
        }
        Transformer transformer = factory.newTransformer();
        DocumentSource source = new DocumentSource(doc);
        SAXResult result = new SAXResult(handler);
        transformer.transform((Source)source, result);
    }

    public void generate(Document doc, URL stylesheet) throws IOException, TransformerException {
        this.generate(doc, stylesheet, this.out);
    }

    public void generate(Document doc, URL stylesheet, Writer out) throws IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (this.uriResolver != null) {
            factory.setURIResolver(this.uriResolver);
        } else {
            factory.setURIResolver((URIResolver)new FasterCachedResourceResolver(stylesheet.toString()));
        }
        Transformer transformer = factory.newTransformer(new StreamSource(stylesheet.openStream()));
        DocumentSource source = new DocumentSource(doc);
        StreamResult result = new StreamResult(out);
        transformer.transform((Source)source, result);
        out.flush();
    }

    public Document transform(Document doc, URL stylesheet) throws TransformerException, IOException {
        if (log.isInfoEnabled()) {
            log.debug((Object)("Transform document using : " + stylesheet));
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        if (this.uriResolver != null) {
            factory.setURIResolver(this.uriResolver);
        } else {
            factory.setURIResolver((URIResolver)new FasterCachedResourceResolver(stylesheet.toString()));
        }
        Transformer transformer = factory.newTransformer(new StreamSource(stylesheet.openStream()));
        DocumentSource source = new DocumentSource(doc);
        DocumentResult result = new DocumentResult();
        transformer.transform((Source)source, (Result)result);
        Document transformedDoc = result.getDocument();
        return transformedDoc;
    }

    protected String string(String s, int number) {
        String result = "";
        for (int i = 0; i < number; ++i) {
            result = result + s;
        }
        return result;
    }

    protected String enumtype(int i, String type) {
        String result = null;
        if ("arabic".equals(type)) {
            result = String.valueOf(i);
        } else if ("loweralpha".equals(type)) {
            result = String.valueOf((char)(97 + i));
        } else if ("upperalpha".equals(type)) {
            result = String.valueOf((char)(65 + i));
        } else if ("lowerroman".equals(type) || "upperroman".equals(type)) {
            String[] c = new String[]{"i", "v", "x", "l", "c", "d", "m"};
            int[] d = new int[]{1, 5, 10, 50, 100, 500, 1000};
            result = "";
            for (int a = 0; a < c.length; ++a) {
                result = this.string(c[a], i / d[a]) + result;
                i %= d[a];
            }
            if ("upperroman".equals(type)) {
                result = result.toUpperCase();
            }
        }
        return result;
    }

    protected int inlineLength(Element e) {
        int result = 0;
        LinkedList elems = new LinkedList();
        elems.addAll(e.content());
        while (elems.peek() != null) {
            Node elem = (Node)elems.poll();
            switch (elem.getNodeType()) {
                case 1: {
                    elems.addAll(((Element)elem).content());
                    if ("emphasis".equals(elem.getName())) {
                        result += 2;
                        break;
                    }
                    if ("strong".equals(elem.getName())) {
                        result += 4;
                        break;
                    }
                    if (!"literal".equals(elem.getName())) break;
                    result += 4;
                    break;
                }
                case 3: {
                    result += elem.getText().length();
                }
            }
        }
        return result;
    }

    @Override
    public void startDocument(Document doc) {
    }

    @Override
    public void endDocument(Document doc) {
    }

    @Override
    public void endElement(Element e) {
        Element parent;
        Node lastNode;
        boolean needNewLine = false;
        if ("section".equals(e.getName())) {
            --this.sectionLevel;
            needNewLine = true;
        } else if ("paragraph".equals(e.getName())) {
            this.newLine();
            needNewLine = true;
        } else if ("title".equals(e.getName())) {
            this.newLine();
            if (this.sectionLevel == 0) {
                this.write(this.string("=", this.inlineLength(e)));
            } else {
                String c = "-=-~'`^+:!\"#$%&*,./;|?@\\_[\\]{}<>()".substring(this.sectionLevel, this.sectionLevel + 1);
                this.write(this.string(c, this.inlineLength(e)));
            }
            this.newLine();
            needNewLine = true;
        } else if ("emphasis".equals(e.getName())) {
            this.write("*");
        } else if ("strong".equals(e.getName())) {
            this.write("**");
        } else if ("literal".equals(e.getName())) {
            this.write("``");
        } else if ("docinfo".equals(e.getName())) {
            needNewLine = true;
        } else if ("literal_block".equals(e.getName())) {
            --this.indent;
            this.newLine();
            needNewLine = true;
        } else if ("table".equals(e.getName())) {
            this.newLine();
            needNewLine = true;
        } else if ("bullet_list".equals(e.getName())) {
            needNewLine = true;
        } else if ("enumerated_list".equals(e.getName())) {
            needNewLine = true;
        } else if ("field_list".equals(e.getName())) {
            needNewLine = true;
        } else if ("field_body".equals(e.getName())) {
            --this.indent;
        } else if ("definition_list".equals(e.getName())) {
            needNewLine = true;
        } else if ("definition".equals(e.getName())) {
            --this.indent;
        } else if ("list_item".equals(e.getName())) {
            --this.indent;
        } else if ("author".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("authors".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("organization".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("address".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("contact".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("version".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("revision".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("status".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("date".equals(e.getName())) {
            this.newLine();
            --this.indent;
        } else if ("copyright".equals(e.getName())) {
            this.newLine();
            --this.indent;
        }
        if (needNewLine && (lastNode = (parent = e.getParent()).node(parent.nodeCount() - 1)) != e) {
            this.newLine();
        }
    }

    @Override
    public void startElement(Element e) {
        if ("section".equals(e.getName())) {
            ++this.sectionLevel;
        } else if ("title".equals(e.getName())) {
            if (this.sectionLevel == 0) {
                this.write(this.string("=", this.inlineLength(e)));
                this.newLine();
            }
        } else if ("paragraph".equals(e.getName())) {
            Element parent = e.getParent();
            if (!"list_item".equals(parent.getName()) && !"field_body".equals(parent.getName()) || parent.node(0) != e) {
                this.writeIndent();
            }
        } else if ("transition".equals(e.getName())) {
            this.write(this.string("-", 80));
            this.newLine();
            this.newLine();
        } else if ("emphasis".equals(e.getName())) {
            this.write("*");
        } else if ("strong".equals(e.getName())) {
            this.write("**");
        } else if ("literal".equals(e.getName())) {
            this.write("``");
        } else if ("author".equals(e.getName())) {
            this.write(":Author: ");
            ++this.indent;
        } else if ("authors".equals(e.getName())) {
            this.write(":Authors: ");
            ++this.indent;
        } else if ("organization".equals(e.getName())) {
            this.write(":Organization: ");
            ++this.indent;
        } else if ("address".equals(e.getName())) {
            this.write(":Address: ");
            ++this.indent;
        } else if ("contact".equals(e.getName())) {
            this.write(":Contact: ");
            ++this.indent;
        } else if ("version".equals(e.getName())) {
            this.write(":Version: ");
            ++this.indent;
        } else if ("revision".equals(e.getName())) {
            this.write(":Revision: ");
            ++this.indent;
        } else if ("status".equals(e.getName())) {
            this.write(":Status: ");
            ++this.indent;
        } else if ("date".equals(e.getName())) {
            this.write(":Date: ");
            ++this.indent;
        } else if ("copyright".equals(e.getName())) {
            this.write(":Copyright: ");
            ++this.indent;
        } else if ("field_name".equals(e.getName())) {
            this.writeIndent(":");
        } else if ("field_body".equals(e.getName())) {
            this.write(": ");
            ++this.indent;
        } else if ("classifier".equals(e.getName())) {
            this.write(" : ");
        } else if ("definition".equals(e.getName())) {
            this.newLine();
            ++this.indent;
        } else if ("literal_block".equals(e.getName())) {
            this.write("::");
            this.newLine();
            this.newLine();
            ++this.indent;
        } else if (!"table".equals(e.getName())) {
            if ("bullet_list".equals(e.getName())) {
                this.listType = "bullet_list";
            } else if ("enumerated_list".equals(e.getName())) {
                this.listType = "enumerated_list";
                this.enumStart = Integer.parseInt(e.attributeValue("start"));
            } else if ("list_item".equals(e.getName())) {
                if ("bullet_list".equals(this.listType)) {
                    this.writeIndent("- ");
                } else if ("enumerated_list".equals(this.listType)) {
                    this.writeIndent(this.enumtype(this.enumStart++, e.getParent().attributeValue("enumtype")) + ". ");
                }
                ++this.indent;
            }
        }
    }

    @Override
    public void text(Text t) {
        if ("literal_block".equals(t.getParent().getName())) {
            this.writeIndent(t.getText());
        } else {
            this.write(t.getText());
        }
    }

    protected void newLine() {
        this.write("\n");
    }

    protected void write(String text) {
        this.write(text, false);
    }

    protected void writeIndent() {
        this.write("", true);
    }

    protected void writeIndent(String text) {
        this.write(text, true);
    }

    protected void write(String text, boolean doIndent) {
        block4: {
            try {
                String blank = "";
                if (doIndent) {
                    blank = this.string("  ", this.indent);
                }
                this.out.write(blank);
                for (char c : text.toCharArray()) {
                    this.out.write(c);
                    if (c != '\n') continue;
                    this.out.write(blank);
                }
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"TODO untreated error", (Throwable)eee);
            }
        }
    }
}

