/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.jrst.JRSTConfigAction;
import org.nuiton.jrst.JRSTConfigOption;

public class JRSTConfig {
    private static Log log = LogFactory.getLog(JRSTConfig.class);

    private JRSTConfig() {
    }

    public static ApplicationConfig getConfig() {
        return JRSTConfig.getConfig(null, null, new String[0]);
    }

    public static ApplicationConfig getConfig(String[] args) {
        return JRSTConfig.getConfig(null, null, args);
    }

    public static ApplicationConfig getConfig(String configFilename) {
        return JRSTConfig.getConfig(null, configFilename, new String[0]);
    }

    public static ApplicationConfig getConfig(Properties props) {
        return JRSTConfig.getConfig(props, null, new String[0]);
    }

    public static ApplicationConfig getConfig(Properties props, String configFilename, String ... args) {
        ApplicationConfig conf;
        block2: {
            conf = new ApplicationConfig(props, configFilename);
            conf.loadDefaultOptions((ConfigOptionDef[])JRSTConfigOption.values());
            conf.loadActions((ConfigActionDef[])JRSTConfigAction.values());
            conf.addAlias("--console", new String[]{"--option", "console", "true"});
            conf.addAlias("-c", new String[]{"--option console true"});
            conf.addAlias("--force", new String[]{"--option", "force", "true"});
            conf.addAlias("--outFile", new String[]{"--option", "outFile"});
            conf.addAlias("-o", new String[]{"--option", "outFile"});
            conf.addAlias("--outType", new String[]{"--option", "outType"});
            conf.addAlias("-t", new String[]{"--option", "outType"});
            conf.addAlias("--xslFile", new String[]{"--option", "xslFile"});
            conf.addAlias("-x", new String[]{"--option", "xslFile"});
            conf.addAlias("-i", new String[]{"--intermediate", "intermediateFile"});
            conf.addAlias("--simple", new String[]{"--option", "simple", "true"});
            conf.addAlias("-s", new String[]{"--option", "simple", "true"});
            try {
                conf.parse(args);
            }
            catch (ArgumentsParserException eee) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't load wikitty configuration", (Throwable)eee);
            }
        }
        return conf;
    }

    public static void help() {
        System.out.println("JRST configuration and action");
        System.out.println("Options (set with --option <key> <value>:");
        for (JRSTConfigOption jRSTConfigOption : JRSTConfigOption.values()) {
            System.out.println("\t" + jRSTConfigOption.key + "(" + jRSTConfigOption.getDefaultValue() + ")\t:" + jRSTConfigOption.getDescription());
        }
        System.out.println("Actions:");
        for (Enum enum_ : JRSTConfigAction.values()) {
            System.out.println("\t" + Arrays.toString(((JRSTConfigAction)enum_).aliases) + "(" + ((JRSTConfigAction)enum_).getAction() + ")\t:" + ((JRSTConfigAction)enum_).getDescription());
        }
        System.exit(0);
    }
}

