/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jrst;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Visitor;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.jrst.JRSTConfig;
import org.nuiton.jrst.JRSTConfigOption;
import org.nuiton.jrst.JRSTGenerator;
import org.nuiton.jrst.JRSTResourceResolver;
import org.nuiton.jrst.JRSTToXmlStrategy;
import org.nuiton.jrst.JRSTToXmlStrategyDocutils;
import org.nuiton.jrst.JRSTToXmlStrategyJRSTReader;
import org.nuiton.jrst.JRSTUserAgent;
import org.nuiton.jrst.convertisor.DocUtils2RST;
import org.nuiton.jrst.legacy.JRSTReader;
import org.nuiton.jrst.ui.JRSTView;
import org.nuiton.util.Resource;
import org.nuiton.util.StringUtil;
import org.python.util.PythonInterpreter;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class JRST {
    public static final String UTF_8 = "UTF-8";
    public static final String DOCUTILS_LAUNCHER = "__run__.py";
    public static final String IMPORT_SCRIPT = "import __run__";
    public static final String WINDOWS_NAME = "win";
    public static final String OS_NAME = "os.name";
    public static final String BANG = "!";
    public static final String FILE_URI_PREFIX = "file:";
    protected static Log log = LogFactory.getLog(JRST.class);
    protected static final String RST_2_XHTML = "/xsl/rst2xhtml.xsl";
    protected static final String XSL_RST_2_XHTML_INNER_BODY_XSL = "/xsl/rst2xhtmlInnerBody.xsl";
    protected static final String RST_2_XDOC = "/xsl/rst2xdoc.xsl";
    protected static final String RST_2_DOCBOOK = "/xsl/dn2dbk.xsl";
    protected static final String DOCBOOK_2_XHTML = "/docbook/xhtml/docbook.xsl";
    protected static final String DOCBOOK_2_JAVAHELP = "/docbook/javahelp/javahelp.xsl";
    protected static final String DOCBOOK_2_HTMLHELP = "/docbook/htmlhelp/htmlhelp.xsl";
    protected static final String DOCBOOK_2_FO = "/docbook/fo/docbook.xsl";
    public static final String PATTERN_TYPE = "xml|xhtml|docbook|html|htmlInnerBody|xdoc|fo|pdf";
    public static final String TYPE_HTML = "html";
    public static final String TYPE_HTML_INNER_BODY = "htmlInnerBody";
    public static final String TYPE_XDOC = "xdoc";
    public static final String TYPE_DOCBOOK = "docbook";
    public static final String TYPE_XHTML = "xhtml";
    public static final String TYPE_JAVAHELP = "javahelp";
    public static final String TYPE_HTMLHELP = "htmlhelp";
    public static final String TYPE_ODT = "odt";
    public static final String TYPE_FO = "fo";
    public static final String TYPE_PDF = "pdf";
    public static final String TYPE_XML = "xml";
    protected static Map<String, String> stylesheets = new HashMap<String, String>();
    protected static Map<String, String> mimeType;

    public static void main(String ... args) throws Exception {
        I18n.init((I18nInitializer)new ClassPathI18nInitializer(), (Locale)Locale.UK);
        if (args.length == 0) {
            JRST.askOption();
        } else {
            List unparsed;
            ApplicationConfig config = JRSTConfig.getConfig(args);
            config.doAction(0);
            String xslList = JRSTConfigOption.XSL_FILE.getOption(config);
            if (xslList == null) {
                xslList = JRSTConfigOption.OUT_TYPE.getOption(config);
            }
            if ((unparsed = config.getUnparsed()).isEmpty()) {
                JRSTConfig.help();
            }
            File inputFile = new File((String)config.getUnparsed().get(0));
            File ouputFile = JRSTConfigOption.OUT_FILE.getOptionAsFile(config);
            Overwrite overwrite = Overwrite.NEVER;
            if (JRSTConfigOption.FORCE.getOptionAsBoolean(config)) {
                overwrite = Overwrite.ALLTIME;
            }
            boolean simpleGeneration = false;
            if (JRSTConfigOption.SIMPLE.getOptionAsBoolean(config)) {
                simpleGeneration = true;
            }
            JRST.generate(xslList, inputFile, ouputFile, overwrite, simpleGeneration);
        }
    }

    private static void askOption() throws SecurityException, NoSuchMethodException, IOException {
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            if (gs != null && gs.length > 0) {
                JRST.askOptionGraph();
            }
        }
        catch (HeadlessException e) {
            log.error((Object)"Can't generate document", (Throwable)e);
        }
    }

    protected static void askOptionGraph() throws SecurityException, NoSuchMethodException {
        JRSTView jrstView = new JRSTView();
        jrstView.pack();
        jrstView.setVisible(true);
    }

    public static void generate(String outputType, File fileIn, File fileOut, Overwrite overwrite, boolean simpleGeneration) throws Exception {
        if (fileOut != null && fileOut.exists() && (overwrite == Overwrite.NEVER || overwrite == Overwrite.IFNEWER && FileUtils.isFileNewer((File)fileIn, (File)fileOut))) {
            log.info((Object)("Don't generate file " + fileOut + ", because already exists"));
        } else {
            JRSTToXmlStrategy strategy = simpleGeneration ? new JRSTToXmlStrategyJRSTReader() : new JRSTToXmlStrategyDocutils();
            Document doc = strategy.generateRstToXml(fileIn, UTF_8);
            doc = JRST.generateXml(doc, outputType);
            if (outputType.equals(TYPE_PDF)) {
                JRST.generatePdf(doc, fileIn, fileOut);
            } else {
                JRST.generateFile(doc, fileOut);
            }
        }
    }

    public static void generatePdf(File fileIn, File fileOut, Overwrite overwrite, Document doc) throws Exception {
        if (fileOut != null && fileOut.exists() && (overwrite == Overwrite.NEVER || overwrite == Overwrite.IFNEWER && FileUtils.isFileNewer((File)fileIn, (File)fileOut))) {
            log.info((Object)("Don't generate file " + fileOut + ", because already exists"));
        } else {
            doc = JRST.generateXml(doc, TYPE_PDF);
            JRST.generatePdf(doc, fileIn, fileOut);
        }
    }

    public static Document generateSimpleDoc(File fileIn, String encoding) throws Exception {
        URL url = fileIn.toURI().toURL();
        InputStreamReader in = new InputStreamReader(url.openStream(), encoding);
        JRSTReader jrst = new JRSTReader();
        return jrst.read(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document generateDocutils(File in, String encoding) throws Exception {
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            URL resource = JRST.class.getResource("/__run__.py");
            String docutilsPath = resource.getPath().replaceAll(DOCUTILS_LAUNCHER, "");
            docutilsPath = docutilsPath.replaceAll(BANG, "");
            docutilsPath = docutilsPath.replaceAll(FILE_URI_PREFIX, "");
            PythonInterpreter interp = new PythonInterpreter();
            String commandImport = IMPORT_SCRIPT;
            interp.exec(commandImport);
            String filePath = in.getAbsolutePath();
            String property = System.getProperty(OS_NAME).toLowerCase();
            if (property.contains(WINDOWS_NAME)) {
                filePath = filePath.replaceAll("\\\\", "\\\\\\\\");
            }
            interp.setOut((OutputStream)out);
            String commandExec = String.format("__run__.exec_docutils('%s', '%s', '%s')", docutilsPath, TYPE_XML, filePath);
            interp.exec(commandExec);
            interp.cleanup();
            String xmlString = new String(out.toByteArray(), encoding);
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)xmlString);
            }
            catch (DocumentException e) {
                log.error((Object)"Error during the creation of the document", (Throwable)e);
            }
            Document document = doc;
            return document;
        }
    }

    public static Document generateXml(Document doc, String xslListOrOutType) throws IOException, TransformerException {
        String[] xsls;
        String xslList = stylesheets.get(xslListOrOutType);
        if (xslListOrOutType == null) {
            xslList = xslListOrOutType;
        }
        JRSTGenerator gen = new JRSTGenerator();
        for (String xsl : xsls = StringUtil.split((String)xslList, (String)",")) {
            File file = new File(xsl);
            URL stylesheet = file.exists() ? file.toURI().toURL() : Resource.getURL((String)xsl);
            if (stylesheet == null) {
                throw new FileNotFoundException("Can't find stylesheet: " + xsl);
            }
            gen.setUriResolver((URIResolver)((Object)new JRSTResourceResolver(xsl)));
            doc = gen.transform(doc, stylesheet);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateFile(Document doc, File fileOut) throws IOException {
        try (OutputStreamWriter writer = null;){
            FileOutputStream outputStream = new FileOutputStream(fileOut);
            writer = new OutputStreamWriter((OutputStream)outputStream, UTF_8);
            writer.write(doc.asXML());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePdf(Document result, File fileIn, File fileOut) throws Exception {
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(fileOut);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver(result.getEntityResolver());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(result.asXML().getBytes());
            org.w3c.dom.Document doc = builder.parse(inputStream);
            ITextRenderer renderer = new ITextRenderer();
            String absolutePath = fileIn.getParentFile().getAbsolutePath();
            JRSTUserAgent jrstUserAgent = new JRSTUserAgent(absolutePath);
            jrstUserAgent.setBaseURL(absolutePath);
            renderer.getSharedContext().setUserAgentCallback((UserAgentCallback)jrstUserAgent);
            jrstUserAgent.setSharedContext(renderer.getSharedContext());
            renderer.setDocument(doc, null);
            renderer.layout();
            renderer.createPDF((OutputStream)outputStream);
        }
    }

    public static String generateRST(Document doc) throws IOException {
        DocUtils2RST visitor = new DocUtils2RST();
        doc.accept((Visitor)visitor);
        String result = visitor.getResult();
        visitor.clear();
        return result;
    }

    static {
        stylesheets.put(TYPE_HTML, RST_2_XHTML);
        stylesheets.put(TYPE_HTML_INNER_BODY, XSL_RST_2_XHTML_INNER_BODY_XSL);
        stylesheets.put(TYPE_XDOC, RST_2_XDOC);
        stylesheets.put(TYPE_DOCBOOK, RST_2_DOCBOOK);
        stylesheets.put(TYPE_XHTML, "/xsl/dn2dbk.xsl,/docbook/xhtml/docbook.xsl");
        stylesheets.put(TYPE_JAVAHELP, "/xsl/dn2dbk.xsl,/docbook/javahelp/javahelp.xsl");
        stylesheets.put(TYPE_HTMLHELP, "/xsl/dn2dbk.xsl,/docbook/htmlhelp/htmlhelp.xsl");
        stylesheets.put(TYPE_FO, "/xsl/dn2dbk.xsl,/docbook/fo/docbook.xsl");
        stylesheets.put(TYPE_PDF, RST_2_XHTML);
        mimeType = new HashMap<String, String>();
        mimeType.put(TYPE_HTML, "text/html");
        mimeType.put(TYPE_HTML_INNER_BODY, "text/html");
        mimeType.put(TYPE_XDOC, "text/xml");
        mimeType.put(TYPE_DOCBOOK, "text/xml");
        mimeType.put(TYPE_XHTML, "text/html");
        mimeType.put(TYPE_JAVAHELP, "text/plain");
        mimeType.put(TYPE_HTMLHELP, "text/html");
        mimeType.put(TYPE_ODT, "application/vnd.oasis.opendocument.text");
        mimeType.put(TYPE_FO, "text/xml");
        mimeType.put(TYPE_PDF, "application/pdf");
    }

    public static enum Overwrite {
        NEVER,
        IFNEWER,
        ALLTIME;

    }
}

