package org.nuiton.jpa.api;

/*
 * #%L
 * Nuiton Jpa :: API
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;

/**
 * {@link JpaEntityIdFactory} used in generated code in entities.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class JpaEntityIdFactoryResolver implements JpaEntityIdFactory {

    protected static JpaEntityIdFactory factory;

    public static void setFactory(JpaEntityIdFactory factory) {
        JpaEntityIdFactoryResolver.factory = factory;
    }

    @Override
    public String newId(JpaEntity entity) {
        Preconditions.checkNotNull(factory, "No factory assigned");
        return factory.newId(entity);
    }

}
