/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.api;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jpa.api.JpaDao;
import org.nuiton.jpa.api.JpaEntity;

public abstract class AbstractJpaDao<E extends JpaEntity>
implements JpaDao<E> {
    protected EntityManager entityManager;

    public AbstractJpaDao(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected abstract Class<E> getEntityClass();

    @Override
    public E findById(String id) {
        JpaEntity entity = (JpaEntity)this.entityManager.find(this.getEntityClass(), (Object)id);
        return (E)entity;
    }

    @Override
    public List<E> findAll() {
        String simpleName = this.getEntityClass().getSimpleName();
        TypedQuery query = this.entityManager.createQuery("from " + simpleName, this.getEntityClass());
        return query.getResultList();
    }

    @Override
    public void persist(E entity) {
        this.entityManager.persist(entity);
    }

    @Override
    public E merge(E entity) {
        JpaEntity merge = (JpaEntity)this.entityManager.merge(entity);
        return (E)merge;
    }

    @Override
    public void remove(E entity) {
        this.entityManager.remove(entity);
    }

    @Override
    public boolean contains(E entity) {
        return this.entityManager.contains(entity);
    }

    public E findByProperty(String propertyName, Object value) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        E result = this.findByProperties(properties);
        return result;
    }

    public List<E> findAllByProperty(String propertyName, Object value) {
        TypedQuery<E> query = this.createQuery(propertyName, value, new Object[0]);
        List<E> result = this.findAll(query);
        return result;
    }

    public List<E> findAllByProperties(Map<String, Object> properties) {
        TypedQuery<E> query = this.createQuery(properties);
        List<E> results = this.findAll(query);
        return results;
    }

    public E findByProperties(Map<String, Object> properties) {
        TypedQuery<E> query = this.createQuery(properties);
        E result = this.findAnyOrNull(query);
        return result;
    }

    public E findContains(String propertyName, Object property) {
        TypedQuery<E> query = this.createQuery("From " + this.getEntityClass().getSimpleName() + " Where " + propertyName + " In elements(:K)");
        query.setParameter("K", property);
        return this.findAnyOrNull(query);
    }

    public List<E> findAllContains(String propertyName, Object property) {
        TypedQuery<E> query = this.createQuery("From " + this.getEntityClass().getSimpleName() + " Where " + propertyName + " In elements(:K)");
        query.setParameter("K", property);
        return this.findAll(query);
    }

    @Override
    public E newInstance() {
        JpaEntity newInstance;
        try {
            newInstance = (JpaEntity)this.getEntityClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return (E)newInstance;
    }

    protected TypedQuery<E> createQuery(String propertyName, Object propertyValue, Object ... others) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                propertyValue = others[i++];
                properties.put((String)name, propertyValue);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        return this.createQuery(properties);
    }

    protected TypedQuery<E> createQuery(Map<String, Object> properties) {
        return this.createQuery(this.getEntityClass(), properties);
    }

    protected <E> TypedQuery<E> createQuery(Class<E> type, String hql) {
        TypedQuery query = this.entityManager.createQuery(hql, type);
        return query;
    }

    protected <E> TypedQuery<E> createQuery(Class<E> type, String propertyName, Object propertyValue, Object ... others) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                propertyValue = others[i++];
                properties.put((String)name, propertyValue);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        return this.createQuery(type, properties);
    }

    protected <E> TypedQuery<E> createQuery(Class<E> type, Map<String, Object> properties) {
        LinkedList<String> whereClauses = new LinkedList<String>();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            String propertyName = property.getKey();
            Object propertyValue = property.getValue();
            if (propertyValue == null) {
                whereClauses.add(propertyName + " is null");
                continue;
            }
            whereClauses.add(propertyName + " = :" + propertyName);
        }
        String hql = "from " + this.getEntityClass().getSimpleName() + " where " + StringUtils.join(whereClauses, (String)" and ");
        TypedQuery<E> query = this.createQuery(type, hql);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Object propertyValue = property.getValue();
            if (propertyValue == null) continue;
            query.setParameter(property.getKey(), propertyValue);
        }
        return query;
    }

    protected TypedQuery<E> createQuery(String hql) {
        TypedQuery query = this.entityManager.createQuery(hql, this.getEntityClass());
        return query;
    }

    protected List<E> findAll(TypedQuery<E> query) {
        return query.getResultList();
    }

    protected E findUnique(TypedQuery<E> query) {
        return (E)((JpaEntity)query.getSingleResult());
    }

    protected E findAnyOrNull(TypedQuery<E> query) {
        List<E> all = this.findAll(query);
        JpaEntity onlyElement = null;
        if (!all.isEmpty()) {
            onlyElement = (JpaEntity)all.get(0);
        }
        return (E)onlyElement;
    }

    protected E findUniqueOrNull(TypedQuery<E> query) {
        List<E> all = this.findAll(query);
        JpaEntity onlyElement = null;
        if (!all.isEmpty()) {
            if (all.size() > 1) {
                throw new IllegalStateException("multiple results for query = " + query + " results = " + all);
            }
            onlyElement = (JpaEntity)all.get(0);
        }
        return (E)onlyElement;
    }
}

