package org.nuiton.jaxx.runtime.swing.editor;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.renderer.LocaleListCellRenderer;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class I18nEditor extends JPanel implements PropertyChangeListener, ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LOCALES = "locales";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_BORDER = "popupBorder";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    public static final String PROPERTY_RENDERER = "renderer";
    public static final String PROPERTY_SELECTED_LOCALE = "selectedLocale";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_ICON = "showIcon";
    public static final String PROPERTY_SHOW_POPUP_ICON = "showPopupIcon";
    public static final String PROPERTY_SHOW_POPUP_TEXT = "showPopupText";
    public static final String PROPERTY_SHOW_TEXT = "showText";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_ICON = "button.icon";
    public static final String BINDING_BUTTON_SELECTED = "button.selected";
    public static final String BINDING_BUTTON_TEXT = "button.text";
    public static final String BINDING_BUTTON_TOOL_TIP_TEXT = "button.toolTipText";
    public static final String BINDING_POPUP_BORDER = "popup.border";
    public static final String BINDING_RENDERER_SHOW_ICON = "renderer.showIcon";
    public static final String BINDING_RENDERER_SHOW_TEXT = "renderer.showText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVT08TQRSfVtrSPyDVhIQbCSoaYDd4MCYgIkUEUoQAMYQedNod2yXDzrgza5cLBw/e/AIevHoxfAfiycSLV76DCR/BN7PbbottLbaH3e2b937v9/7sb7/9RgnholnmVg3HsyVzjCPs+4brOdI+Jsbms4OD7fIRqchVIiquzSVzUfCLxVG8hLJW0y4kMkpFQDIDJFMhmSGSWWDHnDnEaQFaKKKMkCeUiBohUqL7XYMrQph7Tc8Fn3tumKsj6065fn6cv4iR1c9xhHwO9PNQ9sw1AKKqh4ooblsS3Soe4ffYpNipAjnXdqpQ0IiyFSgW4iU+Ju/QKUoVUZJjF8Akmvuv9mg4DeVziVIV5kiNZnajL+pAxiAWnLjGxvxj57l+5FyjJAGjhh2LEleiR9fEWA8CI6jbglBYD2LtM0b3bb5PfKA2ptpgqNYYQWuigHGHyb2/Y9RpPvLKcsY9vsJcS7GcUHB+yKmsjUZwFkUMixqrB9nzUfYVyECwc8VtA3qo/k9E9hFl31FJG2w6HnaIzGmqr2xhlym5cpairIJhbSUa1Zw8aVOjaAsZuYw2GljUro3eBZ7a1EIe1giKVi150ntwDccQQqUsEEp3Q7PCSzdhE7oCGE1rmzd1vVvE8aL8Ge1YxGVCYf/bvLVRuc00vZNlTwK9K+Pb3GfVKiUr+qydR8oGdr7q1lzv6pQsBQAvXAb8OLzM97qFgHgYkXhE73GshBKup4cz1V23lPTsglcgOlPdRUel0Y4fzk7dr/XLi4bS5IDc5L+iWkQVXnvuMg5DthW3m4HMqH0wtzBfKKF0sDFacad7M98LPYE9sMhHm7WORQ3QEqmL8+/jb37dQPE1lKEMW2tY+W+gtKy50DFGLZ8/XdbkcvVhuI4pmjBcik8YjACNLlpY4skyzA5Gs+RDl6Z7d6lJ6mz78seXT3fPG52KAcc7/URG3UocoqTtUNshWpVDwe2owlkuiGexSE076WtM3TM8XPlFfV3uVH+bjhR8T91WdQ3qaU3jPOgXpyE5A+AkA1nsgTLbB0qKOBhUTH3dFoO2TmIJAg5vMlnqDGv2ATskwwIP/x8j95ZVPLGDbfj6WT2wHvaBldZYONTrAYCG7N4b0A/GcOMDMBCOMr8ekElWtn+Pe0D9AcI2WDw5CgAA";
    private static final Log log = LogFactory.getLog(I18nEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToggleButton button;
    protected I18nEditor content;
    protected I18nEditorHandler handler;
    protected JAXXButtonGroup indexes;
    protected List<Locale> locales;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected Border popupBorder;
    protected JLabel popupLabel;
    protected Boolean popupVisible;
    protected LocaleListCellRenderer renderer;
    protected Locale selectedLocale;
    protected String selectedToolTipText;
    protected Boolean showIcon;
    protected Boolean showPopupIcon;
    protected Boolean showPopupText;
    protected Boolean showText;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String DEFAULT_SELECTED_TOOLTIP = n("i18neditor.selected");
    public static final String DEFAULT_NOT_SELECTED_TOOLTIP = n("i18neditor.unselected");
    public static final String LOCALES_PROPERTY = "locales";
    public static final String SELECTED_LOCALE_PROPERTY = "selectedLocale";
    public static final String SHOW_ICON_PROPERTY = "showIcon";
    public static final String SHOW_TEXT_PROPERTY = "showText";
    public static final String SHOW_POPUP_ICON_PROPERTY = "showPopupIcon";
    public static final String SHOW_POPUP_TEXT_PROPERTY = "showPopupText";
    public static final String POPUP_BORDER_PROPERTY = "popupBorder";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    
    
    
    
    void $afterCompleteSetup() {
        handler.$afterCompleteSetup();
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        handler.propertyChange(evt);
    }
    
    @Override
    public void actionPerformed(ActionEvent event) {
        handler.actionPerformed(event);
    }
    
    public void loadI18nBundles() {
        handler.loadI18nBundles();
    }
    
    protected void rebuildPopup() {
        handler.rebuildPopup();
    }
    
    protected String getTip(Locale l) {
        return handler.getTip(l);
    }
    
    protected String getSelectedTip(Locale l) {
        return handler.getSelectedTip(l);
    }
    
    protected String getNotSelectedTip(Locale l) {
        return handler.getNotSelectedTip(l);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public I18nEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public I18nEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public I18nEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public I18nEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public I18nEditor() {
        $initialize();
    }

    public I18nEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public I18nEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public I18nEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__content(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        button.requestFocus();
    }

    public void doFocusLost__on__content(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (event.getStateChange()  == ItemEvent.SELECTED) { setPopupVisible(true); } else { popupVisible = false; }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        button.setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        log.info(indexes.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButton getButton() {
        return button;
    }

    public I18nEditorHandler getHandler() {
        return handler;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public List<Locale> getLocales() {
        return locales;
    }

    public String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public Border getPopupBorder() {
        return popupBorder;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public Boolean getPopupVisible() {
        return popupVisible;
    }

    public LocaleListCellRenderer getRenderer() {
        return renderer;
    }

    public Locale getSelectedLocale() {
        return selectedLocale;
    }

    public String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public Boolean getShowIcon() {
        return showIcon;
    }

    public Boolean getShowPopupIcon() {
        return showPopupIcon;
    }

    public Boolean getShowPopupText() {
        return showPopupText;
    }

    public Boolean getShowText() {
        return showText;
    }

    public Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    public Boolean isShowIcon() {
        return showIcon !=null && showIcon;
    }

    public Boolean isShowPopupIcon() {
        return showPopupIcon !=null && showPopupIcon;
    }

    public Boolean isShowPopupText() {
        return showPopupText !=null && showPopupText;
    }

    public Boolean isShowText() {
        return showText !=null && showText;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLocales(List<Locale> locales) {
        List<Locale> oldValue = this.locales;
        this.locales = locales;
        firePropertyChange(PROPERTY_LOCALES, oldValue, locales);
    }

    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = notSelectedToolTipText;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, notSelectedToolTipText);
    }

    public void setPopupBorder(Border popupBorder) {
        Border oldValue = this.popupBorder;
        this.popupBorder = popupBorder;
        firePropertyChange(PROPERTY_POPUP_BORDER, oldValue, popupBorder);
    }

    public void setPopupVisible(Boolean popupVisible) {
        Boolean oldValue = this.popupVisible;
        this.popupVisible = popupVisible;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, popupVisible);
    }

    public void setRenderer(LocaleListCellRenderer renderer) {
        LocaleListCellRenderer oldValue = this.renderer;
        this.renderer = renderer;
        firePropertyChange(PROPERTY_RENDERER, oldValue, renderer);
    }

    public void setSelectedLocale(Locale selectedLocale) {
        Locale oldValue = this.selectedLocale;
        this.selectedLocale = selectedLocale;
        firePropertyChange(PROPERTY_SELECTED_LOCALE, oldValue, selectedLocale);
    }

    public void setSelectedToolTipText(String selectedToolTipText) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = selectedToolTipText;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, selectedToolTipText);
    }

    public void setShowIcon(Boolean showIcon) {
        Boolean oldValue = this.showIcon;
        this.showIcon = showIcon;
        firePropertyChange(PROPERTY_SHOW_ICON, oldValue, showIcon);
    }

    public void setShowPopupIcon(Boolean showPopupIcon) {
        Boolean oldValue = this.showPopupIcon;
        this.showPopupIcon = showPopupIcon;
        firePropertyChange(PROPERTY_SHOW_POPUP_ICON, oldValue, showPopupIcon);
    }

    public void setShowPopupText(Boolean showPopupText) {
        Boolean oldValue = this.showPopupText;
        this.showPopupText = showPopupText;
        firePropertyChange(PROPERTY_SHOW_POPUP_TEXT, oldValue, showPopupText);
    }

    public void setShowText(Boolean showText) {
        Boolean oldValue = this.showText;
        this.showText = showText;
        firePropertyChange(PROPERTY_SHOW_TEXT, oldValue, showText);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContent() {
        add(renderer);
        add(button, BorderLayout.CENTER);
    }

    protected void addChildrenToPopup() {
        popup.add(popupLabel);
    }

    protected void createButton() {
        $objectMap.put("button", button = new JToggleButton());
        
        button.setName("button");
        button.setFocusPainted(false);
        button.setFocusable(true);
        button.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__button"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new I18nEditorHandler(this));
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createLocales() {
        $objectMap.put("locales", locales = null);
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupBorder() {
        $objectMap.put("popupBorder", popupBorder = new TitledBorder(t("i18neditor.popup.title")));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
        popupLabel.setEnabled(false);
        popupLabel.setText(t("i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = Boolean.FALSE);
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = new LocaleListCellRenderer(showIcon , showText));
        
        renderer.setName("renderer");
    }

    protected void createSelectedLocale() {
        $objectMap.put("selectedLocale", selectedLocale = Locale.getDefault());
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowIcon() {
        $objectMap.put("showIcon", showIcon = Boolean.TRUE);
    }

    protected void createShowPopupIcon() {
        $objectMap.put("showPopupIcon", showPopupIcon = Boolean.TRUE);
    }

    protected void createShowPopupText() {
        $objectMap.put("showPopupText", showPopupText = Boolean.TRUE);
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = Boolean.TRUE);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        content = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("content", content);
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupBorder();
        createShowText();
        createShowIcon();
        createShowPopupText();
        createShowPopupIcon();
        createPopupVisible();
        createLocales();
        createSelectedLocale();
        createRenderer();
        createPopup();
        createPopupLabel();
        createButton();
        createIndexes();
        // inline creation of content
        setName("content");
        setLayout(new BorderLayout());
        content.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__content"));
        content.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__content"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RENDERER_SHOW_ICON, true ,"showIcon") {
        
            @Override
            public void processDataBinding() {
                renderer.setShowIcon(isShowIcon());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RENDERER_SHOW_TEXT, true ,"showText") {
        
            @Override
            public void processDataBinding() {
                renderer.setShowText(isShowText());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPUP_BORDER, true ,"popupBorder") {
        
            @Override
            public void processDataBinding() {
                popup.setBorder(getPopupBorder());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_ICON, true ,"selectedLocale") {
        
            @Override
            public void processDataBinding() {
                button.setIcon(renderer.getIcon(getSelectedLocale()));
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (popup != null) {
                    $bindingSources.put("popup", popup);
                    popup.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (popup != null) {
                    button.setSelected(popup.isVisible());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (popup != null) {
                    JPopupMenu $target = (JPopupMenu) $bindingSources.remove("popup");
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ComponentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_TEXT, true ,"selectedLocale") {
        
            @Override
            public void processDataBinding() {
                button.setText(t(SwingUtil.getStringValue(renderer.getText(getSelectedLocale()))));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_TOOL_TIP_TEXT, true ,"selectedLocale") {
        
            @Override
            public void processDataBinding() {
                button.setToolTipText(t(getTip(getSelectedLocale())));
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToContent();
        addChildrenToPopup();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}