/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing.unified;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingListValidatorDataLocator;
import org.nuiton.jaxx.validator.swing.unified.UnifiedValidatorMessage;
import org.nuiton.jaxx.validator.swing.unified.UnifiedValidatorMessageTableModel;

public class UnifiedValidatorMessageTableMouseListener
extends MouseAdapter {
    private static final Log log = LogFactory.getLog(UnifiedValidatorMessageTableMouseListener.class);
    public static final String HIGHLIGHT_ERROR_PROPERTY = "highlightError";
    protected final PropertyChangeSupport pcs;
    protected final JTable editor;
    protected final SwingListValidatorDataLocator<Object> dataLocator;

    public UnifiedValidatorMessageTableMouseListener(JTable editor, SwingListValidatorDataLocator dataLocator) {
        this.editor = editor;
        this.dataLocator = dataLocator;
        this.pcs = new PropertyChangeSupport(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {
            UnifiedValidatorMessage entry = this.getSelectedMessage(e);
            if (entry == null) {
                return;
            }
            if (entry.isSimpleValidator()) {
                JComponent component = entry.getEditor();
                if (component != null) {
                    this.pcs.firePropertyChange(HIGHLIGHT_ERROR_PROPERTY, null, entry);
                    if (component.isVisible()) {
                        component.requestFocus();
                    }
                }
            } else if (this.dataLocator.acceptType(entry.getBean().getClass())) {
                Pair<Integer, Integer> cell = this.dataLocator.locateDataCell(this.editor.getModel(), entry.getBean(), entry.getField());
                SwingUtil.editCell((JTable)this.editor, (int)((Integer)cell.getLeft()), (int)((Integer)cell.getRight()));
            }
        }
    }

    protected UnifiedValidatorMessage getSelectedMessage(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        if (!(table.getModel() instanceof UnifiedValidatorMessageTableModel)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("model must be a " + UnifiedValidatorMessageTableModel.class + ", but was " + table.getModel()));
            }
            return null;
        }
        UnifiedValidatorMessageTableModel model = (UnifiedValidatorMessageTableModel)table.getModel();
        int index = table.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            return null;
        }
        if (table.getRowSorter() != null) {
            index = table.getRowSorter().convertRowIndexToModel(index);
        }
        UnifiedValidatorMessage entry = model.getRow(index);
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected index: " + index + " : error: " + entry));
        }
        return entry;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

