/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.validator.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.validator.swing.SwingListValidatorMessage;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.list.BeanListValidator;
import org.nuiton.validator.bean.list.BeanListValidatorEvent;
import org.nuiton.validator.bean.list.BeanListValidatorListener;

public class SwingListValidatorMessageTableModel
extends AbstractTableModel
implements BeanListValidatorListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SwingListValidatorMessageTableModel.class);
    public static final String[] columnNames = new String[]{"validator.scope", "validator.bean", "validator.field", "validator.message"};
    public static final Class<?>[] columnClasses = new Class[]{NuitonValidatorScope.class, Object.class, String.class, String.class};
    protected final transient List<BeanListValidator<?>> validators;
    protected final List<SwingListValidatorMessage> data = Lists.newArrayList();

    public SwingListValidatorMessageTableModel() {
        this.validators = Lists.newArrayList();
    }

    public void registerValidator(BeanListValidator<?> validator) {
        Preconditions.checkState((!this.validators.contains(validator) ? 1 : 0) != 0, (Object)("Validator " + validator + " is already registred in " + this));
        this.validators.add(validator);
        validator.addBeanListValidatorListener((BeanListValidatorListener)this);
    }

    public void clear() {
        int i = this.data.size() + this.data.size();
        if (i > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, i - 1);
        }
    }

    public void clearValidators() {
        for (BeanListValidator<?> v : this.validators) {
            v.removeBeanListValidatorListener((BeanListValidatorListener)this);
        }
        this.validators.clear();
    }

    public SwingListValidatorMessage getRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        return this.data.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        return columnClasses[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)column);
        return columnNames[column];
    }

    public void onFieldChanged(BeanListValidatorEvent event) {
        boolean mustDel;
        String[] toDelete = event.getMessagesToDelete();
        String[] toAdd = event.getMessagesToAdd();
        String field = event.getField();
        Object bean = event.getBean();
        NuitonValidatorScope scope = event.getScope();
        boolean mustAdd = toAdd != null && toAdd.length > 0;
        boolean bl = mustDel = toDelete != null && toDelete.length > 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)"----------------------------------------------------------");
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toAdd     " + mustAdd));
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toDelete  " + mustDel));
        }
        BeanListValidator validator = (BeanListValidator)event.getSource();
        if (mustDel) {
            this.removeMessages(validator, bean, field, scope, !mustAdd, toDelete);
        }
        if (mustAdd) {
            this.addMessages(validator, bean, field, scope, true, toAdd);
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        SwingListValidatorMessage row = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return row.getScope();
        }
        if (columnIndex == 1) {
            return row.getBean();
        }
        if (columnIndex == 2) {
            return row.getField();
        }
        if (columnIndex == 3) {
            return row.getMessage();
        }
        return null;
    }

    protected void addMessages(BeanListValidator<?> validator, Object bean, String fieldName, NuitonValidatorScope scope, boolean sort, String ... messages) {
        JComponent editor = null;
        for (String error : messages) {
            SwingListValidatorMessage row = new SwingListValidatorMessage(validator, bean, fieldName, error, scope, editor);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void removeMessages(BeanListValidator<?> validator, Object bean, String fieldName, NuitonValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SwingListValidatorMessage error = this.data.get(i);
            if (!validator.equals((Object)error.getValidator()) || error.getScope() != scope || error.getBean() != bean || !error.getField().equals(fieldName) || !messagesToDel.contains(error.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }
}

