/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.JAXXToggleButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.action.AbstractActionConfigurationResolver;
import org.nuiton.jaxx.action.ActionConfigConfigurationResolver;
import org.nuiton.jaxx.action.ActionConfigurationResolver;
import org.nuiton.jaxx.action.ActionFactory;
import org.nuiton.jaxx.action.ActionProvider;
import org.nuiton.jaxx.action.MyAbstractAction;
import org.nuiton.jaxx.action.SelectActionConfigConfigurationResolver;
import org.nuiton.jaxx.action.ToggleActionConfigConfigurationResolver;
import org.nuiton.util.Resource;

public class ActionFactoryFromProvider<A extends MyAbstractAction>
implements ActionFactory<A> {
    protected static Log log = LogFactory.getLog(ActionFactoryFromProvider.class);
    protected Class<A> baseImpl;
    private Map<String, Class<? extends MyAbstractAction>> impls;
    private Map<String, A> cache;
    protected final ActionConfigConfigurationResolver actionConfigInitializer;
    protected final ToggleActionConfigConfigurationResolver toggleActionConfigInitializer;
    protected final SelectActionConfigConfigurationResolver selectActionConfigInitializer;
    protected List<AbstractActionConfigurationResolver> configurationResolvers;

    public static <A extends MyAbstractAction> ActionFactory<A> newInstance(Class<A> klazz) {
        return new ActionFactoryFromProvider<A>(klazz);
    }

    protected ActionFactoryFromProvider(Class<A> baseImpl) {
        this.baseImpl = baseImpl;
        this.impls = this.init();
        this.cache = new TreeMap<String, A>();
        this.configurationResolvers = new ArrayList<AbstractActionConfigurationResolver>();
        this.toggleActionConfigInitializer = this.registerInitializer(ToggleActionConfigConfigurationResolver.class);
        this.actionConfigInitializer = this.registerInitializer(ActionConfigConfigurationResolver.class);
        this.selectActionConfigInitializer = this.registerInitializer(SelectActionConfigConfigurationResolver.class);
    }

    @Override
    public Class<A> getBaseClass() {
        return this.baseImpl;
    }

    @Override
    public void resetCache() {
        this.cache.clear();
    }

    @Override
    public void loadActions(JAXXObject ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for ui " + ui.getClass()));
        }
        for (Map.Entry<String, Class<MyAbstractAction>> entry : this.implsEntrySet()) {
            A action;
            JComponent component;
            String actionKey = entry.getKey();
            Object comp = ui.getObjectById(actionKey);
            if (comp == null || !(comp instanceof AbstractButton) && !(comp instanceof JComboBox)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("detect action " + actionKey));
            }
            if (comp instanceof AbstractButton) {
                Boolean value;
                component = (AbstractButton)comp;
                action = this.newAction(actionKey, component);
                ((AbstractButton)component).setAction((Action)action);
                if (component instanceof JAXXToggleButton) {
                    JAXXToggleButton glueComponent = (JAXXToggleButton)component;
                    glueComponent.setIcon((Icon)((MyAbstractAction)action).getValue("SmallIcon"));
                    Integer integer = (Integer)((MyAbstractAction)action).getValue("MnemonicKey");
                    if (integer != null) {
                        glueComponent.setNormalMnemonic(integer.intValue());
                    }
                    glueComponent.setSelectedIcon((Icon)((MyAbstractAction)action).getValue("SmallIcon2"));
                    integer = (Integer)((MyAbstractAction)action).getValue("MnemonicKey2");
                    if (integer != null) {
                        glueComponent.setGlueMnemonic(integer.intValue());
                    }
                    glueComponent.setGlueText((String)((MyAbstractAction)action).getValue("Name2"));
                    glueComponent.setGlueTooltipText((String)((MyAbstractAction)action).getValue("ShortDescription2"));
                    glueComponent.setNormalText((String)((MyAbstractAction)action).getValue("Name"));
                    glueComponent.setNormalTooltipText((String)((MyAbstractAction)action).getValue("ShortDescription"));
                }
                ((AbstractButton)component).setHideActionText((value = (Boolean)((MyAbstractAction)action).getValue("hideActionText")) != null && value != false);
                ((MyAbstractAction)action).setEnabled(true);
                continue;
            }
            component = (JComboBox)comp;
            action = this.newAction(actionKey, component);
            ((JComboBox)component).setAction((Action)action);
            Integer val = (Integer)((MyAbstractAction)action).getValue("selectedIndex");
            if (val == null || val == -1 || val >= ((JComboBox)component).getItemCount() || val.intValue() == ((JComboBox)component).getSelectedIndex()) continue;
            ((JComboBox)component).setSelectedIndex(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A newAction(String actionKey, JComponent component) {
        ActionConfigurationResolver configurationResolver;
        A result = this.getActionFromCache(actionKey);
        if (result != null) {
            return result;
        }
        try {
            result = this.newActionInstance(actionKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create <" + actionKey + " : " + result + ">"));
        }
        if ((configurationResolver = this.resolveActionConfiguration((MyAbstractAction)result)) != null) {
            configurationResolver.applyConfiguration(component, (MyAbstractAction)result);
        }
        try {
            if (configurationResolver != null) {
                if (AbstractButton.class.isAssignableFrom(configurationResolver.getComponentImpl())) {
                    this.finalizeNewAction((AbstractButton)component, (MyAbstractAction)result, (ActionConfigurationResolver<?, ?>)configurationResolver);
                }
                if (JComboBox.class.isAssignableFrom(configurationResolver.getComponentImpl())) {
                    this.finalizeNewAction((JComboBox)component, (MyAbstractAction)result, (ActionConfigurationResolver<?, ?>)configurationResolver);
                }
                A a = result;
                return a;
            }
            if (component == null || component instanceof AbstractButton) {
                this.finalizeNewAction((AbstractButton)component, (MyAbstractAction)result, (ActionConfigurationResolver<?, ?>)configurationResolver);
                A a = result;
                return a;
            }
            if (component instanceof JComboBox) {
                this.finalizeNewAction((JComboBox)component, (MyAbstractAction)result, (ActionConfigurationResolver<?, ?>)configurationResolver);
            }
        }
        finally {
            this.cache.put(actionKey, result);
        }
        return result;
    }

    @Override
    public A newAction(String actionKey) {
        return this.newAction(actionKey, null);
    }

    @Override
    public String[] getActionNames() {
        return this.impls.keySet().toArray(new String[this.impls.size()]);
    }

    @Override
    public Set<Map.Entry<String, Class<? extends MyAbstractAction>>> implsEntrySet() {
        return this.impls.entrySet();
    }

    @Override
    public Set<Map.Entry<String, A>> cacheEntrySet() {
        return this.cache.entrySet();
    }

    @Override
    public void fireAction(String actionKey, Object source, JComponent component) {
        A action = this.newAction(actionKey, component);
        this.fireAction0(actionKey, source, action);
    }

    @Override
    public void fireAction(String actionKey, Object source) {
        this.fireAction(actionKey, source, null);
    }

    public A getActionFromCache(String actionKey) {
        this.checkRegistredAction(actionKey);
        MyAbstractAction action = null;
        if (this.cache.containsKey(actionKey)) {
            action = (MyAbstractAction)this.cache.get(actionKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("use cache action " + action));
            }
        }
        return (A)action;
    }

    @Override
    public void dispose() {
        if (log.isInfoEnabled()) {
            log.info((Object)this);
        }
        for (String actionKey : this.getActionNames()) {
            A action = this.getActionFromCache(actionKey);
            if (action == null) continue;
            ((MyAbstractAction)action).disposeUI();
        }
        this.resetCache();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.resetCache();
        this.impls.clear();
    }

    protected void finalizeNewAction(AbstractButton component, MyAbstractAction action, ActionConfigurationResolver<?, ?> configurationResolver) {
        if (configurationResolver == null && component != null) {
            action.putValue("ActionCommandKey", component.getName());
            action.putValue("ShortDescription", component.getToolTipText());
            action.putValue("SmallIcon", component.getIcon());
            action.putValue("Name", component.getText());
            action.putValue("MnemonicKey", component.getMnemonic());
            action.putValue("hideActionText", component.getHideActionText());
            if (component instanceof JAXXToggleButton) {
                JAXXToggleButton glueComponent = (JAXXToggleButton)component;
                action.putValue("ShortDescription", glueComponent.getNormalTooltipText());
                action.putValue("Name", glueComponent.getNormalText());
                action.putValue("SmallIcon", glueComponent.getIcon());
                action.putValue("MnemonicKey", glueComponent.getNormalMnemonic());
                action.putValue("ShortDescription2", glueComponent.getGlueTooltipText());
                action.putValue("Name2", glueComponent.getGlueText());
                action.putValue("SmallIcon2", glueComponent.getSelectedIcon());
                action.putValue("MnemonicKey2", glueComponent.getGlueMnemonic());
            }
        }
        String text = (String)action.getValue("Name");
        Integer mnemo = (Integer)action.getValue("MnemonicKey");
        if (mnemo != null && mnemo != 0) {
            int pos = text.indexOf((char)mnemo.intValue());
            if (pos == -1) {
                pos = text.indexOf(Character.toLowerCase((char)mnemo.intValue()));
            }
            action.putValue("SwingDisplayedMnemonicIndexKey", pos);
        }
    }

    protected void finalizeNewAction(JComboBox component, MyAbstractAction action, ActionConfigurationResolver<?, ?> configurationResolver) {
        if (configurationResolver == null) {
            action.putValue("ActionCommandKey", component.getName());
            action.putValue("ShortDescription", component.getToolTipText());
        }
    }

    protected ActionConfigurationResolver resolveActionConfiguration(MyAbstractAction action) {
        for (AbstractActionConfigurationResolver resolver : this.configurationResolvers) {
            if (resolver.resolveConfiguration(action) == null) continue;
            return resolver;
        }
        return null;
    }

    protected <I extends AbstractActionConfigurationResolver> I registerInitializer(Class<I> initizalizer) {
        try {
            AbstractActionConfigurationResolver instance = (AbstractActionConfigurationResolver)initizalizer.newInstance();
            this.configurationResolvers.add(instance);
            return (I)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void fireAction0(String actionKey, Object source, A action) {
        if (action == null) {
            log.warn((Object)("could not find action " + actionKey));
            return;
        }
        ActionEvent event = new ActionEvent(source, 1001, actionKey);
        ((MyAbstractAction)action).actionPerformed(event);
    }

    protected void checkRegistredAction(String actionKey) {
        if (!this.impls.containsKey(actionKey)) {
            throw new IllegalStateException("can not find a registered action for key " + actionKey);
        }
    }

    protected A newActionInstance(String actionKey) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<? extends MyAbstractAction> klazz = this.impls.get(actionKey);
        MyAbstractAction result = klazz.getConstructor(String.class).newInstance(actionKey);
        result.putValue("ActionCommandKey", actionKey);
        if (!this.getBaseClass().isAssignableFrom(klazz)) {
            result = (MyAbstractAction)this.getBaseClass().getConstructor(MyAbstractAction.class).newInstance(result);
        }
        return (A)result;
    }

    @Override
    public Map<String, Class<? extends MyAbstractAction>> init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start loading " + this));
        }
        URLClassLoader newCL = ActionFactoryFromProvider.fixClassLoader(this.getClass());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (newCL != null) {
            Thread.currentThread().setContextClassLoader(newCL);
        }
        ServiceLoader<ActionProvider> loader = ServiceLoader.load(ActionProvider.class);
        TreeMap<String, Class<? extends MyAbstractAction>> cache = new TreeMap<String, Class<? extends MyAbstractAction>>();
        for (ActionProvider actionProvider : loader) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("found " + actionProvider));
            }
            cache.putAll(actionProvider.getClasses());
        }
        if (newCL != null) {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return cache;
    }

    public static URLClassLoader fixClassLoader(Class<?> klass) {
        URLClassLoader cl;
        ClassLoader l = klass.getClassLoader();
        if (!(l instanceof URLClassLoader)) {
            log.warn((Object)("using cl is not a URL classloader " + l));
            cl = new URLClassLoader(new URL[0], l);
        } else {
            cl = (URLClassLoader)l;
        }
        if (cl.getURLs().length == 1) {
            try {
                URL[] urls = Resource.getClassPathURLsFromJarManifest((URL)cl.getURLs()[0]);
                URLClassLoader newCL = new URLClassLoader(urls);
                if (log.isTraceEnabled()) {
                    for (URL url : newCL.getURLs()) {
                        log.trace((Object)url);
                    }
                }
                return newCL;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

