/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.editor;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.nuiton.jaxx.runtime.swing.editor.EnumEditor;

public class MyDefaultCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    protected boolean requireSelect = true;

    public static TableCellEditor newTextEditor() {
        return new MyDefaultCellEditor(new JTextField());
    }

    public static TableCellEditor newBooleanEditor() {
        return new MyDefaultCellEditor(new JCheckBox());
    }

    public static TableCellEditor newListEditor() {
        return MyDefaultCellEditor.newListEditor(new JComboBox());
    }

    public static TableCellEditor newListEditor(JComboBox editor) {
        return new MyDefaultCellEditor(editor);
    }

    public static TableCellEditor newEnumEditor(EnumEditor<?> editor) {
        return new MyDefaultCellEditor(editor){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getCellEditorValue() {
                Object value = super.getCellEditorValue();
                value = value != null ? Integer.valueOf(((Enum)value).ordinal()) : Integer.valueOf(-1);
                return value;
            }
        };
    }

    public static TableCellEditor newBooleanEditor(Icon icon) {
        return new MyDefaultCellEditor(new JCheckBox(icon));
    }

    public static TableCellEditor newBooleanEditor(Icon icon, boolean requireSelect) {
        TableCellEditor cellEditor = MyDefaultCellEditor.newBooleanEditor(icon);
        ((MyDefaultCellEditor)cellEditor).setRequireSelect(requireSelect);
        return cellEditor;
    }

    public static TableCellEditor newBooleanEditor(boolean requireSelect) {
        TableCellEditor cellEditor = MyDefaultCellEditor.newBooleanEditor();
        ((MyDefaultCellEditor)cellEditor).setRequireSelect(requireSelect);
        return cellEditor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!isSelected && this.requireSelect) {
            return null;
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean isRequireSelect() {
        return this.requireSelect;
    }

    public void setRequireSelect(boolean requireSelect) {
        this.requireSelect = requireSelect;
    }

    protected MyDefaultCellEditor(JTextField textField) {
        super(textField);
        this.setClickCountToStart(1);
    }

    protected MyDefaultCellEditor(JCheckBox checkBox) {
        super(checkBox);
        this.setClickCountToStart(1);
    }

    protected MyDefaultCellEditor(JComboBox comboBox) {
        super(comboBox);
        this.setClickCountToStart(1);
    }
}

