/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: Decorator.java 2086 2010-09-11 19:39:49Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.2/jaxx-runtime/src/main/java/jaxx/runtime/decorator/Decorator.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.decorator;

import java.io.Serializable;

/**
 * A simple contract to define a String decorator on any java object.
 *
 * @author tchemit <chemit@codelutin.com>
 * @param <O> the type of data to decorate
 * @since 1.7.2 (was previously {@code jaxx.runtime.Decorator})
 */
public abstract class Decorator<O> implements Serializable {

    private static final long serialVersionUID = -1L;

    /** Type of the data to decorate */
    protected final Class<O> internalClass;

    public Decorator(Class<O> internalClass) throws NullPointerException {
        if (internalClass == null) {
            throw new NullPointerException("internalClass can not be null.");
        }
        this.internalClass = internalClass;
    }

    /**
     * @param bean the bean to decorate
     * @return the string value of the given bean
     */
    public abstract String toString(Object bean);

    public Class<O> getInternalClass() {
        return internalClass;
    }
}
