/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: ImageValidationUI.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-runtime/src/main/java/jaxx/runtime/validator/swing/ui/ImageValidationUI.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator.swing.ui;

import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorScope;
import org.jdesktop.jxlayer.JXLayer;

import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;


/**
 * An implementation of {@link AbstractBeanValidatorUI} which paints a icon on
 * top right corner.
 *
 * @author tchemit <chemit@codelutin.com>
 */
public class ImageValidationUI extends AbstractBeanValidatorUI {

    protected static BufferedImage errorIcon;

    protected static BufferedImage warningIcon;

    protected static BufferedImage infoIcon;

    public ImageValidationUI(BeanValidatorField<?> field) {
        super(field);
        if (errorIcon == null) {
            errorIcon = prepareIcon(SwingUtil.createImageIcon("error.png"));
        }
        if (warningIcon == null) {
            warningIcon = prepareIcon(SwingUtil.createImageIcon("warning.png"));
        }
        if (infoIcon == null) {
            infoIcon = prepareIcon(SwingUtil.createImageIcon("info.png"));
        }
    }

    protected static BufferedImage prepareIcon(ImageIcon image) {
        BufferedImage icon = new BufferedImage(image.getIconWidth(), image.getIconHeight(), BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = (Graphics2D) icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.drawImage(image.getImage(), 0, 0, null);
        g2.dispose();
        return icon;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        super.paintLayer(g2, l);
        BeanValidatorScope scope = field.getScope();
        if (scope != null) {
            BufferedImage icon = null;
            switch (scope) {
                case ERROR:
                    icon = errorIcon;
                    break;
                case WARNING:
                    icon = warningIcon;
                    break;
                case INFO:
                    icon = infoIcon;
                    break;
            }
            if (icon != null) {
                g2.drawImage(icon, l.getWidth() - icon.getWidth() - 1, 0, null);
            }
        }
    }
}
