/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: NavigationTreeTableModel.java 1847 2010-04-16 12:27:48Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.0.2/jaxx-runtime/src/main/java/jaxx/runtime/swing/navigation/treetable/NavigationTreeTableModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.navigation.treetable;

import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.AbstractNavigationModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableModel;

import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import java.util.List;

/**
 * Model of the tree table used for a navigation tree table.
 * <p/>
 * Il est composé de {@link NavigationTreeNode}
 * <p/>
 * FIXME : Essayer d'enlever les copier coller {@link NavigationTreeModel}
 *
 * @author sletellier
 * @since 2.0.0
 */
public class NavigationTreeTableModel extends AbstractNavigationModel<NavigationTreeTableNode> implements TreeTableModel {

    /** Logger */
    static private final Log log =
            LogFactory.getLog(NavigationTreeTableModel.class);

    public static class MyDefaultTreeTableModel extends DefaultTreeTableModel {

        public TreeModelSupport getModelSupport() {
            return modelSupport;
        }
    }

    protected List<String> columnsName;

    public NavigationTreeTableModel(MyDefaultTreeTableModel delegate,
                                    String pathSeparator,
                                    JAXXContext context,
                                    List<String> columnsName) {
        super(delegate, pathSeparator, context);
        this.columnsName = columnsName;
    }

    public NavigationTreeTableModel(String pathSeparator, JAXXContext context, List<String> columnsName) {
        super(new MyDefaultTreeTableModel(), pathSeparator, context);
        this.columnsName = columnsName;
    }


    public MyDefaultTreeTableModel getDelegate() {
        return (MyDefaultTreeTableModel) delegate;
    }

    @Override
    public NavigationTreeTableNode[] getPathToRoot(NavigationTreeTableNode aNode) {
        if (aNode == null) {
            return null;
        }
        TreeNode[] treeNodes = getDelegate().getPathToRoot(aNode);
        NavigationTreeTableNode[] result = new NavigationTreeTableNode[treeNodes.length];
        System.arraycopy(treeNodes, 0, result, 0, treeNodes.length);
        return result;

    }

    @Override
    public void setRoot(NavigationTreeTableNode root) {
        getDelegate().setRoot(root);
        getModelSupport().fireNewRoot();
    }

    /**
     * Message this to remove node from its parent. This will message
     * nodesWereRemoved to create the appropriate event. This is the preferred
     * way to remove a node as it handles the event creation for you.
     */
    @Override
    public void removeNodeFromParent(NavigationTreeTableNode node) {
        NavigationTreeTableNode parent = node.getParent();

        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }

        int index = parent.getIndex(node);
        node.removeFromParent();
        getModelSupport().fireChildRemoved(new TreePath(getPathToRoot(parent)),
                                           index, node);
    }

    /**
     * Accessor to tree model support.
     *
     * @return tree model support
     */
    protected TreeModelSupport getModelSupport() {
        return getDelegate().getModelSupport();
    }

    @Override
    public void nodeStructureChanged(NavigationTreeTableNode node) {
        if (node != null) {
            NavigationTreeTableNode parent = node.getParent();
            if (parent == null || parent.isRoot()){
                getModelSupport().fireNewRoot();
            } else {
                TreeNode[] treeNodes = getPathToRoot(parent);
                if (treeNodes != null) {
                    getModelSupport().fireTreeStructureChanged(new TreePath(treeNodes));
                }
                // FIXME : it's append....
//              else {
//                  log.error("[Node structure changed] Path to root is null !");
//              }
            }
            reload(node, true);
        } else {
            log.error("Node is null !");
        }
    }

    @Override
    public void nodeChanged(NavigationTreeTableNode node, boolean deep) {
        if (node != null) {
            NavigationTreeTableNode parent = node.getParent();
            TreeNode[] treeNodes = getPathToRoot(parent);
            if (treeNodes != null) {
                getModelSupport().fireChildChanged(
                        new TreePath(treeNodes), parent.getIndex(node), node);
                // FIXME : it's append....
//              else {
//                  log.error("[Node changed] Path to root is null !");
//              }
            }
            reload(node, deep);
        } else {
            log.error("Node is null !");
        }
    }

    @Override
    public Class<?> getColumnClass(int i) {
        return getDelegate().getColumnClass(i);
    }

    @Override
    public int getColumnCount() {
        return columnsName.size();
    }

    @Override
    public String getColumnName(int column) {
        return columnsName.get(column);
    }

    @Override
    public int getHierarchicalColumn() {
        return getDelegate().getHierarchicalColumn();
    }

    @Override
    public Object getValueAt(Object o, int i) {
        return getDelegate().getValueAt(o, i);
    }

    @Override
    public boolean isCellEditable(Object o, int i) {
        return getDelegate().isCellEditable(o, i);
    }

    @Override
    public void setValueAt(Object o, Object o1, int i) {
        getDelegate().setValueAt(o, o1, i);
    }

}
