/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

import javax.swing.tree.TreeCellRenderer;
import java.io.Serializable;

/**
 * Text Renderer of a {@link NavigationNode}.
 * <p/>
 * This object will be placed as the {@link NavigationNode#getUserObject()} of
 * nodes.
 * <p/>
 * <p/>
 * In that way, we can use the {@link #toString()} value to render the node
 * without writing any {@link TreeCellRenderer}.
 * <p/>
 * To rebuild the renderer text of a node use the method {@link #reload(Object)}
 * with the {@code bean} provides by the model for the node.
 *
 * @author chemit
 * @since 1.7.2, replace {@code NavigationUtil#NodeRenderer} which disappear
 *        soon...
 */
public interface NavigationNodeRenderer extends Serializable {

    /** @return the render value of the node */
    @Override
    String toString();

    /**
     * Can override the node internal class for display purpose.
     *
     * @return the type of data to be displayed.
     */
    Class<?> getInternalClass();

    /**
     * Reload the render value from the {@code bean} of node.
     *
     * @param bean the bean associated to the node to render
     */
    void reload(Object bean);
}
