/*
 * *##% 
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime;

import jaxx.runtime.context.JAXXInitialContext;

/**
 * This is the contract to be realized by any class to be used as Action class for an ui.
 *
 * @author chemit
 */
public interface JAXXAction {

    /**
     * Prepare the initial context of the ui.
     *
     * @param parentContent the context of the parent of the ui (can be null if no parent is required)
     * @param datas         other datas to inject in initial context
     * @return the {@link jaxx.runtime.context.JAXXInitialContext} to be injected in the ui via the constructor of the {@link jaxx.runtime.JAXXObject}
     */
    JAXXInitialContext init(JAXXContext parentContent, Object... datas);

}
