package org.nuiton.jaxx.runtime.api.swing;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import java.net.URL;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class Icons {


    public static final String DEFAULT_ICON_PATH = "/icons/";

    public static final String DEFAULT_ICON_PATH_PROPERTY = "default.icon.path";

    public static ImageIcon createIcon(String path) {
        URL imgURL = Icons.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            throw new IllegalArgumentException("could not find icon " + path);
        }
    }

    /**
     * @param path the location of icons in root directory icons
     * @return the icon at {@link #getIconPath()}+path
     */
    public static ImageIcon createImageIcon(String path) {
        String iconPath = getIconPath();
        return createIcon(iconPath + path);
    }

    /**
     * @param key the key of the icon to retreave from {@link UIManager}
     * @return the icon, or <code>null if no icon found in {@link UIManager}
     */
    public static Icon getUIManagerIcon(String key) {
        return UIManager.getIcon(key);
    }

    /**
     * retreave for the {@link UIManager} the icon prefixed by {@code action}.
     *
     * @param key the key of the action icon to retreave from {@link UIManager}
     * @return the icon, or <code>null if no icon found in {@link UIManager}
     */
    public static Icon getUIManagerActionIcon(String key) {
        return getUIManagerIcon("action." + key);
    }

    public static ImageIcon createActionIcon(String name) {
        String iconPath = getIconPath();
        return createIcon(iconPath + "action-" + name + ".png");
    }

    public static ImageIcon createI18nIcon(String name) {
        String iconPath = getIconPath();
        return createIcon(iconPath + "i18n/" + name + ".png");
    }

    private static String getIconPath() {
        String iconPath = UIManager.getString(DEFAULT_ICON_PATH_PROPERTY);
        if (iconPath == null) {
            iconPath = DEFAULT_ICON_PATH;
        } else {
            if (!iconPath.endsWith("/")) {
                iconPath += "/";
            }
        }
        return iconPath;
    }
}
