/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.beans.Statement;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Iterator;
import org.nuiton.util.TransparenteWeakReference;

public class ListenerSet<Listener>
implements Iterable<Listener> {
    protected HashSet<Reference<Listener>> listeners = new HashSet();

    public int size() {
        return this.listeners.size();
    }

    public void add(Listener l) {
        if (l == null) {
            return;
        }
        TransparenteWeakReference<Listener> ref = new TransparenteWeakReference<Listener>(l);
        this.listeners.add(ref);
    }

    public void addAll(ListenerSet<Listener> ls) {
        this.listeners.addAll(ls.listeners);
    }

    public void fire(String methodName, Object event) throws Exception {
        for (Listener o : this) {
            Statement stm = new Statement(o, methodName, new Object[]{event});
            stm.execute();
        }
    }

    public void fire(String methodName) throws Exception {
        for (Listener o : this) {
            Statement stm = new Statement(o, methodName, null);
            stm.execute();
        }
    }

    @Override
    public Iterator<Listener> iterator() {
        return new ReferenceIterator(this.listeners.iterator());
    }

    public void remove(Listener l) {
        TransparenteWeakReference<Listener> ref = new TransparenteWeakReference<Listener>(l);
        this.listeners.remove(ref);
    }

    public String toString() {
        return "" + this.listeners;
    }

    static class ReferenceIterator<T>
    implements Iterator<T> {
        protected Iterator<Reference<T>> iter = null;
        protected T nextObject = null;

        public ReferenceIterator(Iterator<Reference<T>> iter) {
            this.iter = iter;
            this.findNext();
        }

        protected void findNext() {
            while (this.iter.hasNext() && this.nextObject == null) {
                Reference<T> ref = this.iter.next();
                T o = ref.get();
                if (o != null) {
                    this.nextObject = o;
                    continue;
                }
                this.iter.remove();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextObject != null;
        }

        @Override
        public T next() {
            T result = this.nextObject;
            this.nextObject = null;
            this.findNext();
            return result;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

