/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.swing;

import colorzoo.swing.DefaultMultiThumbModel;
import colorzoo.swing.MultiThumbModel;
import colorzoo.swing.ThumbDataEvent;
import colorzoo.swing.ThumbDataListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMultiThumbSlider<E>
extends JComponent {
    private ThumbDataListener tdl;
    public List<ThumbComp> thumbs;
    private ThumbRenderer thumbRenderer;
    private TrackRenderer trackRenderer;
    private MultiThumbModel<E> model;
    List<ThumbListener> listeners = new ArrayList<ThumbListener>();
    ThumbComp selected;

    public JMultiThumbSlider() {
        this.thumbs = new ArrayList<ThumbComp>();
        this.setLayout(null);
        this.tdl = new ThumbDataListener(){

            public void positionChanged(ThumbDataEvent thumbDataEvent) {
                System.out.println("position changed");
            }

            public void thumbAdded(ThumbDataEvent thumbDataEvent) {
                ThumbComp thumbComp = new ThumbComp(JMultiThumbSlider.this);
                thumbComp.setLocation(0, 0);
                JMultiThumbSlider.this.add(thumbComp);
                JMultiThumbSlider.this.thumbs.add(thumbDataEvent.getIndex(), thumbComp);
                JMultiThumbSlider.this.clipThumbPosition(thumbComp);
                JMultiThumbSlider.this.setThumbXByPosition(thumbComp, thumbDataEvent.getThumb().getPosition());
                JMultiThumbSlider.this.repaint();
            }

            public void thumbRemoved(ThumbDataEvent thumbDataEvent) {
                ThumbComp thumbComp = JMultiThumbSlider.this.thumbs.get(thumbDataEvent.getIndex());
                JMultiThumbSlider.this.remove(thumbComp);
                JMultiThumbSlider.this.thumbs.remove(thumbComp);
                JMultiThumbSlider.this.repaint();
            }

            public void valueChanged(ThumbDataEvent thumbDataEvent) {
                System.out.println("value changed");
            }
        };
        this.setModel(new DefaultMultiThumbModel());
        MultiThumbMouseListener multiThumbMouseListener = new MultiThumbMouseListener(this);
        this.addMouseListener(multiThumbMouseListener);
        this.addMouseMotionListener(multiThumbMouseListener);
        Dimension dimension = new Dimension(20, 20);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        dimension = new Dimension(10, 10);
        this.setMinimumSize(dimension);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isVisible()) {
            if (this.trackRenderer != null) {
                this.trackRenderer.paintTrack((Graphics2D)graphics, this);
            } else {
                this.paintRange((Graphics2D)graphics);
            }
        }
    }

    private void paintRange(Graphics2D graphics2D) {
        graphics2D.setColor(Color.blue);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private float getThumbValue(int n) {
        return this.getModel().getThumbAt(n).getPosition();
    }

    private float getThumbValue(ThumbComp thumbComp) {
        return this.getThumbValue(this.thumbs.indexOf(thumbComp));
    }

    private int getThumbIndex(ThumbComp thumbComp) {
        return this.thumbs.indexOf(thumbComp);
    }

    private void clipThumbPosition(ThumbComp thumbComp) {
        if (this.getThumbValue(thumbComp) < this.getModel().getMinimumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumbComp)).setPosition(this.getModel().getMinimumValue());
        }
        if (this.getThumbValue(thumbComp) > this.getModel().getMaximumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumbComp)).setPosition(this.getModel().getMaximumValue());
        }
    }

    public ThumbRenderer getThumbRenderer() {
        return this.thumbRenderer;
    }

    public void setThumbRenderer(ThumbRenderer thumbRenderer) {
        this.thumbRenderer = thumbRenderer;
    }

    public TrackRenderer getTrackRenderer() {
        return this.trackRenderer;
    }

    public void setTrackRenderer(TrackRenderer trackRenderer) {
        this.trackRenderer = trackRenderer;
    }

    private void setThumbPositionByX(ThumbComp thumbComp) {
        float f = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        int n = thumbComp.getX();
        n += thumbComp.getWidth() / 2;
        int n2 = this.getWidth();
        float f2 = (float)(n -= thumbComp.getWidth() / 2) / (float)(n2 -= thumbComp.getWidth());
        int n3 = this.getThumbIndex(thumbComp);
        float f3 = f2 * f;
        this.getModel().getThumbAt(n3).setPosition(f3);
        this.clipThumbPosition(thumbComp);
    }

    private void setThumbXByPosition(ThumbComp thumbComp, float f) {
        float f2 = f;
        float f3 = this.getWidth() - thumbComp.getWidth();
        float f4 = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        float f5 = f2 * f3 / f4;
        thumbComp.setLocation((int)f5 - thumbComp.getWidth() / 2 + thumbComp.getWidth() / 2, thumbComp.getY());
    }

    public void recalc() {
        for (ThumbComp thumbComp : this.thumbs) {
            this.setThumbXByPosition(thumbComp, this.getModel().getThumbAt(this.getThumbIndex(thumbComp)).getPosition());
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.recalc();
    }

    public ThumbComp getSelectedThumb() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.getThumbIndex(this.selected);
    }

    public MultiThumbModel<E> getModel() {
        return this.model;
    }

    public void setModel(MultiThumbModel<E> multiThumbModel) {
        if (this.model != null) {
            this.model.removeThumbDataListener(this.tdl);
        }
        this.model = multiThumbModel;
        this.model.addThumbDataListener(this.tdl);
    }

    public void addMultiThumbListener(ThumbListener thumbListener) {
        this.listeners.add(thumbListener);
    }

    public class ThumbComp
    extends JComponent {
        private JMultiThumbSlider slider;
        private boolean selected;

        public ThumbComp(JMultiThumbSlider jMultiThumbSlider2) {
            this.slider = jMultiThumbSlider2;
            Dimension dimension = new Dimension(11, 22);
            this.setSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
        }

        public void paintComponent(Graphics graphics) {
            if (this.slider.getThumbRenderer() != null) {
                this.slider.getThumbRenderer().paintThumb((Graphics2D)graphics, this, this.slider.getThumbIndex(this), this.isSelected());
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isSelected()) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }
    }

    public static interface TrackRenderer {
        public void paintTrack(Graphics2D var1, JMultiThumbSlider var2);
    }

    public static interface ThumbRenderer {
        public void paintThumb(Graphics2D var1, ThumbComp var2, int var3, boolean var4);
    }

    public static interface ThumbListener {
        public void thumbMoved(int var1, float var2);

        public void thumbSelected(int var1);

        public void mousePressed(MouseEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultiThumbMouseListener
    extends MouseInputAdapter {
        private JMultiThumbSlider slider;

        public MultiThumbMouseListener(JMultiThumbSlider jMultiThumbSlider2) {
            this.slider = jMultiThumbSlider2;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ThumbComp thumbComp = this.findHandle(mouseEvent);
            if (thumbComp != null) {
                JMultiThumbSlider.this.selected = thumbComp;
                JMultiThumbSlider.this.selected.setSelected(true);
                int n = JMultiThumbSlider.this.getThumbIndex(JMultiThumbSlider.this.selected);
                for (ThumbListener thumbListener : JMultiThumbSlider.this.listeners) {
                    thumbListener.thumbSelected(n);
                }
                JMultiThumbSlider.this.repaint();
            } else {
                JMultiThumbSlider.this.selected = null;
                for (ThumbListener thumbListener : JMultiThumbSlider.this.listeners) {
                    thumbListener.thumbSelected(-1);
                }
                JMultiThumbSlider.this.repaint();
            }
            for (ThumbListener thumbListener : JMultiThumbSlider.this.listeners) {
                thumbListener.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (JMultiThumbSlider.this.selected != null) {
                JMultiThumbSlider.this.selected.setSelected(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JMultiThumbSlider.this.selected != null) {
                int n = (int)mouseEvent.getPoint().getX() - JMultiThumbSlider.this.selected.getWidth() / 2;
                if (n < 0) {
                    n = 0;
                }
                if (n > JMultiThumbSlider.this.getWidth() - JMultiThumbSlider.this.selected.getWidth()) {
                    n = JMultiThumbSlider.this.getWidth() - JMultiThumbSlider.this.selected.getWidth();
                }
                JMultiThumbSlider.this.selected.setLocation(n, (int)JMultiThumbSlider.this.selected.getLocation().getY());
                JMultiThumbSlider.this.setThumbPositionByX(JMultiThumbSlider.this.selected);
                int n2 = JMultiThumbSlider.this.getThumbIndex(JMultiThumbSlider.this.selected);
                for (ThumbListener thumbListener : JMultiThumbSlider.this.listeners) {
                    thumbListener.thumbMoved(n2, JMultiThumbSlider.this.getModel().getThumbAt(n2).getPosition());
                }
                JMultiThumbSlider.this.repaint();
            }
        }

        private ThumbComp findHandle(MouseEvent mouseEvent) {
            for (ThumbComp thumbComp : JMultiThumbSlider.this.thumbs) {
                Point point = new Point();
                point.setLocation(mouseEvent.getPoint().getX() - (double)thumbComp.getX(), mouseEvent.getPoint().getY() - (double)thumbComp.getY());
                if (!thumbComp.contains(point)) continue;
                return thumbComp;
            }
            return null;
        }
    }
}

