/*
 * Decompiled with CFR 0.152.
 */
package colorzoo;

import colorzoo.ColorPanel;
import colorzoo.HuePanel;
import colorzoo.SaturationBrightnessPanel;
import colorzoo.schemeeditor.ColorSchemeBuilder;
import colorzoo.swing.gradient.GradientPicker;
import colorzoo.tilebuilder.TileBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        final JFrame jFrame = new JFrame("Gradient Picker");
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 1));
        JButton jButton = new JButton("Select Gradient");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color[] colorArray = new Color[]{Color.blue, Color.black};
                float[] fArray = new float[]{0.0f, 1.0f};
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 10.0f, 0.0f, fArray, colorArray);
                MultipleGradientPaint multipleGradientPaint = GradientPicker.showDialog(jFrame, "Pick a Gradient", linearGradientPaint);
                System.out.println("got: " + GradientPicker.toString(multipleGradientPaint));
            }
        });
        jFrame.add(jButton);
        JButton jButton2 = new JButton("Build a Tile");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame("Build a Tile");
                JMenu jMenu = new JMenu("File");
                final JMenuItem jMenuItem = new JMenuItem("Open");
                jMenu.add(jMenuItem);
                final JMenuItem jMenuItem2 = new JMenuItem("Save");
                jMenu.add(jMenuItem2);
                JMenuBar jMenuBar = new JMenuBar();
                jMenuBar.add(jMenu);
                jFrame.setJMenuBar(jMenuBar);
                final TileBuilder tileBuilder = new TileBuilder();
                jFrame.add(tileBuilder);
                jFrame.pack();
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("opening");
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.showOpenDialog(jMenuItem);
                        File file = jFileChooser.getSelectedFile();
                        if (file != null) {
                            try {
                                BufferedImage bufferedImage = ImageIO.read(file);
                                tileBuilder.realeditor.setTilePaint(bufferedImage);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        System.out.println("saving");
                        try {
                            int n = tileBuilder.realeditor.getGridwidth();
                            int n2 = tileBuilder.realeditor.getGridheight();
                            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                            Rectangle rectangle = new Rectangle(0, 0, n, n2);
                            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                            graphics2D.setPaint(tileBuilder.realeditor.getTilePaint());
                            graphics2D.fill(rectangle);
                            graphics2D.dispose();
                            JFileChooser jFileChooser = new JFileChooser();
                            jFileChooser.showSaveDialog(jMenuItem2);
                            File file = jFileChooser.getSelectedFile();
                            if (file != null) {
                                ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
                                System.out.println("saved: " + file);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("exception: " + exception);
                        }
                    }
                });
                jFrame.setVisible(true);
            }
        });
        jFrame.add(jButton2);
        JButton jButton3 = new JButton("pick a color");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = new JFrame();
                jFrame.add(new ColorSchemeBuilder());
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
        jFrame.add(jButton3);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jFrame.setJMenuBar(jMenuBar);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static void showPicker(int n) throws HeadlessException {
        JFrame jFrame = new JFrame("Frame");
        jFrame.setDefaultCloseOperation(3);
        ColorPanel colorPanel = new ColorPanel();
        SaturationBrightnessPanel saturationBrightnessPanel = new SaturationBrightnessPanel(n);
        saturationBrightnessPanel.col = colorPanel;
        HuePanel huePanel = new HuePanel();
        huePanel.sat = saturationBrightnessPanel;
        jFrame.add((Component)saturationBrightnessPanel, "Center");
        jFrame.add((Component)huePanel, "East");
        jFrame.add((Component)colorPanel, "South");
        jFrame.pack();
        jFrame.setSize(200, 200);
        jFrame.setVisible(true);
    }
}

