/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import jaxx.runtime.Decorator;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.Util;
import jaxx.runtime.swing.BooleanCellRenderer;
import jaxx.runtime.swing.DecoratorTableCellRenderer;
import jaxx.runtime.swing.EmptyNumberTableCellRenderer;
import jaxx.runtime.swing.EnumTableCellRenderer;
import jaxx.runtime.swing.I18nTableCellRenderer;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.JXLayer;

public class SwingUtil
extends Util {
    private static final Log log = LogFactory.getLog(SwingUtil.class);
    private static Field numReaders;
    private static Field notifyingListeners;
    public static final String ICON_PREFIX = "icon.";
    public static final String COLOR_PREFIX = "color.";

    public static Dimension newMinDimension() {
        return new Dimension(0, 0);
    }

    public static Dimension newMaxXDimension() {
        return new Dimension(Short.MAX_VALUE, 0);
    }

    public static Dimension newMaxYDimension() {
        return new Dimension(0, Short.MAX_VALUE);
    }

    public static Dimension newMaxXYDimension() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public static void setText(final JTextComponent c, final String text) {
        try {
            AbstractDocument document = (AbstractDocument)c.getDocument();
            if (numReaders == null) {
                numReaders = AbstractDocument.class.getDeclaredField("numReaders");
                numReaders.setAccessible(true);
            }
            if (notifyingListeners == null) {
                notifyingListeners = AbstractDocument.class.getDeclaredField("notifyingListeners");
                notifyingListeners.setAccessible(true);
            }
            if (notifyingListeners.get(document).equals(Boolean.TRUE)) {
                return;
            }
            if ((Integer)numReaders.get(document) > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!c.getText().equals(text)) {
                            c.setText(text);
                        }
                    }
                });
                return;
            }
            String oldText = c.getText();
            if (oldText == null || !oldText.equals(text)) {
                c.setText(text);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            c.setText(text);
        }
    }

    public static void fillComboBox(JComboBox combo, Collection<?> data, Object select) {
        if (!(combo.getModel() instanceof DefaultComboBoxModel)) {
            throw new IllegalArgumentException("this method need a DefaultComboBoxModel for this model but was " + combo.getModel().getClass());
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
        model.removeListDataListener(combo);
        model.removeAllElements();
        if (data != null) {
            for (Object o : data) {
                model.addElement(o);
            }
        }
        model.addListDataListener(combo);
        model.setSelectedItem(select);
    }

    public static void fillComboBox(JAXXComboBox combo, Collection<?> data, Object select, boolean firstNull) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (firstNull) {
            items.add(new Item("null", " ", null, false));
        }
        if (data != null) {
            for (Object d : data) {
                items.add(new Item(d.toString(), d.toString(), d, d.equals(select)));
            }
        }
        combo.setItems(items);
    }

    public static void fixTableColumnWidth(JTable table, int columnIndex, int width) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setMaxWidth(width);
        column.setMinWidth(width);
        column.setWidth(width);
        column.setPreferredWidth(width);
    }

    public static void setTableColumnEditor(JTable table, int columnIndex, TableCellEditor editor) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellEditor(editor);
    }

    public static void setTableColumnRenderer(JTable table, int columnIndex, TableCellRenderer editor) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        column.setCellRenderer(editor);
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        table.getTableHeader().setDefaultRenderer(new I18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles));
    }

    public static TableCellRenderer newStringTableCellRenderer(final DefaultTableCellRenderer renderer, final int length, final boolean tooltip) {
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val;
                renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String val2 = val = renderer.getText();
                if (val.length() > length) {
                    val2 = val.substring(0, length - 3) + "...";
                }
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, val2, isSelected, hasFocus, row, column);
                if (tooltip) {
                    comp.setToolTipText(val);
                }
                return comp;
            }
        };
    }

    public static JXLayer<?> boxComponentWithJxLayer(JComponent component) {
        JXLayer layer = SwingUtil.getLayer(component);
        if (layer != null) {
            return layer;
        }
        layer = new JXLayer();
        layer.add((Component)component);
        return layer;
    }

    public static List<JComponent> getLayeredComponents(JAXXObject object) {
        ArrayList<JComponent> result = new ArrayList<JComponent>();
        for (Map.Entry child : object.get$objectMap().entrySet()) {
            JComponent comp;
            if (child.getValue() == null) {
                log.warn((Object)("find a null object in $objectMap " + (String)child.getKey()));
                continue;
            }
            if (!JComponent.class.isAssignableFrom(child.getValue().getClass()) || !SwingUtil.isLayered(comp = (JComponent)child.getValue())) continue;
            result.add(comp);
        }
        return result;
    }

    public static JXLayer<JComponent> getLayer(JComponent comp) {
        if (!SwingUtil.isLayered(comp)) {
            return null;
        }
        return (JXLayer)comp.getParent();
    }

    public static boolean isLayered(JComponent comp) {
        Container parent = comp.getParent();
        return parent != null && parent instanceof JXLayer;
    }

    public static Map<String, JComponent> lookingForEditor(Class<?> clazz, Container container) {
        HashMap<String, JComponent> result = new HashMap<String, JComponent>();
        try {
            String name;
            HashMap<String, JComponent> allNamedComponent = new HashMap<String, JComponent>();
            LinkedList<Container> todo = new LinkedList<Container>();
            todo.add(container);
            while (todo.size() > 0) {
                ListIterator<Container> i = todo.listIterator();
                while (i.hasNext()) {
                    Container parent = (Container)i.next();
                    i.remove();
                    for (Component c : parent.getComponents()) {
                        if (!(c instanceof Container)) continue;
                        i.add((Container)c);
                        name = c.getName();
                        if (!(c instanceof JComponent) || name == null || "".equals(name)) continue;
                        allNamedComponent.put(name, (JComponent)c);
                    }
                }
            }
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (PropertyDescriptor prop : props) {
                name = prop.getName();
                if (!allNamedComponent.containsKey(name)) continue;
                result.put(name, (JComponent)allNamedComponent.get(name));
            }
        }
        catch (IntrospectionException eee) {
            log.warn((Object)"Can't introspect bean", (Throwable)eee);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result: " + result));
        }
        return result;
    }

    public static void center(Component parent, Component component) {
        if (parent == null) {
            return;
        }
        Rectangle r = parent.getBounds();
        int x = r.x + (r.width - component.getSize().width) / 2;
        int y = r.y + (r.height - component.getSize().height) / 2;
        component.setLocation(x, y);
    }

    public static void initNimbusLoookAndFeel() throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (!"Nimbus".equals(laf.getName())) continue;
            UIManager.setLookAndFeel(laf.getClassName());
        }
    }

    public static void loadUIConfig(String defaultUIConfig, String extraUIConfig) throws IOException {
        Properties p = new Properties();
        log.info((Object)("loading default UI config " + defaultUIConfig));
        p.load(SwingUtil.class.getResourceAsStream(defaultUIConfig));
        if (log.isDebugEnabled()) {
            log.debug((Object)p.toString());
        }
        if (extraUIConfig != null) {
            InputStream extraStream = SwingUtil.class.getResourceAsStream(extraUIConfig);
            if (extraStream == null) {
                log.warn((Object)("could not find extraUIConfig : " + extraUIConfig));
            } else {
                log.info((Object)("loading extra UI config " + extraUIConfig));
                Properties p2 = new Properties(p);
                p2.load(extraStream);
                if (log.isDebugEnabled()) {
                    log.debug((Object)p2.toString());
                }
                p.putAll((Map<?, ?>)p2);
            }
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith(ICON_PREFIX)) {
                try {
                    ImageIcon icon = SwingUtil.createImageIcon((String)((String)entry.getValue()));
                    UIManager.put(key.substring(ICON_PREFIX.length()), icon);
                }
                catch (Exception e) {
                    log.warn((Object)("could not load icon " + entry.getValue()));
                }
                continue;
            }
            if (!key.startsWith(COLOR_PREFIX)) continue;
            String value = (String)entry.getValue();
            String[] rgb = value.split(",");
            UIManager.put(key.substring(COLOR_PREFIX.length()), new Color(Integer.valueOf(rgb[0]), Integer.valueOf(rgb[1]), Integer.valueOf(rgb[2])));
        }
    }

    public static TabbedPaneIterator<Component> newTabbedPaneIterator(JTabbedPane tabs) {
        return new TabbedPaneIterator<Component>(false, tabs){

            @Override
            protected Component get(int index, Component comp) {
                return comp;
            }
        };
    }

    public static JLabel newLabel(String text, Object iconKey, int aligment) {
        Icon icon = null;
        if (iconKey instanceof Icon) {
            icon = (Icon)iconKey;
        } else if (iconKey instanceof String) {
            icon = Util.getUIManagerActionIcon((String)((String)iconKey));
        }
        JLabel result = icon == null ? new JLabel(text, aligment) : new JLabel(text, icon, aligment);
        return result;
    }

    public static Component getDeepestObjectAt(Component parent, int x, int y) {
        Container cont;
        Component child;
        if (parent instanceof Container && (child = SwingUtil.findComponentAt(cont = (Container)parent, cont.getWidth(), cont.getHeight(), x, y)) != null && child != cont) {
            if (child instanceof JRootPane) {
                JLayeredPane lp = ((JRootPane)child).getLayeredPane();
                Rectangle b = lp.getBounds();
                child = SwingUtil.getDeepestObjectAt(lp, x - b.x, y - b.y);
            }
            if (child != null) {
                return child;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component findComponentAt(Container cont, int width, int height, int x, int y) {
        Object object = cont.getTreeLock();
        synchronized (object) {
            JXLayer layer;
            Rectangle rect;
            Component comp;
            int i;
            if (x < 0 || x >= width || y < 0 || y >= height || !cont.isVisible() || !cont.isEnabled()) {
                return null;
            }
            Component[] component = cont.getComponents();
            int ncomponents = cont.getComponentCount();
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                rect = null;
                if (comp == null || comp.isLightweight()) continue;
                if (rect == null || rect.width == 0 || rect.height == 0) {
                    rect = comp.getBounds();
                }
                if (comp instanceof JXLayer) {
                    layer = (JXLayer)comp;
                    comp = layer.getView();
                }
                if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            for (i = 0; i < ncomponents; ++i) {
                comp = component[i];
                rect = null;
                if (comp == null || !comp.isLightweight()) continue;
                if (rect == null || rect.width == 0 || rect.height == 0) {
                    rect = comp.getBounds();
                }
                if (comp instanceof JXLayer) {
                    layer = (JXLayer)comp;
                    comp = layer.getView();
                }
                if ((comp = comp instanceof Container ? SwingUtil.findComponentAt((Container)comp, rect.width, rect.height, x - rect.x, y - rect.y) : comp.getComponentAt(x - rect.x, y - rect.y)) == null || !comp.isVisible() || !comp.isEnabled()) continue;
                return comp;
            }
            return cont;
        }
    }

    public static <O> DefaultListCellRenderer newDecoratedListCellRenderer(final Decorator<O> decorator) {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String decorated = value instanceof String ? (String)value : decorator.toString(value);
                JComponent component = (JComponent)super.getListCellRendererComponent((JList<?>)list, decorated, index, isSelected, cellHasFocus);
                return component;
            }
        };
    }

    public static TableCellRenderer newDeleteCellRenderer(DefaultTableCellRenderer renderer) {
        Icon icon = UIManager.getIcon("Table.removeIcon");
        if (icon == null) {
            icon = SwingUtil.createActionIcon((String)"delete");
        }
        return new BooleanCellRenderer(renderer, icon);
    }

    public static TableCellRenderer newBooleanTableCellRenderer(DefaultTableCellRenderer renderer) {
        return new BooleanCellRenderer(renderer);
    }

    public static DecoratorTableCellRenderer newDecorateTableCellRenderer(TableCellRenderer renderer, Decorator<?> decorator) {
        return new DecoratorTableCellRenderer(renderer, decorator);
    }

    public static EmptyNumberTableCellRenderer newEmptyNumberTableCellRenderer(TableCellRenderer renderer) {
        return new EmptyNumberTableCellRenderer(renderer);
    }

    public static <E extends Enum<E>> EnumTableCellRenderer<E> newEnumTableCellRenderer(TableCellRenderer renderer, Class<E> enumClass) {
        return new EnumTableCellRenderer<E>(renderer, enumClass);
    }

    public static void openLink(HyperlinkEvent he) {
        block6: {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") || u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while opening link", (Throwable)e);
                    }
                }
                catch (URISyntaxException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
        }
    }

    public static abstract class TabbedPaneIterator<O>
    implements Iterator<O> {
        final JTabbedPane tabs;
        boolean reverse;
        int index;
        int increment;

        protected abstract O get(int var1, Component var2);

        public TabbedPaneIterator(boolean reverse, JTabbedPane tabs) {
            this.tabs = tabs;
            this.setReverse(reverse);
        }

        public void reset() {
            this.setReverse(this.reverse);
        }

        public int size() {
            return this.tabs.getTabCount();
        }

        public TabbedPaneIterator<O> reverse() {
            this.setReverse(!this.reverse);
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.reverse ? this.index > 0 : this.index < this.tabs.getTabCount();
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public O next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Component next = this.tabs.getComponentAt(this.index);
            O result = this.get(this.index, next);
            this.index += this.increment;
            return result;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("not implemented for " + this);
        }

        public String toString() {
            return super.toString() + "< reverse:" + this.reverse + ", index:" + this.index + ", size:" + this.tabs.getTabCount() + " >";
        }

        protected void setReverse(boolean reverse) {
            if (reverse) {
                this.index = this.tabs.getTabCount() - 1;
                this.increment = -1;
            } else {
                this.index = 0;
                this.increment = 1;
            }
            this.reverse = reverse;
        }
    }
}

